/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.registry;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.config.AsyncHttpClientConfigHelper;
import org.asynchttpclient.extras.registry.AsyncHttpClientFactory;
import org.asynchttpclient.extras.registry.AsyncHttpClientImplException;

public class AsyncImplHelper {
    public static final String ASYNC_HTTP_CLIENT_IMPL_SYSTEM_PROPERTY = "org.async.http.client.impl";
    public static final String ASYNC_HTTP_CLIENT_REGISTRY_SYSTEM_PROPERTY = "org.async.http.client.registry.impl";

    public static Class<AsyncHttpClient> getAsyncImplClass(String propertyName) {
        String asyncHttpClientImplClassName = AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getString(propertyName);
        if (asyncHttpClientImplClassName != null) {
            return AsyncImplHelper.getClass(asyncHttpClientImplClassName);
        }
        return null;
    }

    private static Class<AsyncHttpClient> getClass(final String asyncImplClassName) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class<AsyncHttpClient>>(){

                @Override
                public Class<AsyncHttpClient> run() throws ClassNotFoundException {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl != null) {
                        try {
                            return cl.loadClass(asyncImplClassName);
                        }
                        catch (ClassNotFoundException e) {
                            AsyncHttpClientFactory.logger.info("Couldn't find class : " + asyncImplClassName + " in thread context classpath checking system class path next", (Throwable)e);
                        }
                    }
                    cl = ClassLoader.getSystemClassLoader();
                    return cl.loadClass(asyncImplClassName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new AsyncHttpClientImplException("Class : " + asyncImplClassName + " couldn't be found in  the classpath due to : " + e.getMessage(), e);
        }
    }
}

