/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.junit.ant;

import java.net.UnknownHostException;
import java.util.Date;
import org.assertj.swing.junit.ant.HostNameReader;
import org.assertj.swing.junit.ant.TimestampFormatter;
import org.assertj.swing.junit.xml.XmlAttribute;
import org.assertj.swing.junit.xml.XmlNode;

class EnvironmentXmlNodeWriter {
    private static final String LOCALHOST = "localhost";
    private final TimestampFormatter timestampFormatter;
    private final HostNameReader hostNameReader;

    EnvironmentXmlNodeWriter() {
        this(new TimestampFormatter(), new HostNameReader());
    }

    EnvironmentXmlNodeWriter(TimestampFormatter timestampFormatter, HostNameReader hostNameReader) {
        this.timestampFormatter = timestampFormatter;
        this.hostNameReader = hostNameReader;
    }

    EnvironmentXmlNodeWriter writeTimestamp(XmlNode target) {
        target.addAttribute(XmlAttribute.name("timestamp").value(this.timestampFormatter.format(new Date())));
        return this;
    }

    EnvironmentXmlNodeWriter writeHostName(XmlNode target) {
        String hostName = null;
        try {
            hostName = this.hostNameReader.localHostName();
        }
        catch (UnknownHostException e) {
            hostName = LOCALHOST;
        }
        target.addAttribute(XmlAttribute.name("hostname").value(hostName));
        return this;
    }
}

