/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.io.ByteSource;
import java.io.IOException;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.guava.error.ShouldHaveSameContent;
import org.assertj.guava.error.ShouldHaveSize;

public class ByteSourceAssert
extends AbstractAssert<ByteSourceAssert, ByteSource> {
    protected ByteSourceAssert(ByteSource actual) {
        super((Object)actual, ByteSourceAssert.class);
    }

    public ByteSourceAssert hasSameContentAs(ByteSource other) throws IOException {
        this.isNotNull();
        if (!((ByteSource)this.actual).contentEquals(other)) {
            throw this.assertionError(ShouldHaveSameContent.shouldHaveSameContent((ByteSource)this.actual, other));
        }
        return this;
    }

    public void isEmpty() throws IOException {
        this.isNotNull();
        if (!((ByteSource)this.actual).isEmpty()) {
            throw this.assertionError(ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
    }

    public ByteSourceAssert hasSize(long expectedSize) throws IOException {
        this.isNotNull();
        long sizeOfActual = ((ByteSource)this.actual).size();
        if (sizeOfActual != expectedSize) {
            throw this.assertionError(ShouldHaveSize.shouldHaveSize(this.actual, sizeOfActual, expectedSize));
        }
        return this;
    }
}

