/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.HashSet;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.guava.error.ShouldContainValues;
import org.assertj.guava.error.ShouldHaveSize;
import org.assertj.guava.error.TableShouldContainCell;
import org.assertj.guava.error.TableShouldContainColumns;
import org.assertj.guava.error.TableShouldContainRows;
import org.assertj.guava.error.TableShouldHaveColumnCount;
import org.assertj.guava.error.TableShouldHaveRowCount;

public class TableAssert<R, C, V>
extends AbstractAssert<TableAssert<R, C, V>, Table<R, C, V>> {
    protected TableAssert(Table<R, C, V> actual) {
        super(actual, TableAssert.class);
    }

    public TableAssert<R, C, V> hasRowCount(int expectedSize) {
        this.isNotNull();
        this.checkExpectedSizeArgument(expectedSize);
        if (((Table)this.actual).rowKeySet().size() != expectedSize) {
            throw this.assertionError(TableShouldHaveRowCount.tableShouldHaveRowCount(this.actual, ((Table)this.actual).rowKeySet().size(), expectedSize));
        }
        return (TableAssert)this.myself;
    }

    public TableAssert<R, C, V> hasColumnCount(int expectedSize) {
        this.isNotNull();
        this.checkExpectedSizeArgument(expectedSize);
        if (((Table)this.actual).columnKeySet().size() != expectedSize) {
            throw this.assertionError(TableShouldHaveColumnCount.tableShouldHaveColumnCount(this.actual, ((Table)this.actual).columnKeySet().size(), expectedSize));
        }
        return (TableAssert)this.myself;
    }

    public TableAssert<R, C, V> hasSize(int expectedSize) {
        this.isNotNull();
        this.checkExpectedSizeArgument(expectedSize);
        if (((Table)this.actual).size() != expectedSize) {
            throw this.assertionError(ShouldHaveSize.shouldHaveSize(this.actual, ((Table)this.actual).size(), expectedSize));
        }
        return (TableAssert)this.myself;
    }

    public TableAssert<R, C, V> containsRows(R ... rows) {
        this.isNotNull();
        Preconditions.checkArgument((rows != null ? 1 : 0) != 0, (Object)"The rows to look for should not be null.");
        Preconditions.checkArgument((rows.length > 0 ? 1 : 0) != 0, (Object)"The rows to look for should not be empty.");
        HashSet rowsNotFound = Sets.newHashSet();
        for (R row : rows) {
            if (((Table)this.actual).containsRow(row)) continue;
            rowsNotFound.add(row);
        }
        if (!rowsNotFound.isEmpty()) {
            throw this.assertionError(TableShouldContainRows.tableShouldContainRows(this.actual, rows, rowsNotFound));
        }
        return (TableAssert)this.myself;
    }

    public TableAssert<R, C, V> containsColumns(C ... columns) {
        this.isNotNull();
        Preconditions.checkArgument((columns != null ? 1 : 0) != 0, (Object)"The columns to look for should not be null.");
        Preconditions.checkArgument((columns.length > 0 ? 1 : 0) != 0, (Object)"The columns to look for should not be empty.");
        HashSet columnsNotFound = Sets.newHashSet();
        for (C column : columns) {
            if (((Table)this.actual).containsColumn(column)) continue;
            columnsNotFound.add(column);
        }
        if (!columnsNotFound.isEmpty()) {
            throw this.assertionError(TableShouldContainColumns.tableShouldContainColumns(this.actual, columns, columnsNotFound));
        }
        return (TableAssert)this.myself;
    }

    public TableAssert<R, C, V> containsValues(V ... values) {
        this.isNotNull();
        Preconditions.checkArgument((values != null ? 1 : 0) != 0, (Object)"The values to look for should not be null.");
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"The values to look for should not be empty.");
        HashSet valuesNotFound = Sets.newHashSet();
        for (V value : values) {
            if (((Table)this.actual).containsValue(value)) continue;
            valuesNotFound.add(value);
        }
        if (!valuesNotFound.isEmpty()) {
            throw this.assertionError(ShouldContainValues.shouldContainValues(this.actual, values, valuesNotFound));
        }
        return (TableAssert)this.myself;
    }

    public TableAssert<R, C, V> containsCell(R row, C column, V expectedValue) {
        this.isNotNull();
        Preconditions.checkArgument((row != null ? 1 : 0) != 0, (Object)"The row to look for should not be null.");
        Preconditions.checkArgument((column != null ? 1 : 0) != 0, (Object)"The column to look for should not be null.");
        Preconditions.checkArgument((expectedValue != null ? 1 : 0) != 0, (Object)"The value to look for should not be null.");
        Object actualValue = ((Table)this.actual).get(row, column);
        if (!expectedValue.equals(actualValue)) {
            throw this.assertionError(TableShouldContainCell.tableShouldContainCell((Table)this.actual, row, column, expectedValue, actualValue));
        }
        return (TableAssert)this.myself;
    }

    public void isEmpty() {
        this.isNotNull();
        if (!((Table)this.actual).isEmpty()) {
            throw this.assertionError(ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
    }

    public TableAssert<R, C, V> isNotEmpty() {
        this.isNotNull();
        if (((Table)this.actual).isEmpty()) {
            throw this.assertionError(ShouldNotBeEmpty.shouldNotBeEmpty());
        }
        return (TableAssert)this.myself;
    }

    private void checkExpectedSizeArgument(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (Object)"The expected size should not be negative.");
    }
}

