/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.List;
import java.util.Map;
import org.asciidoctor.internal.AbstractBlock;
import org.asciidoctor.internal.Block;
import org.asciidoctor.internal.BlockImpl;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.runtime.builtin.IRubyObject;

public class AbstractBlockImpl
implements AbstractBlock {
    protected AbstractBlock delegate;
    protected Ruby runtime;

    public AbstractBlockImpl(AbstractBlock blockDelegate, Ruby runtime) {
        this.delegate = blockDelegate;
        this.runtime = runtime;
    }

    @Override
    public String id() {
        return this.delegate.id();
    }

    @Override
    public String title() {
        return this.delegate.title();
    }

    @Override
    public String role() {
        return this.delegate.role();
    }

    @Override
    public String style() {
        return this.delegate.style();
    }

    @Override
    public List<Block> blocks() {
        List<Block> rubyBlocks = this.delegate.blocks();
        int i = 0;
        while (i < rubyBlocks.size()) {
            if (!(rubyBlocks.get(i) instanceof RubyArray) && !(rubyBlocks.get(i) instanceof Block)) {
                Block blockRuby = RubyUtils.rubyToJava(this.runtime, (IRubyObject)((RubyObject)rubyBlocks.get(i)), Block.class);
                rubyBlocks.set(i, new BlockImpl(blockRuby, this.runtime));
            }
            ++i;
        }
        return rubyBlocks;
    }

    @Override
    public Map<String, Object> attributes() {
        return this.delegate.attributes();
    }

    @Override
    public Object content() {
        return this.delegate.content();
    }

    @Override
    public String render() {
        return this.delegate.render();
    }

    @Override
    public String context() {
        return this.delegate.context();
    }

    @Override
    public AbstractBlock delegate() {
        return this.delegate;
    }
}

