/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.installer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.settings.Settings;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Get;
import org.apache.tools.ant.taskdefs.Move;
import org.apache.tools.ant.types.FileSet;
import org.appfuse.mojo.installer.AntUtils;
import org.appfuse.tool.RenamePackages;
import org.appfuse.tool.SubversionUtils;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;

public class InstallSourceMojo
extends AbstractMojo {
    private static final String APPFUSE_GROUP_ID = "org.appfuse";
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String LINE_SEP = System.getProperty("line.separator");
    Project antProject = AntUtils.createProject();
    Properties appfuseProperties;
    private static final ThreadLocal<Map> propertiesContextHolder = new ThreadLocal();
    private String destinationDirectory;
    private String branch;
    private String trunk;
    private String tag;
    private MavenProject project;
    private Settings settings;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactRepository local;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String pom;
        String daoFramework;
        System.setProperty("file.encoding", "UTF-8");
        String appfuseVersion = this.project.getProperties().getProperty("appfuse.version");
        if (appfuseVersion != null && !appfuseVersion.endsWith("SNAPSHOT") && this.tag.equals("trunk/")) {
            this.tag = "tags/APPFUSE_" + appfuseVersion.toUpperCase().replaceAll("-", "_") + "/";
            if (this.tag.contains("_M")) {
                this.tag = this.tag.replace("_M", "-M");
            } else if (this.tag.contains("_R")) {
                this.tag = this.tag.replace("_R", "-R");
            }
        }
        if (!(this.branch == null || "".equals(this.branch) || "master".equals(this.branch) || "HEAD".equals(this.branch))) {
            this.log("Using branch: " + this.branch);
            this.tag = "branches/" + this.branch + "/";
        }
        if ((daoFramework = this.project.getProperties().getProperty("dao.framework")) == null) {
            this.log("No dao.framework property specified, defaulting to 'hibernate'");
        }
        String webFramework = this.project.getProperties().getProperty("web.framework");
        boolean modular = this.project.getPackaging().equals("pom");
        if (this.project.getPackaging().equals("jar") || this.project.getPackaging().equals("war") && this.project.getParentArtifact().getGroupId().contains("appfuse")) {
            this.log("Importing source from data-common module...");
            String coreSource = this.project.getBuild().getSourceDirectory();
            this.export("data/common/src", modular ? coreSource : this.destinationDirectory);
            File orig = new File((modular ? coreSource : this.destinationDirectory) + "/test/resources/hibernate.properties");
            File dest = new File((modular ? coreSource : this.destinationDirectory) + "/test/resources/hibernate.properties.orig");
            if (orig.exists() && webFramework != null && !webFramework.isEmpty()) {
                this.renameFile(orig, dest);
            }
            this.log("Importing source from " + daoFramework + " module...");
            this.export("data/" + daoFramework + "/src", modular ? coreSource : this.destinationDirectory);
            this.log("Importing source from service module...");
            this.export("service/src", modular ? coreSource : this.destinationDirectory);
            this.moveFiles(modular ? coreSource + "/main" : this.destinationDirectory + "/main", modular ? coreSource + "/test" : this.destinationDirectory + "/test", "**/Base*TestCase.java");
            this.deleteFile("test/resources/hibernate.cfg.xml");
            this.deleteFile("test/resources/META-INF");
            this.deleteFile("test/resources/sql-map-config.xml");
            if ("jpa".equalsIgnoreCase(daoFramework)) {
                this.deleteFile("main/resources/hibernate.cfg.xml");
            }
            if (dest.exists() && webFramework != null && !webFramework.isEmpty()) {
                this.deleteFile(orig.getPath());
                this.renameFile(dest, orig);
            }
            this.log("Source successfully imported!");
        }
        if (modular) {
            try {
                pom = FileUtils.readFileToString((File)new File("pom.xml"), (String)"UTF-8");
                pom = pom.replaceAll("  <modules>\n", "");
                pom = pom.replaceAll("    <module>.*?</module>\n", "");
                pom = pom.replaceAll("  </modules>\n", "");
                pom = pom.replace("<build>", "<modules>\n        <module>core</module>\n        <module>web</module>\n    </modules>\n\n    <build>");
                FileUtils.writeStringToFile((File)new File("pom.xml"), (String)pom, (String)"UTF-8");
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                pom = FileUtils.readFileToString((File)new File("core/pom.xml"), (String)"UTF-8");
                pom = pom.replaceAll("<dependencies>\n        <dependency>\n            <groupId>org.appfuse</groupId>\n            <artifactId>appfuse-data-common</artifactId>\n            <version>(.*?)appfuse.version}</version>\n        </dependency>", "<dependencies>");
                pom = pom.replaceAll("<version>(.*?)appfuse.version}</version>", "<version>$1appfuse.version}</version>\n            <type>pom</type>");
                pom = pom.replaceAll("<artifactId>hibernate4-maven-plugin</artifactId>\n                <configuration>", "<artifactId>hibernate4-maven-plugin</artifactId>\n                <configuration>\n                    <scanDependencies>none</scanDependencies>");
                pom = InstallSourceMojo.adjustLineEndingsForOS(pom);
                FileUtils.writeStringToFile((File)new File("core/pom.xml"), (String)pom, (String)"UTF-8");
            }
            catch (IOException io) {
                this.getLog().error((CharSequence)"Failed to change core module's dependencies to use <type>pom</type>.\nPlease make this change manually.");
            }
            try {
                pom = FileUtils.readFileToString((File)new File("web/pom.xml"), (String)"UTF-8");
                pom = pom.replaceAll("appfuse-hibernate", "*");
                pom = pom.replaceAll("<artifactId>hibernate4-maven-plugin</artifactId>", "<artifactId>hibernate4-maven-plugin</artifactId>\n                <configuration>\n                                        <scanDependencies>none</scanDependencies>\n                </configuration>");
                pom = InstallSourceMojo.adjustLineEndingsForOS(pom);
                FileUtils.writeStringToFile((File)new File("web/pom.xml"), (String)pom, (String)"UTF-8");
            }
            catch (IOException io) {
                this.getLog().error((CharSequence)"Failed to change web module to exclude AppFuse dependencies.\nPlease make this change manually: %s/appfuse-hibernate/*");
            }
        } else {
            try {
                pom = FileUtils.readFileToString((File)new File("pom.xml"), (String)"UTF-8");
                pom = this.project.getPackaging().equals("jar") ? pom.replaceAll("<artifactId>hibernate4-maven-plugin</artifactId>\n                <configuration>", "<artifactId>hibernate4-maven-plugin</artifactId>\n                <configuration>\n                    <scanDependencies>none</scanDependencies>") : pom.replaceAll("<artifactId>hibernate4-maven-plugin</artifactId>", "<artifactId>hibernate4-maven-plugin</artifactId>\n                <configuration>\n                    <scanDependencies>none</scanDependencies>\n                </configuration>");
                pom = pom.replaceAll("<dependencies>\n        <dependency>\n            <groupId>org.appfuse</groupId>\n            <artifactId>appfuse-data-common</artifactId>\n            <version>(.*?)appfuse.version}</version>\n        </dependency>", "<dependencies>");
                pom = InstallSourceMojo.adjustLineEndingsForOS(pom);
                FileUtils.writeStringToFile((File)new File("pom.xml"), (String)pom, (String)"UTF-8");
            }
            catch (IOException io) {
                this.getLog().error((CharSequence)"Failed to add <scanDependencies>none</scanDependencies> to hibernate4-maven-plugin. Please make this change manually.");
            }
        }
        boolean isWebServicesProject = false;
        for (Object pluginArtifact : this.project.getPluginArtifacts()) {
            if (!((Artifact)pluginArtifact).getArtifactId().contains("enunciate")) continue;
            isWebServicesProject = true;
            try {
                String enunciate = FileUtils.readFileToString((File)new File("enunciate.xml"), (String)"UTF-8");
                enunciate = enunciate.replaceAll(APPFUSE_GROUP_ID, this.project.getGroupId());
                enunciate = InstallSourceMojo.adjustLineEndingsForOS(enunciate);
                FileUtils.writeStringToFile((File)new File("enunciate.xml"), (String)enunciate, (String)"UTF-8");
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to rename 'org.appfuse' to '" + this.project.getGroupId() + " in enunciate.xml'. Please make this change manually."));
            }
            break;
        }
        if (this.project.getPackaging().equalsIgnoreCase("war")) {
            if (webFramework == null && !isWebServicesProject) {
                this.getLog().error((CharSequence)"The web.framework property is not specified - please modify your pom.xml to add  this property. For example: <web.framework>struts</web.framework>.");
                throw new MojoExecutionException("No web.framework property specified, please modify pom.xml to add it.");
            }
            if (this.project.getArtifactId().contains("core")) {
                this.deleteFile("main/resources/hibernate.cfg.xml");
                this.deleteFile("main/resources/META-INF");
                this.deleteFile("main/resources/sql-map-config.xml");
                this.deleteFile("test/resources/jdbc.properties");
            } else if (!this.isAppFuse()) {
                this.deleteFile("test/resources/jdbc.properties");
                this.deleteFile("test/resources/log4j2.xml");
            }
        }
        this.renamePackages();
    }

    private void calculateDependencies(String appfuseVersion, String daoFramework, String webFramework, boolean isWebServicesProject) throws MojoFailureException {
        List dependencies = this.project.getOriginalModel().getDependencies();
        List<Dependency> newDependencies = new ArrayList<Dependency>();
        for (Object dependency : dependencies) {
            Dependency dep = (Dependency)dependency;
            if (dep.getGroupId().equals(APPFUSE_GROUP_ID)) continue;
            newDependencies.add(dep);
        }
        if (!this.project.getPackaging().equals("pom")) {
            newDependencies = this.addModuleDependencies(newDependencies, "root", "", "");
            newDependencies = this.addModuleDependencies(newDependencies, "data", "data", "appfuse-root");
            newDependencies = this.addModuleDependencies(newDependencies, "data-common", "data/common", "appfuse-root/appfuse-data");
            newDependencies = this.addModuleDependencies(newDependencies, daoFramework, "data/" + daoFramework, "appfuse-root/appfuse-data");
            newDependencies = this.addModuleDependencies(newDependencies, "service", "service", "appfuse-root");
            if (!isWebServicesProject && this.project.getPackaging().equals("war")) {
                newDependencies = this.addWebDependencies(appfuseVersion, newDependencies, webFramework);
            }
            this.createFullSourcePom(newDependencies);
        } else {
            if (this.project.getPackaging().equals("pom")) {
                newDependencies = this.addModuleDependencies(newDependencies, "root", "", "");
                this.createFullSourcePom(newDependencies);
            }
            if (this.project.getPackaging().equals("jar")) {
                newDependencies.clear();
                newDependencies = this.addModuleDependencies(newDependencies, "root", "", "");
                newDependencies = this.addModuleDependencies(newDependencies, "data", "data", "appfuse-root");
                newDependencies = this.addModuleDependencies(newDependencies, "data-common", "data/common", "appfuse-root/appfuse-data");
                newDependencies = this.addModuleDependencies(newDependencies, daoFramework, "data/" + daoFramework, "appfuse-root/appfuse-data");
                newDependencies = this.addModuleDependencies(newDependencies, "service", "service", "appfuse-root");
                this.createFullSourcePom(newDependencies);
            }
            if (this.project.getPackaging().equals("war")) {
                newDependencies.clear();
                newDependencies = this.addModuleDependencies(newDependencies, "root", "", "");
                newDependencies = this.addWebDependencies(appfuseVersion, newDependencies, webFramework);
                this.createFullSourcePom(newDependencies);
            }
        }
    }

    private List<Dependency> addWebDependencies(String appfuseVersion, List<Dependency> newDependencies, String webFramework) {
        newDependencies = this.addModuleDependencies(newDependencies, "web", "web", "appfuse-root");
        Double appfuseVersionAsDouble = new Double(appfuseVersion.substring(0, appfuseVersion.lastIndexOf(".")));
        if (StringUtils.countMatches((String)".", (String)appfuseVersion) == 1) {
            appfuseVersionAsDouble = new Double(appfuseVersion);
        }
        this.getLog().debug((CharSequence)("Detected AppFuse version: " + appfuseVersionAsDouble));
        if (this.isAppFuse() && appfuseVersionAsDouble < 2.1) {
            newDependencies = this.addModuleDependencies(newDependencies, "web-common", "web/common", "appfuse-root/appfuse-web");
        }
        if (this.isAppFuse() && this.project.getPackaging().equals("war") && this.project.hasParent()) {
            newDependencies = this.addModuleDependencies(newDependencies, "web-common", "web/common", "appfuse-root/appfuse-web");
            newDependencies = this.addModuleDependencies(newDependencies, webFramework, "web/" + webFramework, "appfuse-root/appfuse-web");
        }
        return newDependencies;
    }

    private boolean isAppFuse() {
        return this.project.getParent().getArtifactId().contains("appfuse-web");
    }

    private void deleteFile(String filePath) {
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        File duplicateFile = new File(this.getFilePath(this.destinationDirectory + filePath));
        try {
            this.getLog().debug((CharSequence)("Looking for duplicate file at '" + duplicateFile.getCanonicalPath()));
            if (duplicateFile.exists()) {
                this.getLog().debug((CharSequence)("Deleting duplicate file at '" + duplicateFile.getCanonicalPath()));
                if (duplicateFile.isDirectory()) {
                    FileUtils.deleteDirectory((File)duplicateFile);
                } else {
                    FileUtils.forceDeleteOnExit((File)duplicateFile);
                }
            }
        }
        catch (IOException io) {
            this.getLog().error((CharSequence)("Failed to delete '" + filePath + "', please delete manually."));
        }
    }

    private void createFullSourcePom(List<Dependency> newDependencies) throws MojoFailureException {
        TreeSet<String> projectProperties = new TreeSet<String>();
        for (Dependency dep : newDependencies) {
            projectProperties.add(this.getDependencyVersionOrThrowExceptionIfNotAvailable(dep));
        }
        if (this.project.getPackaging().equals("war") && !this.project.getParentArtifact().getGroupId().contains("appfuse")) {
            Dependency core = new Dependency();
            core.setGroupId("${project.parent.groupId}");
            core.setArtifactId("${project.parent.artifactId}-core");
            core.setVersion("${project.parent.version}");
            newDependencies.add(core);
        }
        Collections.sort(newDependencies, new BeanComparator("groupId"));
        this.project.getOriginalModel().setDependencies(newDependencies);
        Properties currentProperties = this.project.getOriginalModel().getProperties();
        LinkedHashSet<String> currentKeys = new LinkedHashSet<String>();
        for (Object key : currentProperties.keySet()) {
            currentKeys.add((String)key);
        }
        StringBuffer sortedProperties = new StringBuffer();
        Properties appfuseProperties = this.getAppFuseProperties();
        LinkedHashMap<String, String> propertiesForPom = new LinkedHashMap<String, String>();
        for (String key : projectProperties) {
            String value;
            if (currentKeys.contains(key) || (value = appfuseProperties.getProperty(key)) == null) continue;
            if (value.contains("&amp;")) {
                value = "<![CDATA[" + value + "]]>";
            }
            sortedProperties.append("        <").append(key).append(">").append(value).append("</").append(key).append(">\n");
            propertiesForPom.put(key, value);
        }
        if (this.project.getPackaging().equals("pom") || this.project.hasParent()) {
            LinkedHashMap properties = new LinkedHashMap();
            if (propertiesContextHolder.get() != null) {
                properties = (LinkedHashMap)propertiesContextHolder.get();
            }
            for (String key : propertiesForPom.keySet()) {
                if (properties.containsKey(key)) continue;
                properties.put(key, propertiesForPom.get(key));
            }
            propertiesContextHolder.set(properties);
        }
        StringWriter writer = new StringWriter();
        try {
            this.project.writeOriginalModel((Writer)writer);
            File pom = new File("pom-fullsource.xml");
            if (pom.exists()) {
                pom.delete();
            }
            FileWriter fw = new FileWriter(pom);
            fw.write(writer.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)("Unable to create pom-fullsource.xml: " + ex.getMessage()), (Throwable)ex);
            throw new MojoFailureException(ex.getMessage());
        }
        String pomXml = writer.toString();
        int startTag = pomXml.indexOf("\n  <dependencies>");
        String dependencyXml = pomXml.substring(startTag, pomXml.indexOf("</dependencies>", startTag));
        dependencyXml = dependencyXml.replaceAll("  ", "    ");
        dependencyXml = "\n    <!-- Dependencies calculated by AppFuse when running full-source plugin -->" + dependencyXml;
        try {
            String packaging = this.project.getPackaging();
            String pathToPom = "pom.xml";
            if (this.project.hasParent() && !this.project.getParentArtifact().getGroupId().contains("appfuse")) {
                if (packaging.equals("jar")) {
                    pathToPom = "core/" + pathToPom;
                } else if (packaging.equals("war")) {
                    pathToPom = "web/" + pathToPom;
                }
            }
            String originalPom = FileUtils.readFileToString((File)new File(pathToPom), (String)"UTF-8");
            originalPom = originalPom.replace("\t", "    ");
            startTag = originalPom.indexOf("\n    <dependencies>");
            StringBuffer sb = new StringBuffer();
            sb.append(originalPom.substring(0, startTag));
            sb.append(dependencyXml);
            sb.append(originalPom.substring(originalPom.indexOf("</dependencies>", startTag)));
            String adjustedPom = sb.toString();
            if (!this.project.getPackaging().equals("pom") && this.project.getParentArtifact().getGroupId().contains("appfuse")) {
                adjustedPom = InstallSourceMojo.addPropertiesToPom(adjustedPom, sortedProperties);
            }
            adjustedPom = InstallSourceMojo.adjustLineEndingsForOS(adjustedPom);
            FileUtils.writeStringToFile((File)new File(pathToPom), (String)adjustedPom, (String)"UTF-8");
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)("Unable to write to pom.xml: " + ex.getMessage()), (Throwable)ex);
            throw new MojoFailureException(ex.getMessage());
        }
        File pom = new File("pom-fullsource.xml");
        if (pom.exists()) {
            pom.delete();
        }
        if (this.project.getPackaging().equals("war") && this.project.hasParent() && !this.project.getParentArtifact().getGroupId().contains("appfuse")) {
            Map properties = propertiesContextHolder.get();
            TreeSet propertiesToAdd = new TreeSet(properties.keySet());
            StringBuffer calculatedProperties = new StringBuffer();
            for (String key : propertiesToAdd) {
                Set<Object> keysInProject = this.project.getParent().getOriginalModel().getProperties().keySet();
                if (keysInProject.contains(key)) continue;
                String value = this.getAppFuseProperties().getProperty(key);
                if (value.contains("&amp;")) {
                    value = "<![CDATA[" + value + "]]>";
                }
                calculatedProperties.append("        <");
                calculatedProperties.append(key);
                calculatedProperties.append(">");
                calculatedProperties.append(value);
                calculatedProperties.append("</");
                calculatedProperties.append(key);
                calculatedProperties.append(">");
                calculatedProperties.append("\n");
            }
            try {
                String originalPom = FileUtils.readFileToString((File)new File("pom.xml"), (String)"UTF-8");
                originalPom = originalPom.replaceAll("  <modules>", "");
                originalPom = originalPom.replaceAll("    <module>.*?</module>", "");
                originalPom = originalPom.replaceAll("  </modules>", "");
                originalPom = originalPom.replace("<repositories>", "<modules>\n        <module>core</module>\n        <module>web</module>\n    </modules>\n\n    <repositories>");
                String pomWithProperties = InstallSourceMojo.addPropertiesToPom(originalPom, calculatedProperties);
                FileUtils.writeStringToFile((File)new File("pom.xml"), (String)pomWithProperties, (String)"UTF-8");
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)("Unable to modify root pom.xml: " + ex.getMessage()), (Throwable)ex);
                throw new MojoFailureException(ex.getMessage());
            }
        }
    }

    private void renamePackages() {
        boolean renamePackages = true;
        if (System.getProperty("renamePackages") != null) {
            renamePackages = Boolean.valueOf(System.getProperty("renamePackages"));
        }
        if (renamePackages && !this.project.getPackaging().equals("pom")) {
            this.log("Renaming packages to '" + this.project.getGroupId() + "'...");
            RenamePackages renamePackagesTool = new RenamePackages(this.project.getGroupId());
            if (this.project.hasParent() && !this.project.getParentArtifact().getGroupId().contains("appfuse")) {
                renamePackagesTool.setBaseDir(this.project.getBasedir() + "/src");
            }
            renamePackagesTool.execute();
        }
    }

    private String getDependencyVersionOrThrowExceptionIfNotAvailable(Dependency dep) {
        String version = dep.getVersion();
        if (version == null) {
            version = this.getDependencyVersionFromDependencyManagementOrThrowExceptionIfNotAvailable(dep);
        }
        if (version.startsWith("${")) {
            version = version.substring(2);
        }
        if (version.endsWith("}")) {
            version = version.substring(0, version.length() - 1);
        }
        return version;
    }

    private String getDependencyVersionFromDependencyManagementOrThrowExceptionIfNotAvailable(Dependency dep) {
        DependencyManagement dependencyManagement = this.project.getDependencyManagement();
        if (dependencyManagement != null) {
            List managedDeps = dependencyManagement.getDependencies();
            for (Dependency managedDep : managedDeps) {
                if (!managedDep.getArtifactId().equals(dep.getArtifactId()) || !managedDep.getGroupId().equals(dep.getGroupId())) continue;
                return managedDep.getVersion();
            }
            throw new IllegalArgumentException(String.format("Unable to determine version for dependency: %s:%s", dep.getGroupId(), dep.getArtifactId()));
        }
        throw new IllegalArgumentException(String.format("Unable to determine version for dependency: %s:%s. DependencyManagement is null", dep.getGroupId(), dep.getArtifactId()));
    }

    private static String addPropertiesToPom(String existingPomXmlAsString, StringBuffer sortedProperties) {
        String adjustedPom = existingPomXmlAsString;
        if (!"".equals(sortedProperties)) {
            adjustedPom = adjustedPom.replace("<jdbc.password/>", "<jdbc.password/>" + LINE_SEP + LINE_SEP + "        <!-- Properties calculated by AppFuse when running full-source plugin -->\n" + sortedProperties);
            adjustedPom = adjustedPom.replace("<jdbc.password></jdbc.password>", "<jdbc.password/>" + LINE_SEP + LINE_SEP + "        <!-- Properties calculated by AppFuse when running full-source plugin -->\n" + sortedProperties);
        }
        adjustedPom = adjustedPom.replaceAll("<amp.fullSource>false</amp.fullSource>", "<amp.fullSource>true</amp.fullSource>");
        return InstallSourceMojo.adjustLineEndingsForOS(adjustedPom);
    }

    private static String adjustLineEndingsForOS(String adjustedPom) {
        String os = System.getProperty("os.name");
        if (os.startsWith("Linux") || os.startsWith("Mac")) {
            adjustedPom = adjustedPom.replaceAll("\r", "");
        } else if (os.startsWith("Windows")) {
            adjustedPom = adjustedPom.replaceAll(">\n", ">\r\n");
        }
        return adjustedPom;
    }

    private Properties getAppFuseProperties() {
        if (this.appfuseProperties == null) {
            File pom = new File("target/appfuse-root/pom.xml");
            this.appfuseProperties = this.createProjectFromPom(pom).getOriginalModel().getProperties();
        }
        return this.appfuseProperties;
    }

    private String getFilePath(String s) {
        s = s.replace("/", FILE_SEP);
        return s;
    }

    private void export(String url, String destinationDirectory) throws MojoExecutionException {
        SubversionUtils svn = new SubversionUtils(this.trunk + this.tag + url, destinationDirectory);
        try {
            svn.export();
        }
        catch (SVNException e) {
            for (SVNErrorMessage err = e.getErrorMessage(); err != null; err = err.getChildErrorMessage()) {
                this.getLog().error((CharSequence)(err.getErrorCode().getCode() + " : " + err.getMessage()));
            }
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void log(String msg) {
        this.getLog().info((CharSequence)("[AppFuse] " + msg));
    }

    private List<Dependency> addModuleDependencies(List<Dependency> dependencies, String moduleName, String moduleLocation, String parentModule) {
        this.log("Adding dependencies from " + moduleName + " module...");
        URL pomLocation = null;
        File newDir = new File(this.project.getFile().getParent(), "target/" + parentModule + "/appfuse-" + moduleName);
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        File pom = new File(this.project.getFile().getParent(), "target/" + parentModule + "/appfuse-" + moduleName + "/pom.xml");
        try {
            this.trunk = this.trunk.replace("https://github.com", "https://raw.githubusercontent.com");
            this.tag = this.tag.replace("trunk", "master");
            if (this.tag.contains("tags/")) {
                this.tag = this.tag.replace("tags/", "");
            }
            if (this.tag.contains("branches/")) {
                this.tag = this.tag.replace("branches/", "");
            }
            if (!"".equals(moduleLocation)) {
                moduleLocation = moduleLocation + "/";
            }
            pomLocation = new URL(this.trunk + this.tag + moduleLocation + "pom.xml");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        Get get = (Get)AntUtils.createProject().createTask("get");
        get.setSrc(pomLocation);
        get.setDest(pom);
        get.execute();
        MavenProject p = this.createProjectFromPom(pom);
        List moduleDependencies = p.getOriginalModel().getDependencies();
        if (moduleName.equalsIgnoreCase("root")) {
            this.appfuseProperties = p.getOriginalModel().getProperties();
        }
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        for (Dependency dep : dependencies) {
            artifactIds.add(dep.getArtifactId());
        }
        for (Object moduleDependency : moduleDependencies) {
            Dependency dep = (Dependency)moduleDependency;
            if (dep.getGroupId().equals("javax.servlet.jsp") && dep.getArtifactId().equals("jsp-api") && "jsf".equals(this.project.getProperties().getProperty("web.framework")) || artifactIds.contains(dep.getArtifactId()) || dep.getArtifactId().contains("appfuse")) continue;
            dependencies.add(dep);
        }
        return dependencies;
    }

    private MavenProject createProjectFromPom(File pom) {
        try {
            return this.mavenProjectBuilder.buildWithDependencies(pom, this.local, null);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("skip error reading maven project: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected void moveFiles(String inSourceDirectory, String inDestinationDirectory, String inPattern) {
        Move moveTask = (Move)this.antProject.createTask("move");
        FileSet fileSet = AntUtils.createFileset(inSourceDirectory, inPattern, new ArrayList());
        moveTask.setTodir(new File(inDestinationDirectory));
        moveTask.addFileset(fileSet);
        moveTask.execute();
    }

    protected void renameFile(File from, File to) {
        Move moveTask = (Move)this.antProject.createTask("move");
        moveTask.setFile(from);
        moveTask.setTofile(to);
        moveTask.execute();
    }
}

