/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apfloat.ApfloatContext;
import org.apfloat.samples.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundOperation<T> {
    private Future<T> future;

    public BackgroundOperation(final Operation<T> operation) {
        ApfloatContext ctx = ApfloatContext.getContext();
        ExecutorService executorService = ctx.getExecutorService();
        Callable callable = new Callable<T>(){

            @Override
            public T call() {
                return operation.execute();
            }
        };
        this.future = executorService.submit(callable);
    }

    public boolean isFinished() {
        return this.future.isDone();
    }

    public T getResult() {
        try {
            return this.future.get();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }
}

