/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.applet.Applet;
import java.awt.Container;
import java.awt.Label;
import java.io.File;
import java.security.AccessControlException;
import org.apfloat.ApfloatContext;
import org.apfloat.samples.PiAWT;
import org.apfloat.spi.BuilderFactory;
import org.apfloat.spi.FilenameGenerator;

public class PiApplet
extends Applet {
    public void init() {
        if (System.getProperty("java.version").compareTo("1.5") < 0) {
            this.add(new Label("This applet requires Java 5.0 or later. Download it from http://www.java.com"));
        } else {
            this.add(this.getContents());
            new Handler().init();
        }
    }

    protected Container getContents() {
        return new Handler().getContents();
    }

    public void destroy() {
        this.removeAll();
    }

    public String getAppletInfo() {
        BuilderFactory builderFactory = ApfloatContext.getContext().getBuilderFactory();
        Package specificationPackage = Package.getPackage("org.apfloat");
        Package implementationPackage = builderFactory.getClass().getPackage();
        String lineSeparator = System.getProperty("line.separator");
        return "Pi calculation applet" + lineSeparator + "Written by Mikko Tommila 2002 - 2015" + lineSeparator + "Specification-Title: " + specificationPackage.getSpecificationTitle() + lineSeparator + "Specification-Version: " + specificationPackage.getSpecificationVersion() + lineSeparator + "Specification-Vendor: " + specificationPackage.getSpecificationVendor() + lineSeparator + "Implementation-Title: " + implementationPackage.getImplementationTitle() + lineSeparator + "Implementation-Version: " + implementationPackage.getImplementationVersion() + lineSeparator + "Implementation-Vendor: " + implementationPackage.getImplementationVendor() + lineSeparator + "Java version: " + System.getProperty("java.version") + lineSeparator + "Java Virtual Machine: " + System.getProperty("java.vm.name");
    }

    class Handler
    implements PiAWT.StatusIndicator {
        Handler() {
        }

        public void showStatus(String status) {
            PiApplet.this.showStatus(status);
        }

        public Container getContents() {
            return new PiAWT(this);
        }

        public void init() {
            ApfloatContext ctx = ApfloatContext.getContext();
            ctx.setExecutorService(ApfloatContext.getDefaultExecutorService());
            try {
                String path = System.getProperty("java.io.tmpdir");
                if (path != null && !path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
                FilenameGenerator filenameGenerator = new FilenameGenerator(path, null, null);
                ctx.setFilenameGenerator(filenameGenerator);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }
}

