/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import org.apfloat.samples.BackgroundOperation;
import org.apfloat.samples.Operation;
import org.apfloat.samples.OperationExecutor;

public class RemoteOperationExecutor
implements OperationExecutor {
    private static final int BUFFER_SIZE = 8192;
    private String host;
    private int port;

    public RemoteOperationExecutor(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public <T> T execute(Operation<T> operation) {
        Object result;
        try (SocketChannel channel = SocketChannel.open(new InetSocketAddress(this.host, this.port));){
            Object obj;
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(Channels.newOutputStream(channel), 8192));
            out.writeObject(operation);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(Channels.newInputStream(channel));
            result = obj = in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    @Override
    public <T> BackgroundOperation<T> executeBackground(Operation<T> operation) {
        return new BackgroundOperation<Object>(() -> this.execute(operation));
    }

    @Override
    public int getWeight() {
        return 1;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

