/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatInterruptedException;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.samples.Operation;
import org.apfloat.samples.Pi;
import org.apfloat.spi.BuilderFactory;

public class PiAWT
extends Panel {
    private static final long serialVersionUID = 1L;
    private StatusIndicator statusIndicator;
    private Label precisionLabel;
    private TextField precisionField;
    private Label radixLabel;
    private Choice radixChoice;
    private Label methodLabel;
    private CheckboxGroup methods;
    private Checkbox chudnovsky;
    private Checkbox ramanujan;
    private Checkbox gaussLegendre;
    private Checkbox borwein;
    private Label implementationLabel;
    private Choice implementationChoice;
    private Button goButton;
    private Button abortButton;
    private Label statusLabel;
    private TextArea statusArea;
    private Label resultLabel;
    private TextArea resultArea;
    private List<BuilderFactory> builderFactories;
    private Thread calculatorThread;

    public PiAWT(StatusIndicator statusIndicator) {
        this.statusIndicator = statusIndicator;
        this.initGUI();
    }

    private void initGUI() {
        ApfloatContext ctx = ApfloatContext.getContext();
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.precisionLabel = new Label("Precision:");
        this.add((Component)this.precisionLabel, constraints);
        this.precisionField = new TextField("1000000", 12);
        this.add((Component)this.precisionField, constraints);
        this.radixLabel = new Label("Radix:");
        this.add((Component)this.radixLabel, constraints);
        this.radixChoice = new Choice();
        for (int i = 2; i <= 36; ++i) {
            this.radixChoice.add(String.valueOf(i));
        }
        this.radixChoice.select(ctx.getProperty("defaultRadix"));
        constraints.gridwidth = 0;
        this.add((Component)this.radixChoice, constraints);
        this.methodLabel = new Label("Method:");
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        this.add((Component)this.methodLabel, constraints);
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridwidth = 0;
        panelConstraints.anchor = 18;
        panelConstraints.weightx = 1.0;
        panelConstraints.weighty = 1.0;
        this.methods = new CheckboxGroup();
        this.chudnovsky = new Checkbox("Chudnovsky", true, this.methods);
        panel.add((Component)this.chudnovsky, panelConstraints);
        this.ramanujan = new Checkbox("Ramanujan", false, this.methods);
        panel.add((Component)this.ramanujan, panelConstraints);
        this.gaussLegendre = new Checkbox("Gauss-Legendre", false, this.methods);
        panel.add((Component)this.gaussLegendre, panelConstraints);
        this.borwein = new Checkbox("Borwein", false, this.methods);
        panel.add((Component)this.borwein, panelConstraints);
        this.add((Component)panel, constraints);
        this.implementationLabel = new Label("Implementation:");
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.implementationLabel, constraints);
        this.implementationChoice = new Choice();
        this.builderFactories = new ArrayList<BuilderFactory>();
        String defaultBuilderFactoryClassName = ApfloatContext.getContext().getBuilderFactory().getClass().getName();
        Iterator<BuilderFactory> providers = ServiceLoader.load(BuilderFactory.class).iterator();
        if (!providers.hasNext()) {
            BuilderFactory builderFactory = ApfloatContext.getContext().getBuilderFactory();
            providers = Collections.singleton(builderFactory).iterator();
        }
        int i = 0;
        while (providers.hasNext()) {
            BuilderFactory builderFactory = providers.next();
            String builderFactoryClassName = builderFactory.getClass().getName();
            this.builderFactories.add(builderFactory);
            this.implementationChoice.add(builderFactoryClassName);
            if (builderFactoryClassName.equals(defaultBuilderFactoryClassName)) {
                this.implementationChoice.select(i);
            }
            ++i;
        }
        constraints.gridwidth = 0;
        this.add((Component)this.implementationChoice, constraints);
        constraints.gridwidth = 1;
        this.initThreads(this, constraints);
        this.goButton = new Button("Go!");
        constraints.gridwidth = 1;
        this.add((Component)this.goButton, constraints);
        this.abortButton = new Button("Abort!");
        this.abortButton.setEnabled(false);
        constraints.gridwidth = 0;
        this.add((Component)this.abortButton, constraints);
        this.statusLabel = new Label("Status:");
        this.add((Component)this.statusLabel, constraints);
        this.statusArea = new TextArea(null, 5, 60, 1);
        this.statusArea.setEditable(false);
        constraints.fill = 2;
        this.add((Component)this.statusArea, constraints);
        this.resultLabel = new Label("Result:");
        constraints.fill = 0;
        this.add((Component)this.resultLabel, constraints);
        this.resultArea = new TextArea(null, 5, 60, 1);
        this.resultArea.setEditable(false);
        constraints.fill = 2;
        this.add((Component)this.resultArea, constraints);
        this.goButton.addActionListener(actionEvent -> {
            if (this.isInputValid()) {
                this.statusArea.setText(null);
                this.resultArea.setText(null);
                this.goButton.setEnabled(false);
                this.startThread();
            }
        });
        this.abortButton.addActionListener(actionEvent -> {
            this.abortButton.setEnabled(false);
            this.stopThread();
        });
    }

    protected void initThreads(Container container, GridBagConstraints constraints) {
        constraints.gridwidth = 0;
        container.add((Component)new Label(), constraints);
    }

    protected boolean isInputValid() {
        String precisionString = this.precisionField.getText();
        try {
            long precision = Long.parseLong(precisionString);
            if (precision <= 0L) {
                throw new NumberFormatException();
            }
            this.showStatus(null);
            return true;
        }
        catch (NumberFormatException nfe) {
            this.showStatus("Invalid precision: " + precisionString);
            this.precisionField.requestFocus();
            return false;
        }
    }

    protected void showStatus(String status) {
        this.statusIndicator.showStatus(status);
    }

    protected Operation<Apfloat> getOperation(long precision, int radix) throws ApfloatRuntimeException {
        if (this.chudnovsky.getState()) {
            return new Pi.ChudnovskyPiCalculator(precision, radix);
        }
        if (this.ramanujan.getState()) {
            return new Pi.RamanujanPiCalculator(precision, radix);
        }
        if (this.gaussLegendre.getState()) {
            return new Pi.GaussLegendrePiCalculator(precision, radix);
        }
        return new Pi.BorweinPiCalculator(precision, radix);
    }

    private void startThread() {
        Pi.setOut(new PrintWriter((Writer)new FlushStringWriter(this.resultArea), true));
        Pi.setErr(new PrintWriter((Writer)new FlushStringWriter(this.statusArea), true));
        ApfloatContext ctx = ApfloatContext.getContext();
        BuilderFactory builderFactory = this.builderFactories.get(this.implementationChoice.getSelectedIndex());
        ctx.setBuilderFactory(builderFactory);
        this.calculatorThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long precision = Long.parseLong(PiAWT.this.precisionField.getText());
                int radix = Integer.parseInt(PiAWT.this.radixChoice.getSelectedItem());
                Operation<Apfloat> operation = PiAWT.this.getOperation(precision, radix);
                try {
                    Pi.run(precision, radix, operation);
                }
                catch (ApfloatInterruptedException aie) {
                    PiAWT.this.aborted();
                }
                catch (AssertionError ae) {
                    PiAWT.this.crashed((Throwable)((Object)ae));
                }
                catch (Exception e) {
                    PiAWT.this.crashed(e);
                }
                finally {
                    PiAWT.this.end();
                }
            }
        };
        this.calculatorThread.start();
        this.abortButton.setEnabled(true);
    }

    private void stopThread() {
        this.calculatorThread.interrupt();
    }

    private void aborted() {
        Pi.getErr().println("Aborted");
    }

    private void crashed(Throwable cause) {
        Pi.getErr().println("Crashed with " + cause);
        cause.printStackTrace();
    }

    private void end() {
        this.abortButton.setEnabled(false);
        this.goButton.setEnabled(true);
        ApfloatContext ctx = ApfloatContext.getContext();
        BuilderFactory builderFactory = ctx.getBuilderFactory();
        builderFactory.gc();
    }

    public static interface StatusIndicator {
        public void showStatus(String var1);
    }

    private static class FlushStringWriter
    extends StringWriter {
        private TextArea dst;
        private int length;
        private int position;
        private int lastLinefeedPosition;

        public FlushStringWriter(TextArea dst) {
            this.dst = dst;
            this.length = 0;
            this.position = 0;
            this.lastLinefeedPosition = 0;
        }

        @Override
        public void flush() {
            super.flush();
            StringBuffer buffer = this.getBuffer();
            String text = buffer.toString();
            String lineSeparator = System.lineSeparator();
            boolean endsWithLineSeparator = text.endsWith(lineSeparator);
            boolean endsWithCarriageReturn = text.endsWith("\r");
            if (endsWithLineSeparator) {
                text = text.substring(0, text.length() - lineSeparator.length()) + '\n';
            } else if (endsWithCarriageReturn) {
                text = text.substring(0, text.length() - 1);
            }
            this.dst.replaceRange(text, this.position, this.length);
            this.position += text.length();
            this.length = this.position;
            if (endsWithLineSeparator) {
                this.lastLinefeedPosition = this.position;
            } else if (endsWithCarriageReturn) {
                this.position = this.lastLinefeedPosition;
            }
            buffer.setLength(0);
        }
    }
}

