/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.calc;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apfloat.calc.ApfloatCalculatorImpl;
import org.apfloat.calc.CalculatorImpl;
import org.apfloat.calc.CalculatorParser;

public class CalculatorAWT
extends Panel {
    private CalculatorImpl calculatorImpl = new ApfloatCalculatorImpl();
    private List<String> history = new ArrayList<String>();
    private int historyPosition = 0;
    private TextArea outputArea;
    private Label formatLabel;
    private CheckboxGroup formats;
    private Checkbox floating;
    private Checkbox fixed;
    private Button clearButton;
    private TextField inputField;
    private Button calculateButton;
    private PrintWriter out;

    public CalculatorAWT() {
        this.initGUI();
        this.out = new PrintWriter((Writer)new FlushStringWriter(this.outputArea), true);
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.inputField = new TextField(null, 60);
        constraints.gridy = 4;
        this.add((Component)this.inputField, constraints);
        this.calculateButton = new Button("Calculate");
        constraints.gridwidth = 0;
        this.add((Component)this.calculateButton, constraints);
        this.outputArea = new TextArea(null, 20, 60, 1);
        this.outputArea.setEditable(false);
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 4;
        this.add((Component)this.outputArea, constraints);
        this.formatLabel = new Label("Format:");
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        this.add((Component)this.formatLabel, constraints);
        this.formats = new CheckboxGroup();
        this.floating = new Checkbox("Floating", true, this.formats);
        constraints.gridy = 1;
        this.add((Component)this.floating, constraints);
        this.fixed = new Checkbox("Fixed", false, this.formats);
        constraints.gridy = 2;
        this.add((Component)this.fixed, constraints);
        this.clearButton = new Button("Clear");
        constraints.gridy = 3;
        constraints.weighty = 1000.0;
        this.add((Component)this.clearButton, constraints);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalculatorAWT.this.outputArea.setText(null);
                CalculatorAWT.this.history.clear();
                CalculatorAWT.this.historyPosition = 0;
            }
        });
        this.calculateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalculatorAWT.this.processInput();
            }
        });
        this.inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalculatorAWT.this.processInput();
            }
        });
        this.inputField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        if (CalculatorAWT.this.historyPosition <= 0) break;
                        CalculatorAWT.this.inputField.setText((String)CalculatorAWT.this.history.get(--CalculatorAWT.this.historyPosition));
                        CalculatorAWT.this.inputField.setCaretPosition(Integer.MAX_VALUE);
                        break;
                    }
                    case 40: {
                        if (CalculatorAWT.this.historyPosition >= CalculatorAWT.this.history.size() - 1) break;
                        CalculatorAWT.this.inputField.setText((String)CalculatorAWT.this.history.get(++CalculatorAWT.this.historyPosition));
                        CalculatorAWT.this.inputField.setCaretPosition(Integer.MAX_VALUE);
                        break;
                    }
                }
            }
        });
    }

    private void processInput() {
        String text = this.inputField.getText();
        this.inputField.setText(null);
        this.out.println(text);
        try {
            this.calculatorImpl.setFormat(this.fixed.getState());
            CalculatorParser calculatorParser = new CalculatorParser((Reader)new StringReader(text), this.out, this.calculatorImpl);
            calculatorParser.parseOneLine();
        }
        catch (Exception e) {
            this.out.println(e.getMessage());
        }
        this.outputArea.requestFocus();
        this.outputArea.setCaretPosition(Integer.MAX_VALUE);
        this.inputField.requestFocus();
        this.history.add(text);
        this.historyPosition = this.history.size();
    }

    private static class FlushStringWriter
    extends StringWriter {
        private TextArea dst;

        public FlushStringWriter(TextArea dst) {
            this.dst = dst;
        }

        public void flush() {
            super.flush();
            StringBuffer buffer = this.getBuffer();
            String text = buffer.toString();
            this.dst.append(text);
            buffer.setLength(0);
        }
    }
}

