/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.calc;

import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.AprationalMath;
import org.apfloat.calc.FunctionCalculatorImpl;

public class ApfloatCalculatorImpl
extends FunctionCalculatorImpl {
    public Number parseInteger(String value) {
        Object x = value.equalsIgnoreCase("i") ? Apcomplex.I : (value.endsWith("i") || value.endsWith("I") ? new Apint(value.substring(0, value.length() - 1)).multiply(Apcomplex.I) : new Apint(value));
        return x;
    }

    public Number parseDecimal(String value) {
        Object x = value.endsWith("i") || value.endsWith("I") ? new Apfloat(value.substring(0, value.length() - 1)).multiply(Apcomplex.I) : new Apfloat(value);
        return x;
    }

    public String format(Number x) {
        String text;
        boolean pretty = this.getFormat();
        if (x instanceof Aprational) {
            text = x.toString();
        } else if (x instanceof Apfloat) {
            text = ((Apfloat)x).toString(pretty);
        } else {
            String imag;
            Apcomplex z = (Apcomplex)x;
            String string = z.imag().equals((Object)Apfloat.ONE) ? "" : (imag = z.imag().negate().equals((Object)Apfloat.ONE) ? "-" : z.imag().toString(pretty));
            text = z.real().signum() == 0 ? imag + "i" : z.real().toString(pretty) + (z.imag().signum() < 0 ? "" : "+") + imag + "i";
        }
        return text;
    }

    protected FunctionCalculatorImpl.Functions getFunctions(Number x) {
        ApcomplexFunctions functions = x instanceof Apint ? new ApintFunctions() : (x instanceof Aprational ? new AprationalFunctions() : (x instanceof Apfloat ? new ApfloatFunctions() : new ApcomplexFunctions()));
        return functions;
    }

    protected Number promote(Number x) {
        if (!(x instanceof Apfloat) && ((Apcomplex)x).imag().signum() == 0) {
            x = ((Apcomplex)x).real();
        }
        if (x instanceof Apfloat && !(x instanceof Aprational) && ((Apfloat)x).equals((Object)((Apfloat)x).truncate()) && ((Apfloat)x).precision() == Long.MAX_VALUE) {
            x = ((Apfloat)x).truncate();
        }
        if (x instanceof Aprational && !(x instanceof Apint) && ((Aprational)x).denominator().equals((Object)Apint.ONE)) {
            x = ((Aprational)x).numerator();
        }
        return x;
    }

    private static class ApintFunctions
    extends AprationalFunctions {
        private ApintFunctions() {
        }

        public Number gcd(Number x, Number y) {
            return ApintMath.gcd((Apint)((Apint)x), (Apint)((Apint)y));
        }

        public Number lcm(Number x, Number y) {
            return ApintMath.lcm((Apint)((Apint)x), (Apint)((Apint)y));
        }

        protected Number scale(Number x, long y) {
            return ApintMath.scale((Apint)((Apint)x), (long)y);
        }
    }

    private static class AprationalFunctions
    extends ApfloatFunctions {
        private AprationalFunctions() {
        }

        public Number add(Number x, Number y) {
            return ((Aprational)x).add((Aprational)y);
        }

        public Number subtract(Number x, Number y) {
            return ((Aprational)x).subtract((Aprational)y);
        }

        public Number multiply(Number x, Number y) {
            return ((Aprational)x).multiply((Aprational)y);
        }

        public Number divide(Number x, Number y) {
            return ((Aprational)x).divide((Aprational)y);
        }

        public Number mod(Number x, Number y) {
            return ((Aprational)x).mod((Aprational)y);
        }

        protected Number pow(Number x, long y) {
            return AprationalMath.pow((Aprational)((Aprational)x), (long)y);
        }

        public Number hypot(Number x, Number y) {
            return this.root(this.add(this.pow(x, 2L), this.pow(y, 2L)), 2L);
        }

        protected Number root(Number x, long y) {
            return new Aprational(this.root(((Aprational)x).numerator(), y), this.root(((Aprational)x).denominator(), y));
        }

        private Apint root(Apint x, long y) {
            Apint[] root = ApintMath.root((Apint)x, (long)y);
            if (root[1].signum() != 0) {
                throw new IllegalArgumentException("Cannot calculate inexact root to infinite precision");
            }
            return root[0];
        }

        protected Number scale(Number x, long y) {
            return AprationalMath.scale((Aprational)((Aprational)x), (long)y);
        }
    }

    private static class ApfloatFunctions
    extends ApcomplexFunctions {
        private ApfloatFunctions() {
        }

        public Number mod(Number x, Number y) {
            return ((Apfloat)x).mod((Apfloat)y);
        }

        public Number ceil(Number x) {
            return ((Apfloat)x).ceil();
        }

        public Number floor(Number x) {
            return ((Apfloat)x).floor();
        }

        public Number truncate(Number x) {
            return ((Apfloat)x).truncate();
        }

        public Number atan2(Number x, Number y) {
            return ApfloatMath.atan2((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y));
        }

        public Number copySign(Number x, Number y) {
            return ApfloatMath.copySign((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y));
        }

        public Number fmod(Number x, Number y) {
            return ApfloatMath.fmod((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y));
        }

        public Number hypot(Number x, Number y) {
            return ApcomplexMath.abs((Apcomplex)new Apcomplex((Apfloat)x, (Apfloat)y));
        }
    }

    private static class ApcomplexFunctions
    implements FunctionCalculatorImpl.Functions {
        private ApcomplexFunctions() {
        }

        public Number negate(Number x) {
            return ((Apcomplex)x).negate();
        }

        public Number add(Number x, Number y) {
            return ((Apcomplex)x).add((Apcomplex)y);
        }

        public Number subtract(Number x, Number y) {
            return ((Apcomplex)x).subtract((Apcomplex)y);
        }

        public Number multiply(Number x, Number y) {
            return ((Apcomplex)x).multiply((Apcomplex)y);
        }

        public Number divide(Number x, Number y) {
            return ((Apcomplex)x).divide((Apcomplex)y);
        }

        public Number mod(Number x, Number y) {
            throw new IllegalArgumentException("Modulus can only be used with scalar values");
        }

        public Number pow(Number x, Number y) {
            if (this.isLong(y)) {
                return this.pow(x, y.longValue());
            }
            return ApcomplexMath.pow((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        protected Number pow(Number x, long y) {
            return ApcomplexMath.pow((Apcomplex)((Apcomplex)x), (long)y);
        }

        public Number arg(Number x) {
            return ApcomplexMath.arg((Apcomplex)((Apcomplex)x));
        }

        public Number conj(Number x) {
            return ((Apcomplex)x).conj();
        }

        public Number imag(Number x) {
            return ((Apcomplex)x).imag();
        }

        public Number real(Number x) {
            return ((Apcomplex)x).real();
        }

        public Number abs(Number x) {
            return ApcomplexMath.abs((Apcomplex)((Apcomplex)x));
        }

        public Number acos(Number x) {
            return ApcomplexMath.acos((Apcomplex)((Apcomplex)x));
        }

        public Number acosh(Number x) {
            return ApcomplexMath.acosh((Apcomplex)((Apcomplex)x));
        }

        public Number asin(Number x) {
            return ApcomplexMath.asin((Apcomplex)((Apcomplex)x));
        }

        public Number asinh(Number x) {
            return ApcomplexMath.asinh((Apcomplex)((Apcomplex)x));
        }

        public Number atan(Number x) {
            return ApcomplexMath.atan((Apcomplex)((Apcomplex)x));
        }

        public Number atanh(Number x) {
            return ApcomplexMath.atanh((Apcomplex)((Apcomplex)x));
        }

        public Number cbrt(Number x) {
            return this.root(x, 3L);
        }

        public Number ceil(Number x) {
            throw new IllegalArgumentException("Ceiling can only be used with scalar values");
        }

        public Number cos(Number x) {
            return ApcomplexMath.cos((Apcomplex)((Apcomplex)x));
        }

        public Number cosh(Number x) {
            return ApcomplexMath.cosh((Apcomplex)((Apcomplex)x));
        }

        public Number exp(Number x) {
            return ApcomplexMath.exp((Apcomplex)((Apcomplex)x));
        }

        public Number factorial(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Factorial can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApintMath.factorial((long)n);
        }

        public Number floor(Number x) {
            throw new IllegalArgumentException("Floor can only be used with scalar values");
        }

        public Number log(Number x) {
            return ApcomplexMath.log((Apcomplex)((Apcomplex)x));
        }

        public Number log(Number x, Number y) {
            return ApcomplexMath.log((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        public Number pi(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Pi can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApfloatMath.pi((long)n);
        }

        public Number sin(Number x) {
            return ApcomplexMath.sin((Apcomplex)((Apcomplex)x));
        }

        public Number sinh(Number x) {
            return ApcomplexMath.sinh((Apcomplex)((Apcomplex)x));
        }

        public Number sqrt(Number x) {
            return this.root(x, 2L);
        }

        public Number tan(Number x) {
            return ApcomplexMath.tan((Apcomplex)((Apcomplex)x));
        }

        public Number tanh(Number x) {
            return ApcomplexMath.tanh((Apcomplex)((Apcomplex)x));
        }

        public Number truncate(Number x) {
            throw new IllegalArgumentException("Truncate can only be used with scalar values");
        }

        public Number agm(Number x, Number y) {
            return ApcomplexMath.agm((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        public Number atan2(Number x, Number y) {
            throw new IllegalArgumentException("Atan2 can only be used with scalar values");
        }

        public Number copySign(Number x, Number y) {
            throw new IllegalArgumentException("CopySign can only be used with scalar values");
        }

        public Number fmod(Number x, Number y) {
            throw new IllegalArgumentException("Fmod can only be used with scalar values");
        }

        public Number gcd(Number x, Number y) {
            throw new IllegalArgumentException("Greatest Common Ddivisor can only be used with integer values");
        }

        public Number hypot(Number x, Number y) {
            throw new IllegalArgumentException("Hypot can only be used with scalar values");
        }

        public Number inverseRoot(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Inverse root can only be used with a valid integer argument");
            }
            return this.inverseRoot(x, y.longValue());
        }

        public Number inverseRoot(Number x, Number y, Number z) {
            if (!this.isLong(y) || !this.isLong(z)) {
                throw new IllegalArgumentException("Inverse root can only be used with valid integer arguments");
            }
            return this.inverseRoot(x, y.longValue(), z.longValue());
        }

        protected Number inverseRoot(Number x, long y) {
            return ApcomplexMath.inverseRoot((Apcomplex)((Apcomplex)x), (long)y);
        }

        protected Number inverseRoot(Number x, long y, long z) {
            return ApcomplexMath.inverseRoot((Apcomplex)((Apcomplex)x), (long)y, (long)z);
        }

        public Number lcm(Number x, Number y) {
            throw new IllegalArgumentException("Least Common Multiplier can only be used with integer values");
        }

        public Number root(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Root can only be used with a valid integer argument");
            }
            return this.root(x, y.longValue());
        }

        public Number root(Number x, Number y, Number z) {
            if (!this.isLong(y) || !this.isLong(z)) {
                throw new IllegalArgumentException("Root can only be used with valid integer arguments");
            }
            return this.root(x, y.longValue(), z.longValue());
        }

        protected Number root(Number x, long y) {
            return ApcomplexMath.root((Apcomplex)((Apcomplex)x), (long)y);
        }

        protected Number root(Number x, long y, long z) {
            return ApcomplexMath.root((Apcomplex)((Apcomplex)x), (long)y, (long)z);
        }

        public Number scale(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Scale can only be used with a valid integer argument");
            }
            return this.scale(x, y.longValue());
        }

        protected Number scale(Number x, long y) {
            return ApcomplexMath.scale((Apcomplex)((Apcomplex)x), (long)y);
        }

        public Number precision(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Precision can only be used with a valid integer argument");
            }
            return this.precision(x, y.longValue());
        }

        protected Number precision(Number x, long precision) {
            return ((Apcomplex)x).precision(precision);
        }

        protected boolean isLong(Number value) {
            return new Apint(value.longValue()).equals((Object)value);
        }
    }
}

