/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.calc;

import java.math.RoundingMode;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.AprationalMath;
import org.apfloat.FixedPrecisionApcomplexHelper;
import org.apfloat.calc.FunctionCalculatorImpl;
import org.apfloat.spi.Util;

public class ApfloatCalculatorImpl
extends FunctionCalculatorImpl {
    private static final long serialVersionUID = 1L;
    private FixedPrecisionApcomplexHelper fixedPrecisionApcomplexHelper = new FixedPrecisionApcomplexHelper(Long.MAX_VALUE);

    @Override
    public Number parseInteger(String value) {
        Object x = value.equalsIgnoreCase("i") ? Apcomplex.I : (value.endsWith("i") || value.endsWith("I") ? new Apint(value.substring(0, value.length() - 1)).multiply(Apcomplex.I) : new Apint(value));
        if (this.getInputPrecision() != null) {
            x = x.precision(this.getInputPrecision().longValue());
        }
        return x;
    }

    @Override
    public Number parseDecimal(String value) {
        Object x = value.endsWith("i") || value.endsWith("I") ? new Apfloat(value.substring(0, value.length() - 1)).multiply(Apcomplex.I) : new Apfloat(value);
        if (this.getInputPrecision() != null) {
            x = x.precision(this.getInputPrecision().longValue());
        }
        return x;
    }

    @Override
    public String format(Number x) {
        String text;
        boolean pretty = this.getFormat();
        if (x instanceof Aprational) {
            text = x.toString();
        } else if (x instanceof Apfloat) {
            Apfloat a = (Apfloat)x;
            a = ApfloatMath.roundToPrecision((Apfloat)a.precision(Util.ifFinite((long)a.precision(), (long)(a.precision() + 1L))), (long)a.precision(), (RoundingMode)RoundingMode.HALF_UP);
            text = a.toString(pretty);
        } else {
            String imag;
            Apcomplex z = (Apcomplex)x;
            String string = z.imag().equals((Object)Apfloat.ONE) ? "" : (imag = z.imag().negate().equals((Object)Apfloat.ONE) ? "-" : this.format((Number)z.imag()));
            text = z.real().signum() == 0 ? imag + "i" : this.format((Number)z.real()) + (z.imag().signum() < 0 ? "" : "+") + imag + "i";
        }
        return text;
    }

    @Override
    protected FunctionCalculatorImpl.Functions getFunctions(Number x) {
        ApcomplexFunctions functions = x instanceof Apint ? new ApintFunctions() : (x instanceof Aprational ? new AprationalFunctions() : (x instanceof Apfloat ? new ApfloatFunctions() : new ApcomplexFunctions()));
        return functions;
    }

    @Override
    protected Number promote(Number x) {
        if (!(x instanceof Apfloat) && ((Apcomplex)x).imag().signum() == 0) {
            x = ((Apcomplex)x).real();
        }
        if (x instanceof Apfloat && !(x instanceof Aprational) && ((Apfloat)x).precision() == Long.MAX_VALUE && ((Apfloat)x).isInteger()) {
            x = ((Apfloat)x).truncate();
        }
        if (x instanceof Aprational && !(x instanceof Apint) && ((Aprational)x).denominator().equals((Object)Apint.ONE)) {
            x = ((Aprational)x).numerator();
        }
        return x;
    }

    @Override
    public void setInputPrecision(Long inputPrecision) {
        super.setInputPrecision(inputPrecision);
        this.fixedPrecisionApcomplexHelper = new FixedPrecisionApcomplexHelper(inputPrecision == null ? Long.MAX_VALUE : inputPrecision);
    }

    private Number fixedOrArbitraryPrecision(Function<Apcomplex, Apcomplex> fixedPrecisionFunction, Function<Apcomplex, Apcomplex> arbitraryPrecisionFunction, Number x) {
        Apcomplex z = (Apcomplex)x;
        return this.getInputPrecision() != null && z.isZero() ? (Number)((Number)fixedPrecisionFunction.apply(z)) : (Number)((Number)arbitraryPrecisionFunction.apply(z));
    }

    private <T extends Number, U extends Apcomplex> Number fixedOrArbitraryPrecision(BiFunction<T, U, Apcomplex> fixedPrecisionFunction, BiFunction<T, U, Apcomplex> arbitraryPrecisionFunction, T x, U y) {
        return this.getInputPrecision() != null && y.isZero() ? (Number)((Number)fixedPrecisionFunction.apply(x, y)) : (Number)((Number)arbitraryPrecisionFunction.apply(x, y));
    }

    private class ApintFunctions
    extends AprationalFunctions {
        private ApintFunctions() {
        }

        @Override
        public Number binomial(Number x, Number y) {
            if (this.isLong(x) && this.isLong(y)) {
                return ApintMath.binomial((long)x.longValue(), (long)y.longValue());
            }
            return ApintMath.binomial((Apint)((Apint)x), (Apint)((Apint)y));
        }

        @Override
        public Number gcd(Number x, Number y) {
            return ApintMath.gcd((Apint)((Apint)x), (Apint)((Apint)y));
        }

        @Override
        public Number harmonicNumber(Number x) {
            return AprationalMath.harmonicNumber((Apint)((Apint)x));
        }

        @Override
        public Number harmonicNumber(Number x, Number y) {
            return AprationalMath.harmonicNumber((Apint)((Apint)x), (Apint)((Apint)y));
        }

        @Override
        public Number lcm(Number x, Number y) {
            return ApintMath.lcm((Apint)((Apint)x), (Apint)((Apint)y));
        }

        @Override
        protected Number scale(Number x, long y) {
            return y >= 0L ? ApintMath.scale((Apint)((Apint)x), (long)y) : super.scale(x, y);
        }
    }

    private class AprationalFunctions
    extends ApfloatFunctions {
        private AprationalFunctions() {
        }

        @Override
        public Number add(Number x, Number y) {
            return ((Aprational)x).add((Aprational)y);
        }

        @Override
        public Number subtract(Number x, Number y) {
            return ((Aprational)x).subtract((Aprational)y);
        }

        @Override
        public Number multiply(Number x, Number y) {
            return ((Aprational)x).multiply((Aprational)y);
        }

        @Override
        public Number divide(Number x, Number y) {
            return ((Aprational)x).divide((Aprational)y);
        }

        @Override
        public Number mod(Number x, Number y) {
            return ((Aprational)x).mod((Aprational)y);
        }

        @Override
        public Number pochhammer(Number x, Number y) {
            if (y instanceof Apint) {
                return AprationalMath.pochhammer((Aprational)((Aprational)x), (Apint)((Apint)y));
            }
            return super.pochhammer(x, y);
        }

        @Override
        protected Number pow(Number x, long y) {
            return AprationalMath.pow((Aprational)((Aprational)x), (long)y);
        }

        @Override
        public Number binomial(Number x, Number y) {
            return AprationalMath.binomial((Aprational)((Aprational)x), (Aprational)((Aprational)y));
        }

        @Override
        public Number hypot(Number x, Number y) {
            return this.root(this.add(this.pow(x, 2L), this.pow(y, 2L)), 2L);
        }

        @Override
        protected Number root(Number x, long y) {
            return new Aprational(this.root(((Aprational)x).numerator(), y), this.root(((Aprational)x).denominator(), y));
        }

        private Apint root(Apint x, long y) {
            Apint[] root = ApintMath.root((Apint)x, (long)y);
            if (root[1].signum() != 0) {
                throw new IllegalArgumentException("Cannot calculate inexact root to infinite precision");
            }
            return root[0];
        }

        @Override
        protected Number roundToPrecision(Number x, long precision) {
            return AprationalMath.roundToPrecision((Aprational)((Aprational)x), (long)precision, (RoundingMode)RoundingMode.HALF_UP);
        }

        @Override
        public Number roundToInteger(Number x) {
            return AprationalMath.roundToInteger((Aprational)((Aprational)x), (RoundingMode)RoundingMode.HALF_UP);
        }

        @Override
        protected Number roundToPlaces(Number x, long places) {
            return AprationalMath.roundToPlaces((Aprational)((Aprational)x), (long)places, (RoundingMode)RoundingMode.HALF_UP);
        }

        @Override
        public Number roundToMultiple(Number x, Number y) {
            return AprationalMath.roundToMultiple((Aprational)((Aprational)x), (Aprational)((Aprational)y), (RoundingMode)RoundingMode.HALF_UP);
        }

        @Override
        protected Number scale(Number x, long y) {
            return AprationalMath.scale((Aprational)((Aprational)x), (long)y);
        }
    }

    private class ApfloatFunctions
    extends ApcomplexFunctions {
        private ApfloatFunctions() {
        }

        @Override
        public Number mod(Number x, Number y) {
            return ((Apfloat)x).mod((Apfloat)y);
        }

        @Override
        public Number ceil(Number x) {
            return ((Apfloat)x).ceil();
        }

        @Override
        public Number floor(Number x) {
            return ((Apfloat)x).floor();
        }

        @Override
        public Number frac(Number x) {
            return ((Apfloat)x).frac();
        }

        @Override
        public Number inverseErf(Number x) {
            return ApfloatMath.inverseErf((Apfloat)((Apfloat)x));
        }

        @Override
        public Number inverseErfc(Number x) {
            return ApfloatMath.inverseErfc((Apfloat)((Apfloat)x));
        }

        @Override
        public Number max(Number x, Number y) {
            return ApfloatMath.max((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y));
        }

        @Override
        public Number min(Number x, Number y) {
            return ApfloatMath.min((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y));
        }

        @Override
        public Number nextAfter(Number x, Number y) {
            return ApfloatMath.nextAfter((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y));
        }

        @Override
        public Number nextDown(Number x) {
            return ApfloatMath.nextDown((Apfloat)((Apfloat)x));
        }

        @Override
        public Number nextUp(Number x) {
            return ApfloatMath.nextUp((Apfloat)((Apfloat)x));
        }

        @Override
        public Number truncate(Number x) {
            return ((Apfloat)x).truncate();
        }

        @Override
        public Number toDegrees(Number x) {
            return ApfloatMath.toDegrees((Apfloat)((Apfloat)x));
        }

        @Override
        public Number toRadians(Number x) {
            return ApfloatMath.toRadians((Apfloat)((Apfloat)x));
        }

        @Override
        public Number atan2(Number x, Number y) {
            return ApfloatMath.atan2((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y));
        }

        @Override
        public Number copySign(Number x, Number y) {
            return ApfloatMath.copySign((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y));
        }

        @Override
        public Number fmod(Number x, Number y) {
            return ApfloatMath.fmod((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y));
        }

        @Override
        public Number hypot(Number x, Number y) {
            return ApcomplexMath.abs((Apcomplex)new Apcomplex((Apfloat)x, (Apfloat)y));
        }

        @Override
        public Number roundToPrecision(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Rounding can only be used with a valid integer argument");
            }
            return this.roundToPrecision(x, y.longValue());
        }

        protected Number roundToPrecision(Number x, long precision) {
            return ApfloatMath.roundToPrecision((Apfloat)((Apfloat)x), (long)precision, (RoundingMode)RoundingMode.HALF_UP);
        }

        @Override
        public Number roundToInteger(Number x) {
            return ApfloatMath.roundToInteger((Apfloat)((Apfloat)x), (RoundingMode)RoundingMode.HALF_UP);
        }

        @Override
        public Number roundToPlaces(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Rounding can only be used with a valid integer argument");
            }
            return this.roundToPlaces(x, y.longValue());
        }

        protected Number roundToPlaces(Number x, long precision) {
            return ApfloatMath.roundToPlaces((Apfloat)((Apfloat)x), (long)precision, (RoundingMode)RoundingMode.HALF_UP);
        }

        @Override
        public Number roundToMultiple(Number x, Number y) {
            return ApfloatMath.roundToMultiple((Apfloat)((Apfloat)x), (Apfloat)((Apfloat)y), (RoundingMode)RoundingMode.HALF_UP);
        }
    }

    private class ApcomplexFunctions
    implements FunctionCalculatorImpl.Functions {
        private ApcomplexFunctions() {
        }

        @Override
        public Number negate(Number x) {
            return ((Apcomplex)x).negate();
        }

        @Override
        public Number add(Number x, Number y) {
            return ((Apcomplex)x).add((Apcomplex)y);
        }

        @Override
        public Number subtract(Number x, Number y) {
            return ((Apcomplex)x).subtract((Apcomplex)y);
        }

        @Override
        public Number multiply(Number x, Number y) {
            return ((Apcomplex)x).multiply((Apcomplex)y);
        }

        @Override
        public Number divide(Number x, Number y) {
            return ((Apcomplex)x).divide((Apcomplex)y);
        }

        @Override
        public Number mod(Number x, Number y) {
            throw new IllegalArgumentException("Modulus can only be used with scalar values");
        }

        @Override
        public Number pow(Number x, Number y) {
            if (this.isLong(y)) {
                if (((Apcomplex)y).precision() < ((Apcomplex)x).precision()) {
                    x = ((Apcomplex)x).precision(((Apcomplex)y).precision());
                }
                return this.pow(x, y.longValue());
            }
            return ApcomplexMath.pow((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        protected Number pow(Number x, long y) {
            return ApcomplexMath.pow((Apcomplex)((Apcomplex)x), (long)y);
        }

        @Override
        public Number arg(Number x) {
            return ApcomplexMath.arg((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number conj(Number x) {
            return ((Apcomplex)x).conj();
        }

        @Override
        public Number imag(Number x) {
            return ((Apcomplex)x).imag();
        }

        @Override
        public Number real(Number x) {
            return ((Apcomplex)x).real();
        }

        @Override
        public Number abs(Number x) {
            return ApcomplexMath.abs((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number acos(Number x) {
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision(arg_0 -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).acos(arg_0), ApcomplexMath::acos, x);
        }

        @Override
        public Number acosh(Number x) {
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision(arg_0 -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).acosh(arg_0), ApcomplexMath::acosh, x);
        }

        @Override
        public Number airyAi(Number x) {
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision(arg_0 -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).airyAi(arg_0), ApcomplexMath::airyAi, x);
        }

        @Override
        public Number airyAiPrime(Number x) {
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision(arg_0 -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).airyAiPrime(arg_0), ApcomplexMath::airyAiPrime, x);
        }

        @Override
        public Number airyBi(Number x) {
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision(arg_0 -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).airyBi(arg_0), ApcomplexMath::airyBi, x);
        }

        @Override
        public Number airyBiPrime(Number x) {
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision(arg_0 -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).airyBiPrime(arg_0), ApcomplexMath::airyBiPrime, x);
        }

        @Override
        public Number asin(Number x) {
            return ApcomplexMath.asin((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number asinh(Number x) {
            return ApcomplexMath.asinh((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number atan(Number x) {
            return ApcomplexMath.atan((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number atanh(Number x) {
            return ApcomplexMath.atanh((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number bernoulli(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Bernoulli can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return AprationalMath.bernoulli((long)n);
        }

        @Override
        public Number bernoulliB(Number x, Number y) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Bernoulli B can only be used with a valid integer first argument");
            }
            long n = x.longValue();
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision((arg_0, arg_1) -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).bernoulliB(arg_0, arg_1), ApcomplexMath::bernoulliB, n, (Apcomplex)y);
        }

        @Override
        public Number besselI(Number x, Number y) {
            return ApcomplexMath.besselI((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number besselJ(Number x, Number y) {
            return ApcomplexMath.besselJ((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number besselK(Number x, Number y) {
            return ApcomplexMath.besselK((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number besselY(Number x, Number y) {
            return ApcomplexMath.besselY((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number beta(Number a, Number b) {
            return ApcomplexMath.beta((Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)b));
        }

        @Override
        public Number beta(Number x, Number a, Number b) {
            return ApcomplexMath.beta((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)b));
        }

        @Override
        public Number beta(Number x1, Number x2, Number a, Number b) {
            return ApcomplexMath.beta((Apcomplex)((Apcomplex)x1), (Apcomplex)((Apcomplex)x2), (Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)b));
        }

        @Override
        public Number binomial(Number x, Number y) {
            return ApcomplexMath.binomial((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number catalan(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Catalan can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApfloatMath.catalan((long)n);
        }

        @Override
        public Number cbrt(Number x) {
            return this.root(x, 3L);
        }

        @Override
        public Number ceil(Number x) {
            throw new IllegalArgumentException("Ceiling can only be used with scalar values");
        }

        @Override
        public Number chebyshevT(Number x, Number y) {
            return ApcomplexMath.chebyshevT((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number chebyshevU(Number x, Number y) {
            return ApcomplexMath.chebyshevU((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number cos(Number x) {
            return ApcomplexMath.cos((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number cosIntegral(Number x) {
            return ApcomplexMath.cosIntegral((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number cosh(Number x) {
            return ApcomplexMath.cosh((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number coshIntegral(Number x) {
            return ApcomplexMath.coshIntegral((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number digamma(Number x) {
            return ApcomplexMath.digamma((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number doubleFactorial(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Double factorial can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApintMath.doubleFactorial((long)n);
        }

        @Override
        public Number e(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("E can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApfloatMath.e((long)n);
        }

        @Override
        public Number ellipticE(Number x) {
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision(arg_0 -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).ellipticE(arg_0), ApcomplexMath::ellipticE, x);
        }

        @Override
        public Number ellipticK(Number x) {
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision(arg_0 -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).ellipticK(arg_0), ApcomplexMath::ellipticK, x);
        }

        @Override
        public Number erf(Number x) {
            return ApcomplexMath.erf((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number erfc(Number x) {
            return ApcomplexMath.erfc((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number erfi(Number x) {
            return ApcomplexMath.erfi((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number euler(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Euler can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApfloatMath.euler((long)n);
        }

        @Override
        public Number eulerE(Number x, Number y) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Euler E can only be used with a valid integer first argument");
            }
            long n = x.longValue();
            return ApfloatCalculatorImpl.this.fixedOrArbitraryPrecision((arg_0, arg_1) -> ((FixedPrecisionApcomplexHelper)ApfloatCalculatorImpl.this.fixedPrecisionApcomplexHelper).eulerE(arg_0, arg_1), ApcomplexMath::eulerE, n, (Apcomplex)y);
        }

        @Override
        public Number exp(Number x) {
            return ApcomplexMath.exp((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number expIntegralE(Number x, Number y) {
            return ApcomplexMath.expIntegralE((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number expIntegralEi(Number x) {
            return ApcomplexMath.expIntegralEi((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number factorial(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Factorial can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApintMath.factorial((long)n);
        }

        @Override
        public Number fibonacci(Number x, Number y) {
            return ApcomplexMath.fibonacci((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number floor(Number x) {
            throw new IllegalArgumentException("Floor can only be used with scalar values");
        }

        @Override
        public Number frac(Number x) {
            throw new IllegalArgumentException("Frac can only be used with scalar values");
        }

        @Override
        public Number fresnelC(Number x) {
            return ApcomplexMath.fresnelC((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number fresnelS(Number x) {
            return ApcomplexMath.fresnelS((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number gegenbauerC(Number x, Number y) {
            return ApcomplexMath.gegenbauerC((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number gegenbauerC(Number x, Number y, Number z) {
            return ApcomplexMath.gegenbauerC((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number glaisher(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Glaisher can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApfloatMath.glaisher((long)n);
        }

        @Override
        public Number gamma(Number x) {
            return ApcomplexMath.gamma((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number gamma(Number x, Number y) {
            return ApcomplexMath.gamma((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number gamma(Number x, Number y, Number z) {
            return ApcomplexMath.gamma((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number harmonicNumber(Number x) {
            return ApcomplexMath.harmonicNumber((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number harmonicNumber(Number x, Number y) {
            return ApcomplexMath.harmonicNumber((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number hermiteH(Number x, Number y) {
            return ApcomplexMath.hermiteH((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number hypergeometric0F1(Number a, Number z) {
            return ApcomplexMath.hypergeometric0F1((Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number hypergeometric0F1Regularized(Number a, Number z) {
            return ApcomplexMath.hypergeometric0F1Regularized((Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number hypergeometric1F1(Number a, Number b, Number z) {
            return ApcomplexMath.hypergeometric1F1((Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)b), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number hypergeometric1F1Regularized(Number a, Number b, Number z) {
            return ApcomplexMath.hypergeometric1F1Regularized((Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)b), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number hypergeometric2F1(Number a, Number b, Number c, Number z) {
            return ApcomplexMath.hypergeometric2F1((Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)b), (Apcomplex)((Apcomplex)c), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number hypergeometric2F1Regularized(Number a, Number b, Number c, Number z) {
            return ApcomplexMath.hypergeometric2F1Regularized((Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)b), (Apcomplex)((Apcomplex)c), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number hypergeometricU(Number a, Number b, Number z) {
            return ApcomplexMath.hypergeometricU((Apcomplex)((Apcomplex)a), (Apcomplex)((Apcomplex)b), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number inverseErf(Number x) {
            throw new IllegalArgumentException("Inverse erf can only be used with scalar values");
        }

        @Override
        public Number inverseErfc(Number x) {
            throw new IllegalArgumentException("Inverse erfc can only be used with scalar values");
        }

        @Override
        public Number jacobiP(Number x, Number y, Number z, Number w) {
            return ApcomplexMath.jacobiP((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y), (Apcomplex)((Apcomplex)z), (Apcomplex)((Apcomplex)w));
        }

        @Override
        public Number khinchin(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Khinchin can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApfloatMath.khinchin((long)n);
        }

        @Override
        public Number laguerreL(Number x, Number y) {
            return ApcomplexMath.laguerreL((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number laguerreL(Number x, Number y, Number z) {
            return ApcomplexMath.laguerreL((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number legendreP(Number x, Number y) {
            return ApcomplexMath.legendreP((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number legendreP(Number x, Number y, Number z) {
            return ApcomplexMath.legendreP((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number legendreQ(Number x, Number y) {
            return ApcomplexMath.legendreQ((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number legendreQ(Number x, Number y, Number z) {
            return ApcomplexMath.legendreQ((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y), (Apcomplex)((Apcomplex)z));
        }

        @Override
        public Number log(Number x) {
            return ApcomplexMath.log((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number log(Number x, Number y) {
            return ApcomplexMath.log((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number logGamma(Number x) {
            return ApcomplexMath.logGamma((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number logIntegral(Number x) {
            return ApcomplexMath.logIntegral((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number logisticSigmoid(Number x) {
            return ApcomplexMath.logisticSigmoid((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number max(Number x, Number y) {
            throw new IllegalArgumentException("Max can only be used with scalar values");
        }

        @Override
        public Number min(Number x, Number y) {
            throw new IllegalArgumentException("Min can only be used with scalar values");
        }

        @Override
        public Number nextAfter(Number x, Number y) {
            throw new IllegalArgumentException("Next after can only be used with scalar values");
        }

        @Override
        public Number nextDown(Number x) {
            throw new IllegalArgumentException("Next down can only be used with scalar values");
        }

        @Override
        public Number nextUp(Number x) {
            throw new IllegalArgumentException("Next up can only be used with scalar values");
        }

        @Override
        public Number pi(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Pi can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApfloatMath.pi((long)n);
        }

        @Override
        public Number pochhammer(Number x, Number y) {
            return ApcomplexMath.pochhammer((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number polygamma(Number x, Number y) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Polygamma can only be used with a valid integer first argument");
            }
            long n = x.longValue();
            return ApcomplexMath.polygamma((long)n, (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number polylog(Number x, Number y) {
            return ApcomplexMath.polylog((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number random(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Random can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApfloatMath.random((long)n);
        }

        @Override
        public Number randomGaussian(Number x) {
            if (!this.isLong(x)) {
                throw new IllegalArgumentException("Random Gaussian can only be used with a valid integer argument");
            }
            long n = x.longValue();
            return ApfloatMath.randomGaussian((long)n);
        }

        @Override
        public Number round(Number x, Number y) {
            return this.roundToPrecision(x, y);
        }

        @Override
        public Number roundToPrecision(Number x, Number y) {
            throw new IllegalArgumentException("Rounding can only be used with scalar values");
        }

        @Override
        public Number roundToInteger(Number x) {
            throw new IllegalArgumentException("Rounding can only be used with scalar values");
        }

        @Override
        public Number roundToPlaces(Number x, Number y) {
            throw new IllegalArgumentException("Rounding can only be used with scalar values");
        }

        @Override
        public Number roundToMultiple(Number x, Number y) {
            throw new IllegalArgumentException("Rounding can only be used with scalar values");
        }

        @Override
        public Number sin(Number x) {
            return ApcomplexMath.sin((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number sinc(Number x) {
            return ApcomplexMath.sinc((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number sinIntegral(Number x) {
            return ApcomplexMath.sinIntegral((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number sinh(Number x) {
            return ApcomplexMath.sinh((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number sinhIntegral(Number x) {
            return ApcomplexMath.sinhIntegral((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number sphericalHarmonicY(Number x, Number y, Number z, Number w) {
            return ApcomplexMath.sphericalHarmonicY((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y), (Apcomplex)((Apcomplex)z), (Apcomplex)((Apcomplex)w));
        }

        @Override
        public Number sqrt(Number x) {
            return this.root(x, 2L);
        }

        @Override
        public Number tan(Number x) {
            return ApcomplexMath.tan((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number tanh(Number x) {
            return ApcomplexMath.tanh((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number truncate(Number x) {
            throw new IllegalArgumentException("Truncate can only be used with scalar values");
        }

        @Override
        public Number toDegrees(Number x) {
            throw new IllegalArgumentException("ToDegrees can only be used with scalar values");
        }

        @Override
        public Number toRadians(Number x) {
            throw new IllegalArgumentException("ToRadians can only be used with scalar values");
        }

        @Override
        public Number ulp(Number x) {
            return ApcomplexMath.ulp((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number zeta(Number x) {
            return ApcomplexMath.zeta((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number zeta(Number x, Number y) {
            return ApcomplexMath.zeta((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number agm(Number x, Number y) {
            return ApcomplexMath.agm((Apcomplex)((Apcomplex)x), (Apcomplex)((Apcomplex)y));
        }

        @Override
        public Number w(Number x) {
            return ApcomplexMath.w((Apcomplex)((Apcomplex)x));
        }

        @Override
        public Number w(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Lambert W can only be used with a valid integer argument");
            }
            return ApcomplexMath.w((Apcomplex)((Apcomplex)x), (long)y.longValue());
        }

        @Override
        public Number atan2(Number x, Number y) {
            throw new IllegalArgumentException("Atan2 can only be used with scalar values");
        }

        @Override
        public Number copySign(Number x, Number y) {
            throw new IllegalArgumentException("CopySign can only be used with scalar values");
        }

        @Override
        public Number fmod(Number x, Number y) {
            throw new IllegalArgumentException("Fmod can only be used with scalar values");
        }

        @Override
        public Number gcd(Number x, Number y) {
            throw new IllegalArgumentException("Greatest Common Ddivisor can only be used with integer values");
        }

        @Override
        public Number hypot(Number x, Number y) {
            throw new IllegalArgumentException("Hypot can only be used with scalar values");
        }

        @Override
        public Number inverseRoot(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Inverse root can only be used with a valid integer argument");
            }
            return this.inverseRoot(x, y.longValue());
        }

        @Override
        public Number inverseRoot(Number x, Number y, Number z) {
            if (!this.isLong(y) || !this.isLong(z)) {
                throw new IllegalArgumentException("Inverse root can only be used with valid integer arguments");
            }
            return this.inverseRoot(x, y.longValue(), z.longValue());
        }

        protected Number inverseRoot(Number x, long y) {
            return ApcomplexMath.inverseRoot((Apcomplex)((Apcomplex)x), (long)y);
        }

        protected Number inverseRoot(Number x, long y, long z) {
            return ApcomplexMath.inverseRoot((Apcomplex)((Apcomplex)x), (long)y, (long)z);
        }

        @Override
        public Number lcm(Number x, Number y) {
            throw new IllegalArgumentException("Least Common Multiplier can only be used with integer values");
        }

        @Override
        public Number root(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Root can only be used with a valid integer argument");
            }
            return this.root(x, y.longValue());
        }

        @Override
        public Number root(Number x, Number y, Number z) {
            if (!this.isLong(y) || !this.isLong(z)) {
                throw new IllegalArgumentException("Root can only be used with valid integer arguments");
            }
            return this.root(x, y.longValue(), z.longValue());
        }

        protected Number root(Number x, long y) {
            return ApcomplexMath.root((Apcomplex)((Apcomplex)x), (long)y);
        }

        protected Number root(Number x, long y, long z) {
            return ApcomplexMath.root((Apcomplex)((Apcomplex)x), (long)y, (long)z);
        }

        @Override
        public Number scale(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Scale can only be used with a valid integer argument");
            }
            return this.scale(x, y.longValue());
        }

        protected Number scale(Number x, long y) {
            return ApcomplexMath.scale((Apcomplex)((Apcomplex)x), (long)y);
        }

        @Override
        public Number precision(Number x, Number y) {
            if (!this.isLong(y)) {
                throw new IllegalArgumentException("Precision can only be used with a valid integer argument");
            }
            return this.precision(x, y.longValue());
        }

        protected Number precision(Number x, long precision) {
            return ((Apcomplex)x).precision(precision);
        }

        protected boolean isLong(Number value) {
            return value instanceof Long || value != null && new Apint(value.longValue()).equals((Object)value);
        }
    }
}

