/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import com.aparapi.Kernel;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.spi.ArrayAccess;

class IntKernel
extends Kernel {
    private static ThreadLocal<IntKernel> kernel = new ThreadLocal<IntKernel>(){

        @Override
        public IntKernel initialValue() {
            return new IntKernel();
        }
    };
    public static final int TRANSFORM_ROWS = 1;
    public static final int INVERSE_TRANSFORM_ROWS = 2;
    private int stride;
    private int length;
    private int[] data;
    private int offset;
    private int[] wTable = new int[]{0};
    private int[] permutationTable = new int[]{0};
    private int permutationTableLength;
    private int modulus;
    private long inverseModulus;
    public static final int TRANSPOSE = 3;
    public static final int PERMUTE = 4;
    private int n2;
    private int[] index = new int[]{0};
    private int indexCount;
    public static final int MULTIPLY_ELEMENTS = 5;
    private int startRow;
    private int startColumn;
    private int rows;
    private int columns;
    private int w;
    private int scaleFactor;
    public static final int TRANSFORM_COLUMNS = 6;
    public static final int INVERSE_TRANSFORM_COLUMNS = 7;
    private int op;
    private int ww;
    private int w1;
    private int w2;

    private IntKernel() {
    }

    public static IntKernel getInstance() {
        return kernel.get();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setArrayAccess(ArrayAccess arrayAccess) throws ApfloatRuntimeException {
        this.data = arrayAccess.getIntData();
        this.offset = arrayAccess.getOffset();
        if (this.length != 0) {
            this.stride = arrayAccess.getLength() / this.length;
        }
    }

    public void setWTable(int[] wTable) {
        this.wTable = wTable;
    }

    public void setPermutationTable(int[] permutationTable) {
        this.permutationTable = permutationTable == null ? new int[1] : permutationTable;
        this.permutationTableLength = permutationTable == null ? 0 : permutationTable.length;
    }

    private void columnTableFNT() {
        int istep = 0;
        int mmax = 0;
        int r = 0;
        int[] data = this.data;
        int offset = this.offset + this.getGlobalId();
        int stride = this.stride;
        int nn = this.length;
        if (nn >= 2) {
            r = 1;
            for (mmax = nn >> 1; mmax > 0; mmax >>= 1) {
                istep = mmax << 1;
                for (int i = offset; i < offset + nn * stride; i += istep * stride) {
                    int j = i + mmax * stride;
                    int a = data[i];
                    int b = data[j];
                    data[i] = this.modAdd(a, b);
                    data[j] = this.modSubtract(a, b);
                }
                int t = r;
                for (int m = 1; m < mmax; ++m) {
                    for (int i = offset + m * stride; i < offset + nn * stride; i += istep * stride) {
                        int j = i + mmax * stride;
                        int a = data[i];
                        int b = data[j];
                        data[i] = this.modAdd(a, b);
                        data[j] = this.modMultiply(this.wTable[t], this.modSubtract(a, b));
                    }
                    t += r;
                }
                r <<= 1;
            }
            if (this.permutationTableLength > 0) {
                this.columnScramble(offset);
            }
        }
    }

    private void inverseColumnTableFNT() {
        int istep = 0;
        int mmax = 0;
        int r = 0;
        int[] data = this.data;
        int offset = this.offset + this.getGlobalId();
        int stride = this.stride;
        int nn = this.length;
        if (nn >= 2) {
            if (this.permutationTableLength > 0) {
                this.columnScramble(offset);
            }
            r = nn;
            mmax = 1;
            while (nn > mmax) {
                istep = mmax << 1;
                r >>= 1;
                for (int i = offset; i < offset + nn * stride; i += istep * stride) {
                    int j = i + mmax * stride;
                    int wTemp = data[j];
                    data[j] = this.modSubtract(data[i], wTemp);
                    data[i] = this.modAdd(data[i], wTemp);
                }
                int t = r;
                for (int m = 1; m < mmax; ++m) {
                    for (int i = offset + m * stride; i < offset + nn * stride; i += istep * stride) {
                        int j = i + mmax * stride;
                        int wTemp = this.modMultiply(this.wTable[t], data[j]);
                        data[j] = this.modSubtract(data[i], wTemp);
                        data[i] = this.modAdd(data[i], wTemp);
                    }
                    t += r;
                }
                mmax = istep;
            }
        }
    }

    private void columnScramble(int offset) {
        for (int k = 0; k < this.permutationTableLength; k += 2) {
            int i = offset + this.permutationTable[k] * this.stride;
            int j = offset + this.permutationTable[k + 1] * this.stride;
            int tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
        }
    }

    private int modMultiply(int a, int b) {
        long t = (long)a * (long)b;
        int r1 = (int)t - (int)((t >>> 30) * this.inverseModulus >>> 33) * this.modulus;
        int r2 = r1 - this.modulus;
        return r2 < 0 ? r1 : r2;
    }

    private int modAdd(int a, int b) {
        int r1 = a + b;
        int r2 = r1 - this.modulus;
        return r2 < 0 ? r1 : r2;
    }

    private int modSubtract(int a, int b) {
        int r1 = a - b;
        int r2 = r1 + this.modulus;
        return r1 < 0 ? r2 : r1;
    }

    public void setModulus(int modulus) {
        this.inverseModulus = (long)(9.223372036854776E18 / (double)modulus);
        this.modulus = modulus;
    }

    public int getModulus() {
        return this.modulus;
    }

    public void setN2(int n2) {
        this.n2 = n2;
    }

    public void setIndex(int[] index) {
        this.index = index;
    }

    public void setIndexCount(int indexCount) {
        this.indexCount = indexCount;
    }

    private void transpose() {
        int j;
        int i = this.getGlobalId(0);
        if (i < (j = this.getGlobalId(1))) {
            int position1 = this.offset + j * this.n2 + i;
            int position2 = this.offset + i * this.n2 + j;
            int tmp = this.data[position1];
            this.data[position1] = this.data[position2];
            this.data[position2] = tmp;
        }
    }

    private void permute() {
        int j = this.getGlobalId();
        for (int i = 0; i < this.indexCount; ++i) {
            int o = this.index[i];
            int tmp = this.data[this.offset + this.n2 * o + j];
            ++i;
            while (this.index[i] != 0) {
                int m = this.index[i];
                this.data[this.offset + this.n2 * o + j] = this.data[this.offset + this.n2 * m + j];
                o = m;
                ++i;
            }
            this.data[this.offset + this.n2 * o + j] = tmp;
        }
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setStartColumn(int startColumn) {
        this.startColumn = startColumn;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setW(int w) {
        this.w = w;
    }

    public void setScaleFactor(int scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    private void multiplyElements() {
        int[] data = this.data;
        int position = this.offset + this.getGlobalId();
        int rowFactor = this.modPow(this.w, this.startRow);
        int columnFactor = this.modPow(this.w, this.startColumn + this.getGlobalId());
        int rowStartFactor = this.modMultiply(this.scaleFactor, this.modPow(rowFactor, this.startColumn + this.getGlobalId()));
        for (int i = 0; i < this.rows; ++i) {
            data[position] = this.modMultiply(data[position], rowStartFactor);
            position += this.columns;
            rowStartFactor = this.modMultiply(rowStartFactor, columnFactor);
        }
    }

    private int modPow(int a, int n) {
        if (n == 0) {
            return 1;
        }
        if (n < 0) {
            n = this.getModulus() - 1 + n;
        }
        int exponent = n;
        while ((exponent & 1) == 0) {
            a = this.modMultiply(a, a);
            exponent >>= 1;
        }
        int r = a;
        exponent >>= 1;
        while (exponent > 0) {
            a = this.modMultiply(a, a);
            if ((exponent & 1) != 0) {
                r = this.modMultiply(r, a);
            }
            exponent >>= 1;
        }
        return r;
    }

    public void setOp(int op) {
        this.op = op;
    }

    public void setWw(int ww) {
        this.ww = ww;
    }

    public void setW1(int w1) {
        this.w1 = w1;
    }

    public void setW2(int w2) {
        this.w2 = w2;
    }

    public void run() {
        if (this.op == 1) {
            this.columnTableFNT();
        } else if (this.op == 2) {
            this.inverseColumnTableFNT();
        } else if (this.op == 3) {
            this.transpose();
        } else if (this.op == 4) {
            this.permute();
        } else if (this.op == 5) {
            this.multiplyElements();
        } else if (this.op == 6 || this.op == 7) {
            this.transformColumns();
        }
    }

    private void transformColumns() {
        int i = this.getGlobalId();
        int tmp1 = this.modPow(this.w, this.startColumn + i);
        int tmp2 = this.modPow(this.ww, this.startColumn + i);
        int x0 = this.data[this.offset + i];
        int x1 = this.data[this.offset + this.columns + i];
        int x2 = this.data[this.offset + 2 * this.columns + i];
        if (this.op == 7) {
            x1 = this.modMultiply(x1, tmp1);
            x2 = this.modMultiply(x2, tmp2);
        }
        int t = this.modAdd(x1, x2);
        x2 = this.modSubtract(x1, x2);
        x0 = this.modAdd(x0, t);
        t = this.modMultiply(t, this.w1);
        x2 = this.modMultiply(x2, this.w2);
        t = this.modAdd(t, x0);
        x1 = this.modAdd(t, x2);
        x2 = this.modSubtract(t, x2);
        if (this.op == 6) {
            x1 = this.modMultiply(x1, tmp1);
            x2 = this.modMultiply(x2, tmp2);
        }
        this.data[this.offset + i] = x0;
        this.data[this.offset + this.columns + i] = x1;
        this.data[this.offset + 2 * this.columns + i] = x2;
    }
}

