/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.config;

import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.MongoDbAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.mongo.MongoDbAuthenticationProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.mongodb.core.MongoTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="CasMongoAuthenticationConfiguration", proxyBeanMethods=false)
public class CasMongoAuthenticationConfiguration {
    @ConditionalOnMissingBean(name={"mongoPrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory mongoPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"mongoAuthenticationHandler"})
    public AuthenticationHandler mongoAuthenticationHandler(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="mongoPrincipalFactory") PrincipalFactory mongoPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
        MongoDbAuthenticationProperties mongo = casProperties.getAuthn().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
        MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
        MongoDbAuthenticationHandler handler = new MongoDbAuthenticationHandler(mongo.getName(), servicesManager, mongoPrincipalFactory, mongo, mongoTemplate);
        handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)mongo.getPasswordEncoder(), (ApplicationContext)applicationContext));
        handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)mongo.getPrincipalTransformation()));
        return handler;
    }

    @ConditionalOnMissingBean(name={"mongoAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer mongoAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="mongoAuthenticationHandler") AuthenticationHandler mongoAuthenticationHandler, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(mongoAuthenticationHandler, defaultPrincipalResolver);
    }
}

