/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.impl.QNameReflectionParams;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QNameHelper {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xbean$spring$context$impl$QNameHelper == null ? (class$org$apache$xbean$spring$context$impl$QNameHelper = QNameHelper.class$("org.apache.xbean.spring.context.impl.QNameHelper")) : class$org$apache$xbean$spring$context$impl$QNameHelper));
    private static final Method addPropertyValueMethod;
    static /* synthetic */ Class class$org$apache$xbean$spring$context$impl$QNameHelper;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class array$Ljavax$xml$namespace$QName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$springframework$beans$MutablePropertyValues;

    public static QName createQName(Element element, String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index >= 0) {
            String prefix = qualifiedName.substring(0, index);
            String localName = qualifiedName.substring(index + 1);
            String uri = QNameHelper.recursiveGetAttributeValue(element, "xmlns:" + prefix);
            return new QName(uri, localName, prefix);
        }
        String uri = QNameHelper.recursiveGetAttributeValue(element, "xmlns");
        if (uri != null) {
            return new QName(uri, qualifiedName);
        }
        return new QName(qualifiedName);
    }

    public static String recursiveGetAttributeValue(Element element, String attributeName) {
        Node parentNode;
        String answer;
        block3: {
            answer = null;
            try {
                answer = element.getAttribute(attributeName);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)("Caught exception looking up attribute: " + attributeName + " on element: " + element + ". Cause: " + e), (Throwable)e);
            }
        }
        if ((answer == null || answer.length() == 0) && (parentNode = element.getParentNode()) instanceof Element) {
            return QNameHelper.recursiveGetAttributeValue((Element)parentNode, attributeName);
        }
        return answer;
    }

    public static void coerceQNamePropertyValues(QNameReflectionParams params) {
        QNameHelper.coerceNamespaceAwarePropertyValues(params.getBeanDefinition(), params.getElement(), params.getDescriptors(), params.getIndex());
    }

    public static void coerceNamespaceAwarePropertyValues(AbstractBeanDefinition bd, Element element, PropertyDescriptor[] descriptors, int i) {
        PropertyDescriptor descriptor = descriptors[i];
        if (descriptor.getPropertyType() == null) {
            return;
        }
        if (descriptor.getPropertyType().isAssignableFrom(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = QNameHelper.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName)) {
            Object value;
            String name = descriptor.getName();
            MutablePropertyValues propertyValues = bd.getPropertyValues();
            PropertyValue propertyValue = propertyValues.getPropertyValue(name);
            if (propertyValue != null && (value = propertyValue.getValue()) instanceof String) {
                propertyValues.removePropertyValue(propertyValue);
                QNameHelper.addPropertyValue(propertyValues, name, QNameHelper.createQName(element, (String)value));
            }
        } else if (descriptor.getPropertyType().isAssignableFrom(array$Ljavax$xml$namespace$QName == null ? (array$Ljavax$xml$namespace$QName = QNameHelper.class$("[Ljavax.xml.namespace.QName;")) : array$Ljavax$xml$namespace$QName)) {
            Object value;
            String name = descriptor.getName();
            MutablePropertyValues propertyValues = bd.getPropertyValues();
            PropertyValue propertyValue = propertyValues.getPropertyValue(name);
            if (propertyValue != null && (value = propertyValue.getValue()) instanceof List) {
                List values = (List)value;
                ManagedList newValues = new ManagedList();
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    Object v = iter.next();
                    if (v instanceof String) {
                        newValues.add(QNameHelper.createQName(element, (String)v));
                        continue;
                    }
                    newValues.add(v);
                }
                propertyValues.removePropertyValue(propertyValue);
                propertyValues.addPropertyValue(name, (Object)newValues);
            }
        }
    }

    public static void addPropertyValue(MutablePropertyValues values, String name, Object value) {
        try {
            addPropertyValueMethod.invoke((Object)values, name, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error adding property definition", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            addPropertyValueMethod = (class$org$springframework$beans$MutablePropertyValues == null ? (class$org$springframework$beans$MutablePropertyValues = QNameHelper.class$("org.springframework.beans.MutablePropertyValues")) : class$org$springframework$beans$MutablePropertyValues).getMethod("addPropertyValue", class$java$lang$String == null ? (class$java$lang$String = QNameHelper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = QNameHelper.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find MutablePropertyValues:addPropertyValue", e);
        }
    }
}

