/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import org.apache.xbean.classloader.ClassLoaderUtil;
import org.apache.xbean.classloader.DestroyableClassLoader;

public class NamedClassLoader
extends URLClassLoader
implements DestroyableClassLoader {
    private final String name;
    private volatile boolean destroyed = false;

    public NamedClassLoader(String name, URL[] urls) {
        super(urls);
        this.name = name;
    }

    public NamedClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.name = name;
    }

    public NamedClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.name = name;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        NamedClassLoader namedClassLoader = this;
        synchronized (namedClassLoader) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        ClassLoaderUtil.destroy(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": name=" + this.getName() + " urls=" + Arrays.asList(this.getURLs()) + "]";
    }
}

