/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.xbean.classloader.JarFileUrlConnection;

public class JarFileUrlStreamHandler
extends URLStreamHandler {
    private URL expectedUrl;
    private final JarFile jarFile;
    private final JarEntry jarEntry;

    public static URL createUrl(JarFile jarFile, JarEntry jarEntry) throws MalformedURLException {
        return JarFileUrlStreamHandler.createUrl(jarFile, jarEntry, new File(jarFile.getName()).toURI().toURL());
    }

    public static URL createUrl(JarFile jarFile, JarEntry jarEntry, URL codeSource) throws MalformedURLException {
        JarFileUrlStreamHandler handler = new JarFileUrlStreamHandler(jarFile, jarEntry);
        URL url = new URL("jar", "", -1, codeSource + "!/" + jarEntry.getName(), handler);
        handler.setExpectedUrl(url);
        return url;
    }

    public JarFileUrlStreamHandler(JarFile jarFile, JarEntry jarEntry) {
        if (jarFile == null) {
            throw new NullPointerException("jarFile is null");
        }
        if (jarEntry == null) {
            throw new NullPointerException("jarEntry is null");
        }
        this.jarFile = jarFile;
        this.jarEntry = jarEntry;
    }

    public void setExpectedUrl(URL expectedUrl) {
        if (expectedUrl == null) {
            throw new NullPointerException("expectedUrl is null");
        }
        this.expectedUrl = expectedUrl;
    }

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        if (this.expectedUrl == null) {
            throw new IllegalStateException("expectedUrl was not set");
        }
        if (!this.expectedUrl.equals(url)) {
            if (!url.getProtocol().equals("jar")) {
                throw new IllegalArgumentException("Unsupported protocol " + url.getProtocol());
            }
            String path = url.getPath();
            String[] chunks = path.split("!/", 2);
            if (chunks.length == 1) {
                throw new MalformedURLException("Url does not contain a '!' character: " + url);
            }
            String file = chunks[0];
            String entryPath = chunks[1];
            if (!file.startsWith("file:")) {
                return new URL(url.toExternalForm()).openConnection();
            }
            file = file.substring("file:".length());
            if (!this.jarFile.getName().equals(file)) {
                return new URL(url.toExternalForm()).openConnection();
            }
            JarEntry newEntry = this.jarFile.getJarEntry(entryPath);
            if (newEntry == null) {
                throw new FileNotFoundException("Entry not found: " + url);
            }
            return new JarFileUrlConnection(url, this.jarFile, newEntry);
        }
        return new JarFileUrlConnection(url, this.jarFile, this.jarEntry);
    }
}

