/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;

public final class XmlSchemaNamespaceContext
implements NamespacePrefixList {
    private Map<String, List<String>> namespacesByPrefixStack = new HashMap<String, List<String>>();

    public XmlSchemaNamespaceContext() {
        this.namespacesByPrefixStack.put("xml", Collections.singletonList("http://www.w3.org/XML/1998/namespace"));
        this.namespacesByPrefixStack.put("xmlns", Collections.singletonList("http://www.w3.org/2000/xmlns/"));
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null.");
        }
        List<String> namespaces = this.namespacesByPrefixStack.get(prefix);
        String namespace = null;
        namespace = namespaces == null || namespaces.isEmpty() ? "" : namespaces.get(namespaces.size() - 1);
        return namespace;
    }

    public String getPrefix(String namespaceUri) {
        if (namespaceUri == null) {
            throw new IllegalArgumentException("Namespace cannot be null.");
        }
        for (Map.Entry<String, List<String>> prefixEntry : this.namespacesByPrefixStack.entrySet()) {
            List<String> namespaceStack = prefixEntry.getValue();
            if (namespaceStack == null || namespaceStack.isEmpty() || !namespaceStack.get(namespaceStack.size() - 1).equals(namespaceUri)) continue;
            return prefixEntry.getKey();
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceUri) {
        if (namespaceUri == null) {
            throw new IllegalArgumentException("The Namespace URI cannot be null.");
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        for (Map.Entry<String, List<String>> prefixEntry : this.namespacesByPrefixStack.entrySet()) {
            List<String> namespaceStack = prefixEntry.getValue();
            if (namespaceStack == null || namespaceStack.isEmpty() || !namespaceStack.get(namespaceStack.size() - 1).equals(namespaceUri)) continue;
            prefixes.add(prefixEntry.getKey());
        }
        return prefixes.iterator();
    }

    public String[] getDeclaredPrefixes() {
        Set<String> prefixes = this.namespacesByPrefixStack.keySet();
        return prefixes.toArray(new String[prefixes.size()]);
    }

    public void addNamespace(String prefix, String namespaceUri) {
        if (prefix == null || namespaceUri == null || namespaceUri.length() == 0) {
            throw new IllegalArgumentException("The prefix may not be null, and the namespace URI may neither be null nor empty.");
        }
        if (XmlSchemaNamespaceContext.isRecognizedPrefix(prefix)) {
            return;
        }
        List<String> namespaceStack = this.namespacesByPrefixStack.get(prefix);
        if (namespaceStack == null) {
            namespaceStack = new ArrayList<String>(1);
            this.namespacesByPrefixStack.put(prefix, namespaceStack);
        }
        namespaceStack.add(namespaceUri);
    }

    public void removeNamespace(String prefix) {
        List<String> namespaceStack = this.namespacesByPrefixStack.get(prefix);
        if (namespaceStack == null || namespaceStack.isEmpty()) {
            throw new IllegalStateException("Prefix \"" + prefix + "\" is not mapped to any namespaces.");
        }
        if (XmlSchemaNamespaceContext.isRecognizedPrefix(prefix)) {
            return;
        }
        namespaceStack.remove(namespaceStack.size() - 1);
        if (namespaceStack.isEmpty()) {
            this.namespacesByPrefixStack.remove(prefix);
        }
    }

    public void clear() {
        this.namespacesByPrefixStack.clear();
        this.namespacesByPrefixStack.put("xml", Collections.singletonList("http://www.w3.org/XML/1998/namespace"));
        this.namespacesByPrefixStack.put("xmlns", Collections.singletonList("http://www.w3.org/2000/xmlns/"));
    }

    private static boolean isRecognizedPrefix(String prefix) {
        return "xml".equals(prefix) || "xmlns".equals(prefix);
    }
}

