/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.net.protocol.mem;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.activation.DataSource;
import org.apache.axiom.testutils.net.protocol.mem.DataSourceRegistration;

public final class DataSourceRegistry {
    private static boolean handlerRegistered;
    private static final Map<String, DataSource> dataSources;

    private DataSourceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DataSourceRegistration registerDataSource(DataSource dataSource) {
        if (!handlerRegistered) {
            Properties systemProps;
            Properties properties = systemProps = System.getProperties();
            synchronized (properties) {
                StringBuilder pkgs = new StringBuilder(systemProps.getProperty("java.protocol.handler.pkgs", ""));
                if (pkgs.length() > 0) {
                    pkgs.append('|');
                }
                pkgs.append("org.apache.axiom.testutils.net.protocol");
                systemProps.setProperty("java.protocol.handler.pkgs", pkgs.toString());
            }
            handlerRegistered = true;
        }
        final String id = UUID.randomUUID().toString();
        dataSources.put(id, dataSource);
        return new DataSourceRegistration(){

            @Override
            public URL getURL() {
                try {
                    return new URL("mem", "", id);
                }
                catch (MalformedURLException ex) {
                    throw new Error(ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregister() {
                Class<DataSourceRegistry> clazz = DataSourceRegistry.class;
                synchronized (DataSourceRegistry.class) {
                    dataSources.remove(id);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
    }

    static synchronized DataSource lookupDataSource(String id) {
        return dataSources.get(id);
    }

    static {
        dataSources = new HashMap<String, DataSource>();
    }
}

