/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.ext.io.StreamCopyException;

public class RandomBlob
implements Blob {
    private final long seed;
    private final int rangeStart;
    private final int rangeEnd;
    private final long length;

    public RandomBlob(long seed, int rangeStart, int rangeEnd, long length) {
        this.seed = seed;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.length = length;
    }

    public RandomBlob(long seed, long length) {
        this(seed, 0, 256, length);
    }

    public RandomBlob(long length) {
        this(System.currentTimeMillis(), length);
    }

    public InputStream getInputStream() throws IOException {
        final Random random = new Random(this.seed);
        return new InputStream(){
            private long position;

            @Override
            public int read() throws IOException {
                if (this.position == RandomBlob.this.length) {
                    return -1;
                }
                ++this.position;
                return random.nextInt(RandomBlob.this.rangeEnd - RandomBlob.this.rangeStart) + RandomBlob.this.rangeStart;
            }
        };
    }

    public void writeTo(OutputStream out) throws StreamCopyException {
        Random random = new Random(this.seed);
        for (long i = 0L; i < this.length; ++i) {
            try {
                out.write(random.nextInt(this.rangeEnd - this.rangeStart) + this.rangeStart);
                continue;
            }
            catch (IOException ex) {
                throw new StreamCopyException(2, ex);
            }
        }
    }

    public long getSize() {
        return this.length;
    }
}

