/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.cpe;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.CasToInlineXml;

public class InlineXmlCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    private File mOutputDir;
    private CasToInlineXml cas2xml;
    private int mDocNum;

    public void initialize() throws ResourceInitializationException {
        this.mDocNum = 0;
        this.mOutputDir = new File(((String)this.getConfigParameterValue(PARAM_OUTPUTDIR)).trim());
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
        this.cas2xml = new CasToInlineXml();
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        FSIterator it = jcas.getAnnotationIndex(SourceDocumentInformation.type).iterator();
        File outFile = null;
        if (it.hasNext()) {
            SourceDocumentInformation fileLoc = (SourceDocumentInformation)((Object)it.next());
            try {
                File inFile = new File(new URL(fileLoc.getUri()).getPath());
                outFile = new File(this.mOutputDir, inFile.getName());
            }
            catch (MalformedURLException e1) {
                // empty catch block
            }
        }
        if (outFile == null) {
            outFile = new File(this.mOutputDir, "doc" + this.mDocNum++);
        }
        try {
            String xmlAnnotations = this.cas2xml.generateXML(aCAS);
            FileOutputStream outStream = new FileOutputStream(outFile);
            outStream.write(xmlAnnotations.getBytes("UTF-8"));
            outStream.close();
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }
}

