/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.dde.internal.page;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.deployment.AEDeploymentDescription;
import org.apache.uima.aae.deployment.AEService;
import org.apache.uima.aae.deployment.AsyncAEErrorConfiguration;
import org.apache.uima.aae.deployment.AsyncAggregateErrorConfiguration;
import org.apache.uima.aae.deployment.impl.AEDelegates_Impl;
import org.apache.uima.aae.deployment.impl.AEDeploymentMetaData_Impl;
import org.apache.uima.aae.deployment.impl.DeploymentMetaData_Impl;
import org.apache.uima.aae.deployment.impl.NameValue;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.dde.internal.DeploymentDescriptorEditor;
import org.apache.uima.dde.internal.Messages;
import org.apache.uima.dde.internal.page.AbstractHeaderPage;
import org.apache.uima.dde.internal.wizards.EditParamWizard;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.taeconfigurator.editors.ui.FileAndShortName;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.files.MultiResourceSelectionDialog;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.tools.internal.cde.uima.util.UimaDescriptionUtils;
import org.apache.uima.tools.internal.ui.forms.FormSection;
import org.apache.uima.tools.internal.ui.forms.FormSection2;
import org.apache.uima.util.InvalidXMLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OverviewPage
extends AbstractHeaderPage {
    private static final int SERVICE_PANE_INDENT = 8;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private IManagedForm mForm;
    private ScrolledForm form;
    private DecoratedField brokerUrlDecoField;
    private DecoratedField endPointDecoField;
    private DecoratedField topDescriptorDecoField;
    private FieldDecoration decorationBrokerUrl;
    private FieldDecoration decorationEndPoint;
    private FieldDecoration decorationTopDescriptor;
    private Text brokerUrl;
    private Text endPoint;
    private Spinner initialFsHeapSize;
    private Spinner casPoolSize;
    private Spinner prefetch;
    private Text topDescriptorField;
    private Label importByNameOrLocation;
    private boolean isImportByLocation = true;
    private DeploymentDescriptorEditor multiPageEditor;
    private AEDeploymentDescription aeDeploymentDescription;
    private AEService aeService;
    private Button customButton;
    private Composite customComposite;
    private Composite serviceSectionClient;
    private Text nameText;
    private Text description;
    private Text version;
    private Text vendor;
    private boolean ignoreUpdate = false;
    private Action openAction;
    private Action notInWSAction;
    private TableViewer envTableViewer;
    private Table envTable;
    private Map<String, NameValue> envName2NameValueMap = new TreeMap<String, NameValue>();
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private ColumnLayoutData[] envTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(200), new ColumnWeightData(300)};
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source == OverviewPage.this.brokerUrl) {
                OverviewPage.this.aeService.setBrokerURL(OverviewPage.this.brokerUrl.getText().trim());
            } else if (source == OverviewPage.this.endPoint) {
                OverviewPage.this.aeService.setEndPoint(OverviewPage.this.endPoint.getText().trim());
            } else if (source != OverviewPage.this.topDescriptorField) {
                if (source == OverviewPage.this.nameText) {
                    OverviewPage.this.aeDeploymentDescription.setName(OverviewPage.this.nameText.getText().trim());
                } else if (source == OverviewPage.this.description) {
                    OverviewPage.this.aeDeploymentDescription.setDescription(OverviewPage.this.description.getText().trim());
                } else if (source == OverviewPage.this.version) {
                    OverviewPage.this.aeDeploymentDescription.setVersion(OverviewPage.this.version.getText().trim());
                } else if (source == OverviewPage.this.vendor) {
                    OverviewPage.this.aeDeploymentDescription.setVendor(OverviewPage.this.vendor.getText().trim());
                }
            }
            OverviewPage.this.isValid();
            if (!OverviewPage.this.ignoreUpdate) {
                OverviewPage.this.multiPageEditor.setFileDirty();
            }
        }
    };
    protected SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (event.getSource() == OverviewPage.this.casPoolSize) {
                OverviewPage.this.aeDeploymentDescription.setCasPoolSize(OverviewPage.this.casPoolSize.getSelection());
            } else if (event.getSource() == OverviewPage.this.initialFsHeapSize) {
                OverviewPage.this.aeDeploymentDescription.setInitialFsHeapSize(OverviewPage.this.initialFsHeapSize.getSelection());
            } else if (event.getSource() == OverviewPage.this.prefetch) {
                OverviewPage.this.aeService.setPrefetch(OverviewPage.this.prefetch.getSelection());
            } else if (event.getSource() == OverviewPage.this.customButton) {
                if (OverviewPage.this.customComposite == null) {
                    OverviewPage.this.aeService.setCustomValue("run_top_level_CPP_service_as_separate_process");
                    OverviewPage.this.customComposite = OverviewPage.this.createCustomizationSection(OverviewPage.this.serviceSectionClient);
                    OverviewPage.this.updateEnvironmentVariables();
                } else {
                    OverviewPage.this.aeService.setCustomValue(null);
                    if (OverviewPage.this.aeService.getEnvironmentVariables() != null) {
                        OverviewPage.this.aeService.getEnvironmentVariables().clear();
                    }
                    OverviewPage.this.customComposite.dispose();
                    OverviewPage.this.customComposite = null;
                }
                OverviewPage.this.serviceSectionClient.layout(true, true);
                OverviewPage.this.mForm.reflow(true);
            }
            OverviewPage.this.multiPageEditor.setFileDirty();
        }
    };

    public void enableCasPoolSizeSettings(boolean enable) {
        this.casPoolSize.setEnabled(enable);
    }

    public void setCasPoolSize(int number) {
        try {
            if (!this.aeDeploymentDescription.getAeService().getAnalysisEngineDeploymentMetaData().isAsync()) {
                this.casPoolSize.setSelection(number);
                this.aeDeploymentDescription.setCasPoolSize(number);
            }
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
    }

    public OverviewPage(DeploymentDescriptorEditor editor, String id, String title) {
        super((FormEditor)editor.cde, id, title);
        this.multiPageEditor = editor;
        this.aeDeploymentDescription = this.multiPageEditor.getAEDeploymentDescription();
        this.aeService = this.aeDeploymentDescription.getAeService();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.mForm = managedForm;
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.form.setText(Messages.DDE_OverviewPage_Title);
        this.fillBody(managedForm, toolkit);
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        Composite compTop = toolkit.createComposite(body);
        compTop.setLayout((Layout)new GridLayout(1, false));
        compTop.setLayoutData((Object)new GridData(1808));
        Composite c = compTop.getParent();
        while (!(c instanceof ScrolledComposite)) {
            c = c.getParent();
        }
        ((GridData)compTop.getLayoutData()).widthHint = c.getSize().x;
        ((GridData)compTop.getLayoutData()).heightHint = c.getSize().y;
        compTop.setLayoutData((Object)new GridData(1808));
        ScrolledComposite leftScrolled = new ScrolledComposite(compTop, 768);
        leftScrolled.setExpandHorizontal(true);
        leftScrolled.setExpandVertical(true);
        leftScrolled.setLayoutData((Object)new GridData(1808));
        leftScrolled.setLayout((Layout)new GridLayout(1, false));
        Composite servicePane = toolkit.createComposite((Composite)leftScrolled);
        TableWrapLayout layout = new TableWrapLayout();
        servicePane.setLayout((Layout)layout);
        servicePane.setLayoutData((Object)new GridData(1808));
        leftScrolled.setContent((Control)servicePane);
        ScrolledComposite rightScrolled = new ScrolledComposite(compTop, 768);
        rightScrolled.setExpandHorizontal(true);
        rightScrolled.setExpandVertical(true);
        rightScrolled.setLayoutData((Object)new GridData(1808));
        rightScrolled.setLayout((Layout)new GridLayout(1, false));
        Composite rightPane = toolkit.createComposite((Composite)rightScrolled);
        layout = new TableWrapLayout();
        rightPane.setLayout((Layout)layout);
        rightPane.setLayoutData((Object)new GridData(1808));
        rightScrolled.setContent((Control)rightPane);
        this.createIdentitySection(rightPane, toolkit);
        this.createServiceSection(servicePane, toolkit);
        leftScrolled.setMinSize(servicePane.computeSize(-1, -1));
        rightScrolled.setMinSize(rightPane.computeSize(-1, -1));
    }

    private Section createIdentitySection(Composite parent, FormToolkit toolkit) {
        Section section = FormSection.createTableWrapDataSection(toolkit, parent, 4, Messages.DDE_OverviewPage_General_Section_Title, Messages.DDE_OverviewPage_General_Section_Description, 10, 3, 256, 256, 1, 1);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OverviewPage.this.form.reflow(true);
            }
        });
        Composite sectionClient = toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        TableWrapLayout tl = new TableWrapLayout();
        tl.numColumns = 2;
        tl.bottomMargin = 6;
        sectionClient.setLayout((Layout)tl);
        this.nameText = FormSection.createLabelAndText(toolkit, sectionClient, "Name:", this.aeDeploymentDescription.getName(), 64, 10, 0);
        this.description = FormSection.createLabelAndText(toolkit, sectionClient, "Description:", this.aeDeploymentDescription.getDescription(), 578, 10, 60);
        this.version = FormSection.createLabelAndText(toolkit, sectionClient, "Version:", this.aeDeploymentDescription.getVersion(), 64, 10, 0);
        this.vendor = FormSection.createLabelAndText(toolkit, sectionClient, "Vendor:", this.aeDeploymentDescription.getVendor(), 64, 10, 0);
        this.nameText.addModifyListener(this.fModifyListener);
        this.description.addModifyListener(this.fModifyListener);
        this.version.addModifyListener(this.fModifyListener);
        this.vendor.addModifyListener(this.fModifyListener);
        toolkit.paintBordersFor(sectionClient);
        return section;
    }

    private Composite createCustomizationSection(Composite parent) {
        FormToolkit toolkit = this.mForm.getToolkit();
        Composite customComposite = toolkit.createComposite(parent);
        TableWrapLayout tl = new TableWrapLayout();
        tl.numColumns = 1;
        tl.numColumns = 1;
        tl.leftMargin = 0;
        tl.rightMargin = 0;
        tl.topMargin = 0;
        tl.bottomMargin = 0;
        customComposite.setLayout((Layout)tl);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 8;
        gd.grabExcessHorizontalSpace = true;
        customComposite.setLayoutData((Object)gd);
        this.envTable = this.createCustomizationTable(customComposite, toolkit);
        this.envTableViewer = new TableViewer(this.envTable);
        this.envTableViewer.setContentProvider((IContentProvider)new EnvVariableContentProvider());
        this.envTableViewer.setLabelProvider((IBaseLabelProvider)new EnvVariableLabelProvider());
        this.envTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)event.getSelection()).size();
                OverviewPage.this.editButton.setEnabled(size == 1);
                OverviewPage.this.removeButton.setEnabled(size > 0);
            }
        });
        this.envTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!OverviewPage.this.envTableViewer.getSelection().isEmpty()) {
                    OverviewPage.this.handleEditButton();
                }
            }
        });
        this.envTableViewer.setInput(this.envName2NameValueMap);
        toolkit.paintBordersFor(customComposite);
        return customComposite;
    }

    private Table createCustomizationTable(Composite parent, FormToolkit toolkit) {
        Composite tableComposite = toolkit.createComposite(parent, 0);
        TableWrapData td = new TableWrapData(256, 256);
        td.grabHorizontal = true;
        td.valign = 128;
        tableComposite.setLayoutData((Object)td);
        GridLayout glayout = new GridLayout();
        glayout.marginTop = 0;
        glayout.marginLeft = 0;
        glayout.numColumns = 3;
        tableComposite.setLayout((Layout)glayout);
        Table table = toolkit.createTable(tableComposite, 101120);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] headers = new String[]{Messages.DDE_EnvVariable_Table_NAME, Messages.DDE_EnvVariable_Table_VALUE};
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        for (int i = 0; i < headers.length; ++i) {
            tableLayout.addColumnData(this.envTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setText(headers[i]);
        }
        GridData gd = new GridData(1810);
        gd.horizontalSpan = 2;
        gd.heightHint = table.getHeaderHeight() + table.getItemHeight() * 4;
        table.setLayoutData((Object)gd);
        this.createTableButtons(tableComposite, toolkit);
        return table;
    }

    protected void createTableButtons(Composite parent, FormToolkit toolkit) {
        Composite buttonComposite = toolkit.createComposite(parent, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 1;
        GridData gdata = new GridData(130);
        buttonComposite.setLayout((Layout)glayout);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        this.createVerticalSpacer(buttonComposite, 1);
        this.addButton = this.createPushButton(buttonComposite, "Add...", null, toolkit);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OverviewPage.this.handleAddButton();
            }
        });
        this.editButton = this.createPushButton(buttonComposite, "Edit...", null, toolkit);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OverviewPage.this.handleEditButton();
            }
        });
        this.removeButton = this.createPushButton(buttonComposite, "Remove", null, toolkit);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OverviewPage.this.handleDeleteButton();
            }
        });
    }

    public Button createPushButton(Composite parent, String label, Image image, FormToolkit toolkit) {
        Button button = toolkit.createButton(parent, label, 8);
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        button.setEnabled(true);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
        label.setFont(comp.getFont());
    }

    private Section createServiceSection(Composite parent, FormToolkit toolkit) {
        Composite sectionClient;
        Section section = FormSection.createTableWrapDataSection(toolkit, parent, 132, Messages.DDE_OverviewPage_Service_Section_Title, Messages.DDE_OverviewPage_Service_Section_Description, 10, 3, 256, 256, 1, 1);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OverviewPage.this.form.reflow(true);
            }
        });
        this.serviceSectionClient = sectionClient = toolkit.createComposite((Composite)section);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        sectionClient.setLayout((Layout)gl);
        section.setClient((Control)sectionClient);
        Composite topComposite = toolkit.createComposite(sectionClient);
        TableWrapLayout tl = new TableWrapLayout();
        tl.numColumns = 2;
        tl.bottomMargin = 10;
        topComposite.setLayout((Layout)tl);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        topComposite.setLayoutData((Object)gd);
        this.brokerUrlDecoField = FormSection2.createLabelAndDecoratedText(toolkit, topComposite, "Broker URL for input queue:", this.aeService.getBrokerURL(), 2112, 200, 0, true, 0);
        this.decorationBrokerUrl = FormSection2.registerFieldDecoration("brokerUrl", "The broker URL cannot be empty");
        this.brokerUrlDecoField.addFieldDecoration(this.decorationBrokerUrl, 16512, false);
        this.brokerUrl = (Text)this.brokerUrlDecoField.getControl();
        this.brokerUrl.setToolTipText("Enter the URL for the input queue");
        this.brokerUrl.addModifyListener(this.fModifyListener);
        this.endPointDecoField = FormSection2.createLabelAndDecoratedText(toolkit, topComposite, "Name for input queue:", this.aeService.getEndPoint(), 2112, 200, 0, true, 0);
        this.endPoint = (Text)this.endPointDecoField.getControl();
        this.endPoint.setToolTipText("Enter the name for the input queue");
        this.endPoint.addModifyListener(this.fModifyListener);
        this.decorationEndPoint = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.decorationEndPoint.setDescription("The name for the queue cannot be empty");
        this.endPointDecoField.addFieldDecoration(this.decorationEndPoint, 16512, false);
        this.prefetch = FormSection2.createLabelAndSpinner(toolkit, topComposite, "Number of requests that might be prefetched:", 2048, 0, Integer.MAX_VALUE, false, 8);
        this.prefetch.setSelection(this.aeService.getPrefetch());
        this.prefetch.addSelectionListener(this.selectionListener);
        this.casPoolSize = FormSection2.createLabelAndSpinner(toolkit, topComposite, "Number of CASes in CAS pool:", 2048, 1, Integer.MAX_VALUE, false, 8);
        this.casPoolSize.setSelection(this.aeDeploymentDescription.getCasPoolSize());
        this.casPoolSize.addSelectionListener(this.selectionListener);
        try {
            if (!this.aeDeploymentDescription.getAeService().getAnalysisEngineDeploymentMetaData().isAsync()) {
                this.casPoolSize.setEnabled(false);
                int instances = this.aeDeploymentDescription.getAeService().getAnalysisEngineDeploymentMetaData().getNumberOfInstances();
                if (this.casPoolSize.getSelection() != instances && 0 == Utility.popOkCancel((String)"Warning - CAS Pool Size", (String)MessageFormat.format("The CAS pool size (={0}) is not equal to the number of instances (={1}).\n\nSet the CAS pool size to " + instances + "?", this.casPoolSize.getSelection(), instances), (int)4)) {
                    this.setCasPoolSize(instances);
                    this.multiPageEditor.setFileDirty();
                }
            }
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        this.initialFsHeapSize = FormSection2.createLabelAndSpinner(toolkit, topComposite, "Initial size of CAS heap (in bytes):", 2048, 1, Integer.MAX_VALUE, false, 8);
        this.initialFsHeapSize.setSelection(this.aeDeploymentDescription.getInitialFsHeapSize());
        this.initialFsHeapSize.addSelectionListener(this.selectionListener);
        this.topDescriptorDecoField = FormSection2.createLabelAndGridLayoutDecoratedContainer(toolkit, topComposite, "Top analysis engine descriptor", 2, 0, 0);
        Composite browsingGroup = (Composite)this.topDescriptorDecoField.getControl();
        this.decorationTopDescriptor = FormSection2.registerFieldDecoration("topDescriptorField", "Top descriptor cannot be empty");
        this.topDescriptorDecoField.addFieldDecoration(this.decorationTopDescriptor, 16512, false);
        toolkit.paintBordersFor(browsingGroup);
        this.topDescriptorField = toolkit.createText(browsingGroup, "", 8);
        this.topDescriptorField.setLayoutData((Object)new GridData(768));
        String topDescriptor = null;
        Import imp = this.aeService.getImportDescriptor();
        if (imp != null) {
            String descr = imp.getLocation();
            if (descr == null) {
                this.isImportByLocation = false;
                descr = imp.getName();
            } else {
                this.isImportByLocation = true;
            }
            topDescriptor = descr;
        }
        this.topDescriptorField.setText(topDescriptor != null ? topDescriptor : "");
        this.topDescriptorField.addModifyListener(this.fModifyListener);
        Button browseDirectoriesButton = toolkit.createButton(browsingGroup, "B&rowse...", 8);
        browseDirectoriesButton.setLayoutData((Object)new GridData());
        browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiResourceSelectionDialog dialog = new MultiResourceSelectionDialog(OverviewPage.this.form.getShell(), (IAdaptable)OverviewPage.this.multiPageEditor.getFile().getProject().getParent(), "Component Engine Selection", OverviewPage.this.multiPageEditor.getFile().getLocation(), ((OverviewPage)OverviewPage.this).multiPageEditor.cde);
                dialog.setTitle("Component Engine Selection");
                dialog.setMessage("Select one component engine from the workspace:");
                dialog.open();
                Object[] files = dialog.getResult();
                if (files != null && files.length > 0) {
                    for (int i = 0; i < files.length; ++i) {
                        FileAndShortName fsn = new FileAndShortName(files[i]);
                        OverviewPage.this.updateTopDescriptor(fsn.fileName, !dialog.isImportByName);
                    }
                }
            }
        });
        this.topDescriptorField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.topDescriptorField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        });
        this.createContextMenu();
        toolkit.createLabel(topComposite, "", 0);
        Composite nameOrLocation = toolkit.createComposite(topComposite, 0);
        nameOrLocation.setLayout((Layout)new GridLayout(2, false));
        TableWrapData td = new TableWrapData();
        td.colspan = 1;
        td.grabHorizontal = true;
        td.indent = 0;
        nameOrLocation.setLayoutData((Object)td);
        toolkit.paintBordersFor(nameOrLocation);
        this.importByNameOrLocation = FormSection.createLabelAndLabel(toolkit, nameOrLocation, "Import by:", "(Name or Location)", 200, 20);
        if (imp != null) {
            if (this.isImportByLocation) {
                this.importByNameOrLocation.setText("Location");
            } else {
                this.importByNameOrLocation.setText("Name");
            }
        }
        this.customButton = toolkit.createButton(sectionClient, "Run top level C++ component in a separate process", 32);
        gd = new GridData(768);
        gd.horizontalIndent = 8;
        gd.grabExcessHorizontalSpace = true;
        this.customButton.setLayoutData((Object)gd);
        this.customButton.addSelectionListener(this.selectionListener);
        if (imp != null) {
            this.customButton.setEnabled(this.aeService.isCPlusPlusTopAE());
            if (this.aeService.getCustomValue() != null) {
                this.customButton.setSelection(true);
                if (this.aeService.getEnvironmentVariables() != null) {
                    for (NameValue nv : this.aeService.getEnvironmentVariables()) {
                        this.envName2NameValueMap.put(nv.getName(), nv);
                    }
                    this.customComposite = this.createCustomizationSection(this.serviceSectionClient);
                }
            }
        } else {
            this.customButton.setEnabled(false);
        }
        toolkit.paintBordersFor(topComposite);
        return section;
    }

    private void createContextMenu() {
        this.openAction = new Action(Messages.DDE_POPUP_ACTION_OPEN_IN_NEW_WINDOW){

            public void run() {
                OverviewPage.this.multiPageEditor.openTopLevelXmlDescriptor(OverviewPage.this.aeService.getImportDescriptor());
            }
        };
        this.notInWSAction = new Action(Messages.DDE_POPUP_ACTION_NOT_IN_WORKSPACE){

            public void run() {
            }
        };
        this.notInWSAction.setEnabled(false);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                OverviewPage.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.topDescriptorField);
        this.topDescriptorField.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager mgr) {
        String xml = this.topDescriptorField.getText().trim();
        if (xml.length() > 0) {
            String path = this.multiPageEditor.cde.getAbsolutePathFromImport(this.aeService.getImportDescriptor());
            Path iPath = new Path(path);
            IFile[] files = this.multiPageEditor.cde.getProject().getWorkspace().getRoot().findFilesForLocation((IPath)iPath);
            if (null == files || files.length != 1) {
                mgr.add((IAction)this.notInWSAction);
                return;
            }
            mgr.add((IAction)this.openAction);
        }
    }

    protected void updateTopDescriptor(String fileFullPath, boolean byLocation) {
        Import importDescriptor = null;
        try {
            importDescriptor = byLocation ? this.createLocationImport(fileFullPath) : UimaDescriptionUtils.createByNameImport(fileFullPath, this.multiPageEditor.cde.createResourceManager());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            return;
        }
        this.aeService.setImportDescriptor(importDescriptor);
        String relativeFile = UimaDescriptionUtils.getDescriptorFromImport(importDescriptor);
        try {
            this.aeService.getAnalysisEngineDeploymentMetaData().setAsync(false);
            ResourceSpecifier rs = this.aeService.resolveTopAnalysisEngineDescription(this.multiPageEditor.cde.createResourceManager(), false);
            if (rs != null) {
                if (rs instanceof AnalysisEngineDescription) {
                    AnalysisEngineDescription aed = (AnalysisEngineDescription)rs;
                    AEDelegates_Impl delegates = new AEDelegates_Impl(this.aeService.getAnalysisEngineDeploymentMetaData(this.multiPageEditor.cde.createResourceManager()));
                    Map map = aed.getDelegateAnalysisEngineSpecifiers(this.multiPageEditor.cde.createResourceManager());
                    Iterator i$ = map.entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry m;
                        Map.Entry entry = m = i$.next();
                        AEDeploymentMetaData_Impl meta = new AEDeploymentMetaData_Impl();
                        meta.setKey((String)entry.getKey());
                        if (entry.getValue() instanceof ResourceSpecifier) {
                            Object obj = UIMAFramework.getResourceSpecifierFactory().createObject(AsyncAggregateErrorConfiguration.class);
                            ((AsyncAEErrorConfiguration)obj).getGetMetadataErrors().setTimeout(0);
                            meta.setAsyncAEErrorConfiguration((AsyncAEErrorConfiguration)obj);
                        } else {
                            Trace.bug((String)("ResourceSpecifier == null for " + meta.getKey()));
                        }
                        delegates.addDelegate((DeploymentMetaData_Impl)meta);
                    }
                    this.aeService.getAnalysisEngineDeploymentMetaData(this.multiPageEditor.cde.createResourceManager()).setDelegates(delegates);
                }
                this.updateCPlusPlusSettings();
            } else {
                Trace.err((String)("Cannot resolve: " + relativeFile));
            }
        }
        catch (InvalidXMLException e) {
            Utility.popMessage((String)Messages.getString("InvalidXMLException"), (String)this.multiPageEditor.cde.getMessagesToRootCause((Throwable)e), (int)1);
            this.multiPageEditor.switchToBadSource(true);
            return;
        }
        this.topDescriptorField.setText(relativeFile);
        this.isImportByLocation = byLocation;
        if (this.isImportByLocation) {
            this.importByNameOrLocation.setText("Location");
        } else {
            this.importByNameOrLocation.setText("Name");
        }
        this.multiPageEditor.refresh();
        this.multiPageEditor.setFileDirty();
    }

    public Import createLocationImport(String location) throws MalformedURLException {
        String sDescriptorRelativePath = this.multiPageEditor.cde.getDescriptorRelativePath(location);
        if (sDescriptorRelativePath.indexOf("file:/") == -1 && sDescriptorRelativePath.indexOf(":/") > -1) {
            sDescriptorRelativePath = "file:/" + sDescriptorRelativePath;
        }
        Import_impl imp = new Import_impl();
        URL url = new File(this.multiPageEditor.cde.getDescriptorDirectory()).toURL();
        imp.setSourceUrl(url);
        imp.setLocation(sDescriptorRelativePath);
        return imp;
    }

    public void setActive(boolean active) {
        if (active) {
            super.setActive(active);
            this.isValid();
        }
    }

    protected void isValid() {
        if (this.brokerUrl.getText().trim().length() == 0) {
            this.showStatus("The queue Broker Url is not specified", 3);
            this.brokerUrlDecoField.showDecoration(this.decorationBrokerUrl);
        } else {
            this.brokerUrlDecoField.hideDecoration(this.decorationBrokerUrl);
        }
        if (this.endPoint.getText().trim().length() == 0) {
            this.showStatus("The queue name is not specified", 3);
            this.endPointDecoField.showDecoration(this.decorationEndPoint);
        } else {
            this.endPointDecoField.hideDecoration(this.decorationEndPoint);
        }
        if (this.topDescriptorField.getText().trim().length() == 0) {
            this.showStatus("The top-level analysis engine is not specified", 3);
            this.topDescriptorDecoField.showDecoration(this.decorationTopDescriptor);
        } else {
            this.topDescriptorDecoField.hideDecoration(this.decorationTopDescriptor);
        }
    }

    protected void showStatus(String msg, int msgType) {
    }

    public static int validateFilePath(String filePath) {
        String path;
        String string = path = filePath == null ? "" : filePath.trim();
        if (path.length() > 0) {
            File f = new File(path);
            if (f.exists() && f.isFile()) {
                return 0;
            }
            return 2;
        }
        if (path.length() == 0) {
            return 1;
        }
        return 0;
    }

    public void setInput(AEDeploymentDescription aeDD) {
        this.ignoreUpdate = true;
        this.aeDeploymentDescription = aeDD;
        this.aeService = this.aeDeploymentDescription.getAeService();
        this.nameText.setText(this.aeDeploymentDescription.getName());
        this.description.setText(this.aeDeploymentDescription.getDescription());
        this.version.setText(this.aeDeploymentDescription.getVersion());
        this.vendor.setText(this.aeDeploymentDescription.getVendor());
        this.brokerUrl.setText(this.aeService.getBrokerURL());
        this.endPoint.setText(this.aeService.getEndPoint());
        this.prefetch.setSelection(this.aeService.getPrefetch());
        this.casPoolSize.setSelection(this.aeDeploymentDescription.getCasPoolSize());
        this.initialFsHeapSize.setSelection(this.aeDeploymentDescription.getInitialFsHeapSize());
        String topDescriptor = null;
        Import imp = this.aeService.getImportDescriptor();
        if (imp != null) {
            this.isImportByLocation = true;
            String descr = imp.getLocation();
            if (descr == null) {
                this.isImportByLocation = false;
                descr = imp.getName();
            }
            topDescriptor = descr;
            if (this.isImportByLocation) {
                this.importByNameOrLocation.setText("Location");
            } else {
                this.importByNameOrLocation.setText("Name");
            }
            this.updateCPlusPlusSettings();
        } else {
            this.importByNameOrLocation.setText("(Name or Location)");
        }
        this.topDescriptorField.setText(topDescriptor != null ? topDescriptor : "");
        this.ignoreUpdate = false;
    }

    private void handleEditButton() {
        IStructuredSelection sel = (IStructuredSelection)this.envTableViewer.getSelection();
        NameValue var = (NameValue)sel.getFirstElement();
        if (var == null) {
            return;
        }
        String oldName = var.getName();
        EditParamWizard wizard = new EditParamWizard(Messages.DDE_EnvVariable_Wizard_EDIT_Title, Messages.DDE_EnvVariable_Wizard_EDIT_Description, var.getName(), var.getValue());
        WizardDialog dialog = new WizardDialog(this.form.getShell(), (IWizard)wizard);
        if (dialog.open() != 0) {
            return;
        }
        String name = wizard.getName();
        String value = wizard.getValue();
        this.envName2NameValueMap.remove(oldName);
        if (name.length() == 0) {
            this.envTableViewer.remove((Object)var);
            this.envTableViewer.refresh();
            this.updateEnvironmentVariables();
            return;
        }
        if (!oldName.equals(name)) {
            this.envTableViewer.remove((Object)var);
            var = new NameValue(name, value);
            this.addAndCheckVariable(var);
        } else {
            var.setValue(value);
            this.envTableViewer.update((Object)var, null);
        }
        this.envName2NameValueMap.put(name, var);
        this.updateEnvironmentVariables();
    }

    private void handleAddButton() {
        EditParamWizard wizard = new EditParamWizard(Messages.DDE_EnvVariable_Wizard_ADD_Title, Messages.DDE_EnvVariable_Wizard_ADD_Description, "", "");
        WizardDialog dialog = new WizardDialog(this.form.getShell(), (IWizard)wizard);
        if (dialog.open() != 0) {
            return;
        }
        String name = wizard.getName();
        String value = wizard.getValue();
        if (name.length() == 0) {
            return;
        }
        NameValue nv = new NameValue(name, value);
        this.addAndCheckVariable(nv);
        this.envName2NameValueMap.put(name, nv);
        this.updateEnvironmentVariables();
    }

    private void handleDeleteButton() {
        IStructuredSelection sel = (IStructuredSelection)this.envTableViewer.getSelection();
        NameValue var = (NameValue)sel.getFirstElement();
        if (var == null) {
            return;
        }
        this.envName2NameValueMap.remove(var.getName());
        this.envTableViewer.remove((Object)var);
        this.envTableViewer.refresh();
        this.updateEnvironmentVariables();
    }

    protected boolean addAndCheckVariable(NameValue variable) {
        String name = variable.getName();
        TableItem[] items = this.envTableViewer.getTable().getItems();
        for (int i = 0; i < items.length; ++i) {
            NameValue existingVariable = (NameValue)items[i].getData();
            if (!existingVariable.getName().equals(name)) continue;
            this.envTableViewer.remove((Object)existingVariable);
            break;
        }
        this.envTableViewer.add((Object)variable);
        return true;
    }

    protected void updateEnvironmentVariables() {
        this.aeService.getEnvironmentVariables().clear();
        for (NameValue nv : this.envName2NameValueMap.values()) {
            this.aeService.getEnvironmentVariables().add(nv);
        }
    }

    protected void updateCPlusPlusSettings() {
        if (this.aeService.isCPlusPlusTopAE()) {
            this.customButton.setEnabled(true);
            if (this.aeService.getCustomValue() != null) {
                this.customButton.setSelection(true);
                this.envName2NameValueMap.clear();
                if (this.aeService.getEnvironmentVariables() != null) {
                    for (NameValue nv : this.aeService.getEnvironmentVariables()) {
                        this.envName2NameValueMap.put(nv.getName(), nv);
                    }
                }
                if (this.customComposite == null) {
                    this.customComposite = this.createCustomizationSection(this.serviceSectionClient);
                } else {
                    this.envTableViewer.setInput(this.envName2NameValueMap);
                }
                this.serviceSectionClient.layout(true, true);
                this.mForm.reflow(true);
            } else {
                this.customButton.setSelection(false);
                if (this.aeService.getEnvironmentVariables() != null) {
                    this.aeService.getEnvironmentVariables().clear();
                }
                if (this.customComposite != null) {
                    this.customComposite.dispose();
                    this.customComposite = null;
                }
            }
        } else {
            this.customButton.setSelection(false);
            this.customButton.setEnabled(false);
            this.aeService.setCustomValue(null);
            if (this.aeService.getEnvironmentVariables() != null) {
                this.aeService.getEnvironmentVariables().clear();
            }
            if (this.customComposite != null) {
                this.customComposite.dispose();
                this.customComposite = null;
            }
        }
    }

    public class EnvVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                NameValue var = (NameValue)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getName();
                        break;
                    }
                    case 1: {
                        result = var.getValue();
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    protected class EnvVariableContentProvider
    implements IStructuredContentProvider {
        protected EnvVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Map m = (Map)inputElement;
            if (!m.isEmpty()) {
                return m.values().toArray();
            }
            return EMPTY_ARRAY;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null || !(newInput instanceof Map)) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                tableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer iviewer, Object e1, Object e2) {
                        if (e1 == null) {
                            return -1;
                        }
                        if (e2 == null) {
                            return 1;
                        }
                        return ((NameValue)e1).getName().compareToIgnoreCase(((NameValue)e2).getName());
                    }
                });
            }
        }
    }
}

