/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test.junit_extension;

import java.io.File;
import java.io.FileWriter;
import java.util.GregorianCalendar;
import org.apache.uima.internal.util.TimeSpan;
import org.apache.uima.test.junit_extension.PerformanceTestResult;

@Deprecated
public class PerformanceTestResultImpl
implements PerformanceTestResult {
    private static String NEWLINE = System.getProperty("line.separator");
    private boolean repeatSingleMode = false;
    private boolean doWarmup = false;
    private int numsToRun = 1;
    private File aeDescFile = null;
    private File testFileDir = null;
    private int numberOfFiles = 0;
    private long collectionFileSize = 0L;
    private int numberOfCharacters = 0;
    private String datapath = null;
    private int numberOfCreatedAnnotations = 0;
    private TimeSpan initTime = null;
    private TimeSpan warmupTime = null;
    private TimeSpan overallTime = null;
    private TimeSpan ioTime = null;
    private TimeSpan processingTime = null;
    private TimeSpan cleanupTime = null;
    private TimeSpan documentPreparationTime = null;

    @Override
    public int getNumberOfProcessedCharacters() {
        return this.numberOfCharacters * this.numsToRun;
    }

    public void setNumberOfCharacters(int numberOfCharacters) {
        this.numberOfCharacters = numberOfCharacters;
    }

    @Override
    public int getNumberOfProcessedFiles() {
        return this.numberOfFiles * this.numsToRun;
    }

    public void setNumberOfFiles(int numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
    }

    @Override
    public String getUIMADatapath() {
        return this.datapath;
    }

    public void setDatapath(String datapath) {
        this.datapath = datapath;
    }

    @Override
    public TimeSpan getAeInitTime() {
        return this.initTime;
    }

    public void setInitTime(TimeSpan initTime) {
        this.initTime = initTime;
    }

    @Override
    public TimeSpan getFileIoTime() {
        return this.ioTime;
    }

    public void setIoTime(TimeSpan ioTime) {
        this.ioTime = ioTime;
    }

    @Override
    public int getNumberOfCreatedAnnotations() {
        return this.numberOfCreatedAnnotations;
    }

    public void setNumberOfCreatedAnnotations(int numberOfCreatedAnnotations) {
        this.numberOfCreatedAnnotations = numberOfCreatedAnnotations;
    }

    @Override
    public int getNumberOfRepeatedRuns() {
        return this.numsToRun;
    }

    public void setNumsToRun(int numsToRun) {
        this.numsToRun = numsToRun;
    }

    @Override
    public TimeSpan getOverallTime() {
        return this.overallTime;
    }

    public void setOverallTime(TimeSpan overallTime) {
        this.overallTime = overallTime;
    }

    @Override
    public TimeSpan getAeProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(TimeSpan processingTime) {
        this.processingTime = processingTime;
    }

    @Override
    public boolean isRepeatSingleMode() {
        return this.repeatSingleMode;
    }

    public void setRepeatSingleMode(boolean repeatSingleMode) {
        this.repeatSingleMode = repeatSingleMode;
    }

    @Override
    public String getAeDescFilePath() {
        return this.aeDescFile.getAbsolutePath();
    }

    public void setAeDescFilePath(File aeDescFile) {
        this.aeDescFile = aeDescFile;
    }

    @Override
    public String getTestFileDirectoryPath() {
        return this.testFileDir.getAbsolutePath();
    }

    public void setTestFileDir(File testFileDir) {
        this.testFileDir = testFileDir;
    }

    @Override
    public TimeSpan getAeWarmupTime() {
        return this.warmupTime;
    }

    public void setWarmupTime(TimeSpan warmupTime) {
        this.warmupTime = warmupTime;
    }

    @Override
    public boolean isDoAeWarmup() {
        return this.doWarmup;
    }

    public void setDoWarmup(boolean doWarmup) {
        this.doWarmup = doWarmup;
    }

    public String toString() {
        StringBuffer resultString = new StringBuffer();
        resultString.append(NEWLINE + "Performance Test run results " + NEWLINE);
        resultString.append("-----------------------------" + NEWLINE + NEWLINE);
        resultString.append("ConfigParameters: " + NEWLINE);
        resultString.append("repeat-single mode is: " + this.repeatSingleMode + NEWLINE);
        resultString.append("doWarump is: " + this.doWarmup + NEWLINE);
        resultString.append("Run test " + this.numsToRun + " times" + NEWLINE);
        resultString.append("Use " + this.aeDescFile.getAbsolutePath() + " descriptor" + NEWLINE);
        resultString.append("Fileset " + String.valueOf(this.testFileDir) + " is used" + NEWLINE);
        resultString.append("Datapath setting is: " + this.datapath + NEWLINE);
        resultString.append("Number of documents (overall): " + this.getNumberOfProcessedFiles() + NEWLINE);
        resultString.append("Number of characters (overall): " + this.getNumberOfProcessedCharacters() + NEWLINE);
        resultString.append("Total document size (overall): " + (float)(this.getProcessedFileSize() / 1024L) + " KB" + NEWLINE);
        resultString.append(NEWLINE + "Initialize: " + NEWLINE);
        resultString.append("AE initialize time: " + String.valueOf(this.initTime) + NEWLINE);
        if (this.doWarmup) {
            resultString.append("AE warmup time: " + String.valueOf(this.warmupTime) + NEWLINE);
        }
        resultString.append("IO time for reading files: " + String.valueOf(this.ioTime) + NEWLINE);
        resultString.append(NEWLINE + "Processing: " + NEWLINE);
        resultString.append("Created annotations: " + this.numberOfCreatedAnnotations + NEWLINE);
        resultString.append("Document preparation time: " + String.valueOf(this.documentPreparationTime) + NEWLINE);
        resultString.append("Analysis Engine processing time: " + String.valueOf(this.processingTime) + NEWLINE);
        if (this.processingTime.getFullMilliseconds() > 0L && this.getProcessedFileSize() > 0L) {
            resultString.append("Processing throughput: " + (long)((float)(this.getProcessedFileSize() / 1024L) / ((float)this.processingTime.getFullMilliseconds() / 1000.0f)) + " KB/s" + NEWLINE);
            long mbPerSecond = (long)((float)(this.getProcessedFileSize() / 1024L / 1024L) / ((float)this.processingTime.getFullMilliseconds() / 1000.0f / 60.0f / 60.0f));
            resultString.append("Processing throughput: " + mbPerSecond + " MB/h" + NEWLINE);
        }
        resultString.append(NEWLINE + "Cleanup: " + NEWLINE);
        resultString.append("Cleanup time: " + String.valueOf(this.cleanupTime) + NEWLINE);
        resultString.append(NEWLINE + "Overall: " + NEWLINE);
        resultString.append("Overall time: " + String.valueOf(this.overallTime) + NEWLINE);
        return resultString.toString();
    }

    @Override
    public void writePerfResultsAsColumn(String level, File file) throws Exception {
        if (level == null) {
            level = "none";
        }
        GregorianCalendar cal = new GregorianCalendar();
        StringBuffer timestamp = new StringBuffer();
        timestamp.append(cal.get(5));
        timestamp.append(".");
        timestamp.append(cal.get(2) + 1);
        timestamp.append(".");
        timestamp.append(cal.get(1));
        timestamp.append(" ");
        timestamp.append(cal.get(11));
        timestamp.append(":");
        timestamp.append(cal.get(12));
        timestamp.append(":");
        timestamp.append(cal.get(13));
        StringBuffer resultLine = new StringBuffer();
        resultLine.append(timestamp.toString());
        resultLine.append(" ; ");
        resultLine.append(level);
        resultLine.append(" ; ");
        resultLine.append(this.repeatSingleMode);
        resultLine.append(" ; ");
        resultLine.append(this.doWarmup);
        resultLine.append(" ; ");
        resultLine.append(this.numberOfFiles * this.numsToRun);
        resultLine.append(" ; ");
        resultLine.append(this.numberOfCreatedAnnotations);
        resultLine.append(" ; ");
        resultLine.append(this.processingTime);
        resultLine.append(" ; ");
        resultLine.append(this.initTime);
        resultLine.append(" ; ");
        resultLine.append(this.ioTime);
        resultLine.append(System.getProperty("line.separator"));
        boolean writeHeader = false;
        if (!file.exists()) {
            writeHeader = true;
        }
        FileWriter fileWriter = new FileWriter(file, true);
        if (writeHeader) {
            fileWriter.write("Timestamp ; Levelname ; singleMode ; warmup; Docs ; Annotations ; Processing time ; init time ; io time");
            fileWriter.write(System.getProperty("line.separator"));
        }
        fileWriter.write(resultLine.toString());
        fileWriter.flush();
        fileWriter.close();
    }

    @Override
    public TimeSpan getAeCleanupTime() {
        return this.cleanupTime;
    }

    public void setCleanupTime(TimeSpan cleanupTime) {
        this.cleanupTime = cleanupTime;
    }

    @Override
    public TimeSpan getDocumentPreparationTime() {
        return this.documentPreparationTime;
    }

    public void setDocumentPreparationTime(TimeSpan documentPreparationTime) {
        this.documentPreparationTime = documentPreparationTime;
    }

    @Override
    public long getProcessedFileSize() {
        return this.collectionFileSize * (long)this.numsToRun;
    }

    public void setTotalFileSize(long collectionFileSize) {
        this.collectionFileSize = collectionFileSize;
    }
}

