/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.jasper.servlet.JspServlet;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.DuccPlugins;
import org.apache.uima.ducc.ws.server.DuccHandler;
import org.apache.uima.ducc.ws.server.DuccHandlerClassic;
import org.apache.uima.ducc.ws.server.DuccHandlerHttpRequestFilter;
import org.apache.uima.ducc.ws.server.DuccHandlerJsonFormat;
import org.apache.uima.ducc.ws.server.DuccHandlerProxy;
import org.apache.uima.ducc.ws.server.DuccHandlerUserAuthentication;
import org.apache.uima.ducc.ws.server.DuccHandlerViz;
import org.apache.uima.ducc.ws.server.DuccWebMonitor;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.server.DuccWebServerHelper;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

public class DuccWebServer {
    private static DuccLogger logger = DuccLogger.getLogger(DuccWebServer.class);
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    private String rootDir = "?";
    private Server server;
    private CommonConfiguration commonConfiguration;

    public DuccWebServer(CommonConfiguration commonConfiguration) {
        this.commonConfiguration = commonConfiguration;
        this.init();
    }

    public String getClusterName() {
        return this.commonConfiguration.clusterName;
    }

    public String getClassDefinitionFile() {
        return this.commonConfiguration.classDefinitionFile;
    }

    public int getPortSsl() {
        String property = DuccPropertiesResolver.get((String)"ducc.ws.port.ssl");
        int portHttps = ConfigValue.PortHttps.getInt(property);
        return portHttps;
    }

    public String getWelcomePage() {
        String property = DuccPropertiesResolver.get((String)"ducc.ws.welcome.page");
        String welcomePage = ConfigValue.WelcomePage.getString(property);
        return welcomePage;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public String getKeyStorePassword() {
        return DuccWebServerHelper.getKeyStorePassword();
    }

    public String getKeyManagerPassword() {
        return DuccWebServerHelper.getKeyManagerPassword();
    }

    private void init() {
        String methodName = "init";
        logger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        logger.info(methodName, null, new Object[]{messages.fetchLabel("cluster name") + this.getClusterName()});
        logger.info(methodName, null, new Object[]{messages.fetchLabel("class definition file") + this.getClassDefinitionFile()});
        String property = DuccPropertiesResolver.get((String)"ducc.ws.idle.timeout");
        int idleTimeout = ConfigValue.IdleTimeout.getInt(property);
        property = DuccPropertiesResolver.get((String)"ducc.ws.max.threads");
        int maxThreads = ConfigValue.MaxThreads.getInt(property);
        property = DuccPropertiesResolver.get((String)"ducc.ws.port");
        int portHttp = ConfigValue.PortHttp.getInt(property);
        property = DuccPropertiesResolver.get((String)"ducc.ws.port.ssl");
        int portHttps = ConfigValue.PortHttps.getInt(property);
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String host = inetAddress.getCanonicalHostName();
            DuccWebMonitor.getInstance().register(host, "" + portHttp);
        }
        catch (Exception e) {
            logger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(maxThreads);
        this.server = new Server((ThreadPool)threadPool);
        this.server.addBean((Object)new ScheduledExecutorScheduler());
        ServerConnector http = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory()});
        http.setPort(portHttp);
        http.setIdleTimeout((long)idleTimeout);
        this.server.addConnector((Connector)http);
        SslContextFactory sslContextFactory = new SslContextFactory();
        String keystore = DuccWebServerHelper.getDuccWebKeyStore();
        logger.info(methodName, jobid, new Object[]{"keystore=" + keystore});
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(portHttps);
        logger.info(methodName, jobid, new Object[]{"portHttps=" + portHttps});
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector https = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config)});
        https.setPort(portHttps);
        sslContextFactory.setKeyStorePath(keystore);
        String pw = this.getKeyStorePassword();
        logger.trace(methodName, jobid, new Object[]{"pw=" + pw});
        sslContextFactory.setKeyStorePassword(this.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(this.getKeyManagerPassword());
        this.server.setConnectors(new Connector[]{http});
        this.server.addConnector((Connector)https);
        ServletContextHandler jspHandler = new ServletContextHandler(1);
        jspHandler.setContextPath("/");
        jspHandler.setResourceBase("root");
        jspHandler.setClassLoader(Thread.currentThread().getContextClassLoader());
        jspHandler.addServlet(DefaultServlet.class, "/");
        ServletHolder jsp = jspHandler.addServlet(JspServlet.class, "*.jsp");
        jsp.setInitParameter("classpath", jspHandler.getClassPath());
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        this.rootDir = DuccWebServerHelper.getDuccWebRoot();
        resourceHandler.setResourceBase(this.rootDir);
        try {
            Properties properties = DuccWebProperties.get();
            String ducc_runmode = properties.getProperty("ducc.runmode", "Production");
            logger.debug(methodName, null, new Object[]{"ducc.runmode:" + ducc_runmode});
            logger.debug(methodName, null, new Object[]{"rootdir:" + this.rootDir});
            String $runmode_jsp = this.rootDir + File.separator + "$banner" + File.separator + "$runmode.jsp";
            logger.debug(methodName, null, new Object[]{"$runmode_jsp:" + $runmode_jsp});
            File $runmodeFile = new File($runmode_jsp);
            logger.debug(methodName, null, new Object[]{"path:" + $runmodeFile.getAbsolutePath()});
            $runmodeFile.delete();
            String text = ducc_runmode.equalsIgnoreCase("Test") ? "<html><%@ include file=\"$runmode.test.jsp\" %></html>" : "<html><%@ include file=\"$runmode.production.jsp\" %></html>";
            PrintWriter out = new PrintWriter($runmodeFile);
            out.println(text);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.info(methodName, null, (Throwable)e, new Object[0]);
        }
        HandlerList handlers = new HandlerList();
        String key = "ducc.ws.requestLog.RetainDays";
        int dflt = 0;
        int requestLogRetainDays = DuccPropertiesResolver.get((String)key, (int)dflt);
        logger.info(methodName, jobid, new Object[]{"requestLogRetainDays=" + requestLogRetainDays});
        if (requestLogRetainDays > 0) {
            String requestLogTimeZone = "GMT";
            String requestLogFmt = "yyyy_MM_dd";
            String requestLogFile = IDuccEnv.DUCC_LOGS_WEBSERVER_DIR + requestLogFmt + ".request.log";
            NCSARequestLog requestLog = new NCSARequestLog();
            requestLog.setFilename(requestLogFile);
            requestLog.setFilenameDateFormat(requestLogFmt);
            requestLog.setRetainDays(requestLogRetainDays);
            requestLog.setAppend(true);
            requestLog.setExtended(true);
            requestLog.setLogCookies(false);
            requestLog.setLogTimeZone(requestLogTimeZone);
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            handlers.addHandler((Handler)requestLogHandler);
            logger.info(methodName, jobid, new Object[]{"requestLogFile=" + requestLogFile});
        }
        DuccHandler duccHandler = new DuccHandler(this);
        ArrayList<Handler> localHandlers = DuccPlugins.getInstance().gethandlers(this);
        DuccHandlerClassic duccHandlerClassic = new DuccHandlerClassic(this);
        DuccHandlerJsonFormat duccHandlerJson = new DuccHandlerJsonFormat(this);
        DuccHandlerProxy duccHandlerProxy = new DuccHandlerProxy();
        DuccHandlerViz duccHandlerViz = new DuccHandlerViz();
        DuccHandlerUserAuthentication duccHandlerUserAuthentication = new DuccHandlerUserAuthentication();
        SessionHandler sessionHandler = new SessionHandler();
        handlers.addHandler((Handler)sessionHandler);
        handlers.addHandler((Handler)duccHandlerUserAuthentication);
        String welcomePage = this.getWelcomePage();
        jspHandler.setWelcomeFiles(new String[]{welcomePage});
        resourceHandler.setWelcomeFiles(new String[]{welcomePage});
        DuccHandlerHttpRequestFilter httpRequestFilter = new DuccHandlerHttpRequestFilter(this);
        handlers.addHandler((Handler)httpRequestFilter);
        for (Handler handler : localHandlers) {
            handlers.addHandler(handler);
        }
        handlers.addHandler((Handler)duccHandlerJson);
        handlers.addHandler((Handler)duccHandlerProxy);
        handlers.addHandler((Handler)duccHandlerClassic);
        handlers.addHandler((Handler)duccHandlerViz);
        handlers.addHandler((Handler)duccHandler);
        handlers.addHandler((Handler)jspHandler);
        handlers.addHandler((Handler)resourceHandler);
        handlers.addHandler((Handler)new DefaultHandler());
        this.server.setHandler((Handler)handlers);
        logger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void join() throws Exception {
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public static enum ConfigValue {
        MaxThreads("500"),
        IdleTimeout("30000"),
        PortHttp("42133"),
        PortHttps("42155"),
        WelcomePage("index.html");

        private String defaultValue;

        private ConfigValue(String value) {
            this.defaultValue = value;
        }

        public int getInt(String property) {
            String location = "getInt";
            int retVal = Integer.parseInt(this.defaultValue);
            String desc = "[default]";
            if (property != null && (property = property.trim()).length() > 0) {
                retVal = Integer.parseInt(property);
                desc = "";
            }
            String text = this.name() + "=" + retVal + " " + desc;
            logger.debug(location, jobid, new Object[]{text.trim()});
            return retVal;
        }

        public String getString(String property) {
            String location = "getString";
            String retVal = this.defaultValue;
            String desc = "[default]";
            if (property != null && (property = property.trim()).length() > 0) {
                retVal = property;
                desc = "";
            }
            String text = this.name() + "=" + retVal + " " + desc;
            logger.debug(location, jobid, new Object[]{text.trim()});
            return retVal;
        }
    }
}

