/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.helper;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public abstract class JmxHelper {
    private static DuccLogger logger = DuccLogger.getLogger(JmxHelper.class);
    private static DuccId jobid = null;
    private String jmxHost = "localhost";
    private int jmxPort = -1;
    private JMXServiceURL url;
    private JMXConnector jmxc;
    private MBeanServerConnection mbsc;

    protected void setJmxHost(String value) {
        this.jmxHost = value;
    }

    public String getJmxHost() {
        return this.jmxHost;
    }

    protected void setJmxPort(int value) {
        this.jmxPort = value;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public String getJmxUrl() {
        return "service:jmx:rmi:///jndi/rmi://" + this.getJmxHost() + ":" + this.getJmxPort() + "/jmxrmi";
    }

    public MBeanServerConnection getMBSC() {
        return this.mbsc;
    }

    protected void jmxConnect() throws IOException {
        this.url = new JMXServiceURL(this.getJmxUrl());
        this.jmxc = JMXConnectorFactory.connect(this.url, null);
        this.mbsc = this.jmxc.getMBeanServerConnection();
    }

    protected String getJmxData() throws Exception {
        Object o = null;
        MBeanServerConnection mbsc = null;
        try {
            mbsc = this.getMBSC();
            o = mbsc.getAttribute(new ObjectName("java.lang:type=Runtime"), "Name");
        }
        catch (Exception e) {
            this.reconnect();
            mbsc = this.getMBSC();
            o = mbsc.getAttribute(new ObjectName("java.lang:type=Runtime"), "Name");
        }
        String data = (String)o;
        return data;
    }

    public Long getPID() {
        String location = "getPID";
        Long retVal = new Long(0L);
        try {
            Long pid;
            String data = this.getJmxData();
            String[] address = data.split("@");
            retVal = pid = Long.valueOf(Long.parseLong(address[0]));
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    protected abstract void reconnect();
}

