/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.helper;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.DuccDaemonsData;
import org.apache.uima.ducc.ws.helper.JmxHelper;

public class BrokerHelper
extends JmxHelper {
    private static DuccLogger logger = DuccLogger.getLogger(BrokerHelper.class);
    private static DuccId jobid = null;
    private JMXServiceURL jmxServiceUrl = null;
    private JMXConnector jmxc;
    private MBeanServerConnection mbsc;
    private OperatingSystemMXBean remoteOperatingSystem;
    private ThreadMXBean remoteThread;
    private int threadsLive = 0;
    private int threadsPeak = 0;
    private double systemLoadAverage = 0.0;
    private long memoryUsed = 0L;
    private long memoryMax = 0L;
    private String brokerVersion = "?";
    private String brokerUptime = "?";
    private long startTime = 0L;
    private Map<String, Map<String, String>> entityAttributes = null;
    private String[] topicAttributeNames = new String[]{FrameworkAttribute.ConsumerCount.name(), FrameworkAttribute.QueueSize.name(), FrameworkAttribute.MaxEnqueueTime.name(), FrameworkAttribute.AverageEnqueueTime.name(), FrameworkAttribute.MemoryPercentUsage.name()};
    private String[] brokerAttributeNames = new String[]{BrokerAttribute.BrokerVersion.name(), BrokerAttribute.Uptime.name()};

    public static BrokerHelper getInstance() {
        return new BrokerHelper();
    }

    private BrokerHelper() {
        this.initProperties();
        this.init();
    }

    private BrokerHelper(String host, String port) {
        this.setHost(host);
        this.setPort(port);
        this.init();
    }

    private void initProperties() {
        DuccPropertiesResolver duccPropertiesResolver = DuccPropertiesResolver.getInstance();
        String key = "ducc.broker.hostname";
        String value = duccPropertiesResolver.getCachedProperty(key);
        this.setHost(value);
        key = "ducc.broker.jmx.port";
        value = duccPropertiesResolver.getCachedProperty(key);
        this.setPort(value);
    }

    private void init() {
        String location = "init";
        try {
            this.connect();
            this.populate();
            this.disconnect();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void populateRemoteOperatingSystem() {
        String location = "populateRemoteOperatingSystem";
        try {
            this.remoteOperatingSystem = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void populateRemoteThread() {
        String location = "populateRemoteThread";
        try {
            this.remoteThread = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Threading", ThreadMXBean.class);
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void populateOperatingSystem() {
        String location = "populateOperatingSystem";
        try {
            this.systemLoadAverage = this.remoteOperatingSystem.getSystemLoadAverage();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void populateThreads() {
        String location = "populateThreads";
        try {
            this.threadsLive = this.remoteThread.getThreadCount();
            this.threadsPeak = this.remoteThread.getPeakThreadCount();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void populateMemory() {
        String location = "populateMemory";
        try {
            Object o = this.mbsc.getAttribute(new ObjectName("java.lang:type=Memory"), "HeapMemoryUsage");
            CompositeData cd = (CompositeData)o;
            this.memoryUsed = (Long)cd.get("used");
            this.memoryMax = (Long)cd.get("max");
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void populateRuntime() {
        String location = "populateRuntime";
        try {
            Object o = this.mbsc.getAttribute(new ObjectName("java.lang:type=Runtime"), "StartTime");
            this.startTime = (Long)o;
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void populateAttributes() {
        String location = "populateAttributes";
        try {
            this.entityAttributes = this.search();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void populate() {
        this.populateRemoteOperatingSystem();
        this.populateRemoteThread();
        this.populateOperatingSystem();
        this.populateThreads();
        this.populateMemory();
        this.populateRuntime();
        this.populateAttributes();
    }

    private boolean match(String s0, String s1) {
        boolean retVal = false;
        if (s0 != null && s1 != null) {
            retVal = s0.equals(s1);
        }
        return retVal;
    }

    private boolean start(String s0, String s1) {
        boolean retVal = false;
        if (s0 != null && s1 != null) {
            retVal = s0.startsWith(s1);
        }
        return retVal;
    }

    private boolean isQueue(Hashtable<String, String> plist) {
        boolean retVal = false;
        if (plist != null) {
            String text = plist.get("type");
            if (text == null) {
                text = plist.get("Type");
            }
            retVal = this.match("Queue", text);
        }
        return retVal;
    }

    private boolean isTopic(Hashtable<String, String> plist) {
        boolean retVal = false;
        if (plist != null) {
            String text = plist.get("type");
            if (text == null) {
                text = plist.get("Type");
            }
            retVal = this.match("Topic", text);
        }
        return retVal;
    }

    private boolean isEligible(Hashtable<String, String> plist) {
        boolean retVal = this.isTopic(plist) || this.isQueue(plist);
        return retVal;
    }

    private void conditionalAdd(Map<String, Map<String, String>> map, ObjectName objectName) throws InstanceNotFoundException, ReflectionException, IOException {
        String key = this.getBrokerVersion();
        if (key != null) {
            if (key.equals("5.7.0")) {
                this.conditionalAdd5_7_0(map, objectName);
            } else {
                this.conditionalAdd5_13_2(map, objectName);
            }
        } else {
            this.conditionalAdd5_13_2(map, objectName);
        }
    }

    private void conditionalAdd5_13_2(Map<String, Map<String, String>> map, ObjectName objectName) throws InstanceNotFoundException, ReflectionException, IOException {
        String location = "conditionalAdd5_13_2";
        if (map != null && objectName != null) {
            String dName = null;
            String dType = objectName.getKeyProperty("destinationType");
            if (dType != null && (dType.equals("Topic") || dType.equals("Queue")) && (dName = objectName.getKeyProperty("destinationName")) != null) {
                if (dName.startsWith("ducc.")) {
                    logger.trace(location, jobid, new Object[]{dType + ": " + dName});
                    TreeMap<String, String> attributes = new TreeMap<String, String>();
                    AttributeList attributeList = this.mbsc.getAttributes(objectName, this.topicAttributeNames);
                    for (Object object : attributeList) {
                        Attribute attribute = (Attribute)object;
                        String attrName = attribute.getName();
                        String attrValue = "" + attribute.getValue();
                        attributes.put(attrName, attrValue);
                        logger.trace(location, jobid, new Object[]{attrName + "=" + attrValue});
                    }
                    String key = JmxKeyWord.Type.name();
                    String value = dType;
                    attributes.put(key, value);
                    map.put(dName, attributes);
                } else {
                    logger.trace(location, jobid, new Object[]{dType + ": " + dName + " skip"});
                }
            }
        }
    }

    @Deprecated
    private void conditionalAdd5_7_0(Map<String, Map<String, String>> map, ObjectName objectName) throws InstanceNotFoundException, ReflectionException, IOException {
        String location = "conditionalAdd5_7_0";
        if (map != null && objectName != null) {
            Hashtable<String, String> plist = objectName.getKeyPropertyList();
            if (this.isEligible(plist)) {
                String prefix;
                String name = plist.get(JmxKeyWord.Destination.name());
                if (this.start(name, prefix = "ducc.")) {
                    TreeMap<String, String> attributes = new TreeMap<String, String>();
                    AttributeList attributeList = this.mbsc.getAttributes(objectName, this.topicAttributeNames);
                    for (Object object : attributeList) {
                        Attribute attribute = (Attribute)object;
                        String attrName = attribute.getName();
                        String attrValue = "" + attribute.getValue();
                        attributes.put(attrName, attrValue);
                        logger.trace(location, jobid, new Object[]{attrName + "=" + attrValue});
                    }
                    String key = JmxKeyWord.Type.name();
                    String value = plist.get(key);
                    attributes.put(key, value);
                    map.put(name, attributes);
                }
            } else {
                logger.trace(location, jobid, new Object[]{"skip: " + objectName});
            }
        }
    }

    private Map<String, Map<String, String>> search() throws IOException, InstanceNotFoundException, ReflectionException {
        TreeMap<String, Map<String, String>> map = new TreeMap<String, Map<String, String>>();
        TreeSet<ObjectName> objectNames = new TreeSet<ObjectName>(this.mbsc.queryNames(null, null));
        for (ObjectName objectName : objectNames) {
            this.brokerAdd(objectName);
        }
        for (ObjectName objectName : objectNames) {
            this.conditionalAdd(map, objectName);
        }
        return map;
    }

    private void brokerAdd(ObjectName objectName) throws InstanceNotFoundException, ReflectionException, IOException {
        Hashtable<String, String> plist;
        if (objectName != null && (plist = objectName.getKeyPropertyList()) != null) {
            String s1;
            String s0 = plist.get("type");
            if (s0 == null) {
                s0 = plist.get("Type");
            }
            if (this.match(s0, s1 = "Broker")) {
                AttributeList attributeList = this.mbsc.getAttributes(objectName, this.brokerAttributeNames);
                for (Object object : attributeList) {
                    Attribute attribute = (Attribute)object;
                    String attrName = attribute.getName();
                    String attrValue = "" + attribute.getValue();
                    if (attrName.equals(BrokerAttribute.BrokerVersion.name())) {
                        this.brokerVersion = attrValue;
                        continue;
                    }
                    if (!attrName.equals(BrokerAttribute.Uptime.name())) continue;
                    this.brokerUptime = attrValue;
                }
            }
        }
    }

    private void setHost(String value) {
        this.setJmxHost(value);
    }

    public String getHost() {
        return this.getJmxHost();
    }

    private void setPort(String value) {
        String location = "setPort";
        try {
            this.setJmxPort(Integer.parseInt(value));
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public int getPort() {
        return this.getJmxPort();
    }

    private void connect() throws IOException {
        this.jmxServiceUrl = new JMXServiceURL(this.getJmxUrl());
        this.jmxc = JMXConnectorFactory.connect(this.jmxServiceUrl, null);
        this.mbsc = this.jmxc.getMBeanServerConnection();
    }

    private void disconnect() {
        String location = "disconnect";
        try {
            this.jmxc.close();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public double getSystemLoadAverage() {
        return this.systemLoadAverage;
    }

    public int getThreadsLive() {
        return this.threadsLive;
    }

    public int getThreadsPeak() {
        return this.threadsPeak;
    }

    public Long getMemoryUsed() {
        return this.memoryUsed;
    }

    public Long getMemoryMax() {
        return this.memoryMax;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public String getBrokerUptime() {
        return this.brokerUptime;
    }

    public Map<String, Map<String, String>> getEntityAttributes() {
        return this.entityAttributes;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isAlive() {
        boolean retVal = DuccDaemonsData.getInstance().isWsPublicationOntime();
        return retVal;
    }

    @Override
    protected void reconnect() {
        String location = "reconnect";
        try {
            this.jmxConnect();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static String parse(String[] args, String key) {
        String retVal = null;
        if (args != null) {
            for (String arg : args) {
                String[] pair = arg.trim().split("=");
                if (pair.length != 2 || !pair[0].equals(key)) continue;
                retVal = pair[1];
            }
        }
        return retVal;
    }

    public static void main(String[] args) {
        String host = BrokerHelper.parse(args, "host");
        if (host == null) {
            System.out.println("host=?");
            return;
        }
        String port = BrokerHelper.parse(args, "port");
        if (port == null) {
            System.out.println("port=?");
            return;
        }
        BrokerHelper bh = new BrokerHelper(host, port);
        System.out.println("host=" + bh.getHost());
        System.out.println("port=" + bh.getPort());
        System.out.println("BrokerVersion=" + bh.getBrokerVersion());
        System.out.println("BrokerUptime=" + bh.getBrokerUptime());
        System.out.println("MemoryUsed(MB)=" + bh.getMemoryUsed());
        System.out.println("MemoryMax(MB)=" + bh.getMemoryMax());
        System.out.println("ThreadsLive=" + bh.getThreadsLive());
        System.out.println("ThreadsPeak=" + bh.getThreadsPeak());
        System.out.println("SystemLoadAverage=" + bh.getSystemLoadAverage());
        Map<String, Map<String, String>> map = bh.getEntityAttributes();
        if (map != null) {
            if (!map.isEmpty()) {
                for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                    System.out.println(entry.getKey() + ":");
                    Map<String, String> attributes = entry.getValue();
                    for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                        System.out.println(attribute.getKey() + "=" + attribute.getValue());
                    }
                }
            } else {
                System.out.println("map=empty");
            }
        } else {
            System.out.println("map=null");
        }
    }

    private static enum BrokerAttribute {
        BrokerVersion,
        Uptime;

    }

    public static enum FrameworkAttribute {
        ConsumerCount,
        QueueSize,
        MaxEnqueueTime,
        AverageEnqueueTime,
        MemoryPercentUsage;

    }

    public static enum JmxKeyWord {
        Destination,
        Type,
        Topic,
        Queue;

    }
}

