/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.test.service;

import java.io.DataInputStream;
import java.io.InputStream;
import java.net.Socket;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.ServiceStatistics;

public class CustomPingNotAlive
extends AServicePing {
    String host;
    String port;

    public void init(String arguments, String endpoint) throws Exception {
        String[] parts = endpoint.split(":");
        this.host = parts[2];
        this.port = parts[3];
    }

    public void stop() {
    }

    public long readLong(DataInputStream dis) throws Exception {
        long stat1 = dis.readLong();
        return Long.reverseBytes(stat1);
    }

    public ServiceStatistics getStatistics() {
        ServiceStatistics stats = new ServiceStatistics(false, false, "<NA>");
        try {
            Socket sock = new Socket(this.host, Integer.parseInt(this.port));
            InputStream sock_in = sock.getInputStream();
            DataInputStream dis = new DataInputStream(sock_in);
            long stat1 = this.readLong(dis);
            long stat2 = this.readLong(dis);
            long stat3 = this.readLong(dis);
            long stat4 = this.readLong(dis);
            stats.setAlive(false);
            stats.setHealthy(true);
            stats.setInfo("S1[" + stat1 + "] S2[" + stat2 + "] S3[" + stat3 + "] S4[" + stat4 + "]");
            sock.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
            stats.setInfo(t.getMessage());
        }
        return stats;
    }

    public static void main(String[] args) {
        try {
            CustomPingNotAlive cp = new CustomPingNotAlive();
            cp.init(null, args[0]);
            for (int i = 0; i < 10; ++i) {
                ServiceStatistics stats = cp.getStatistics();
                System.out.println(stats);
                Thread.sleep(2000L);
            }
            cp.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

