/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.test.randomsleep;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class FixedSleepAE
extends CasAnnotator_ImplBase {
    Random r;
    Logger logger;
    static boolean initComplete = false;
    String AE_Identifier = "*^^^^^^^^^ AE ";
    ArrayList<long[]> bloated_space = new ArrayList();

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        String ok;
        String pid;
        long tid;
        block26: {
            String bloat;
            int toss;
            super.initialize(uimaContext);
            tid = Thread.currentThread().getId();
            Map<String, String> env = System.getenv();
            RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
            pid = rmxb.getName();
            long seed = System.currentTimeMillis();
            this.r = new Random(seed);
            this.logger = UIMAFramework.getLogger(FixedSleepAE.class);
            if (this.logger == null) {
                System.out.println("Is this nuts or what, no logger!");
            }
            if (initComplete) {
                this.logger.log(Level.INFO, "Init bypassed in PID:TID " + pid + ":" + tid + ", already completed. ");
                return;
            }
            if (this.logger != null) {
                this.logger.log(Level.INFO, "Init procedes in PID:TIDs " + pid + ":" + tid + " Environment:");
            }
            for (String k : env.keySet()) {
                if (this.logger == null) continue;
                this.logger.log(Level.INFO, String.format("Environment[%s] = %s", k, env.get(k)));
            }
            File workingdir = new File(System.getProperty("user.dir"));
            File[] files = workingdir.listFiles();
            if (this.logger != null) {
                this.logger.log(Level.INFO, "Working directory is " + workingdir.toString());
            }
            if (files != null) {
                for (File f : files) {
                    if (this.logger == null) continue;
                    this.logger.log(Level.INFO, "File: " + f.toString());
                }
            }
            if (!initComplete) {
                initComplete = true;
            }
            int i_error = this.getIntFromEnv("AE_INIT_ERROR", false);
            int i_exit = this.getIntFromEnv("AE_INIT_EXIT", false);
            int i_itime = this.getIntFromEnv("AE_INIT_TIME", true);
            int i_irange = this.getIntFromEnv("AE_INIT_RANGE", true);
            int i_fail_init_now = this.getIntFromEnv("AE_FAIL_INIT", false);
            if (i_fail_init_now > 0) {
                this.throwAnException("Simulated Error in Initialization");
            } else if (i_error > 0) {
                toss = this.nextrand(100);
                if (this.logger != null) {
                    this.logger.log(Level.INFO, "Init errors: probability[" + i_error + "] toss[" + toss + "]");
                }
                if (i_error > toss) {
                    this.throwAnException("Random Error in Initialization");
                }
            }
            if (i_exit > 0) {
                toss = this.nextrand(100);
                if (this.logger != null) {
                    this.logger.log(Level.INFO, "Init hard exit: probability[" + i_exit + "] toss[" + toss + "]");
                }
                if (i_exit > toss) {
                    if (this.logger != null) {
                        this.logger.log(Level.INFO, "Init hard exit: croaking hard now.");
                    }
                    Runtime.getRuntime().halt(0);
                }
            }
            if (i_itime < 0) {
                throw new IllegalArgumentException("Invalid AE_INIT_TIME, must be >= 0");
            }
            if (i_irange <= 0) {
                throw new IllegalArgumentException("Invalid AE_INIT_RANGE, must be > 0");
            }
            long sleep = i_itime + this.nextrand(i_irange);
            if (this.logger != null) {
                this.logger.log(Level.INFO, "^^--------> Initialization sleep time is " + sleep + " milliseconds");
            }
            if ((bloat = System.getenv("INIT_BLOAT")) != null) {
                if (this.logger != null) {
                    this.logger.log(Level.INFO, "INIT_BLOAT is set to " + bloat + "; starting bloat in init");
                }
                this.runBloater(bloat);
            }
            ok = "INTERRUPTED";
            if (this.logger != null) {
                this.logger.log(Level.INFO, "^^-------> AE process " + pid + " TID " + tid + " initialization starts: sleep " + sleep + "MS");
            }
            try {
                Thread.sleep(sleep);
                ok = "OK";
            }
            catch (InterruptedException e) {
                if (this.logger == null) break block26;
                this.logger.log(Level.INFO, "^^-------> AE process " + pid + " TID " + tid + " my sleep has been disturbed!");
            }
        }
        if (this.logger != null) {
            this.logger.log(Level.INFO, "^^-------> AE process " + pid + " TID " + tid + " initialization " + ok);
        }
    }

    int getIntFromEnv(String key, boolean fail) {
        String s = System.getenv(key);
        if (s == null) {
            if (fail) {
                throw new IllegalArgumentException("Missing " + key);
            }
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            if (this.logger != null) {
                this.logger.log(Level.INFO, "Invalid " + key + "[" + s + "].  Must be integer.");
            }
            throw e;
        }
    }

    double getDoubleFromEnv(String key, boolean fail) {
        String s = System.getenv(key);
        if (s == null) {
            if (fail) {
                throw new IllegalArgumentException("Missing " + key);
            }
            return 0.0;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            if (this.logger != null) {
                this.logger.log(Level.INFO, "Invalid " + key + "[" + s + "].  Must be double.");
            }
            throw e;
        }
    }

    void runBloater(String gb) {
        HashMap<Integer, long[]> bloat = new HashMap<Integer, long[]>();
        int ndx = 0;
        long total = 0L;
        long limit = Long.parseLong(gb);
        limit *= 0x40000000L;
        do {
            long[] waste = new long[4096];
            for (int i = 0; i < waste.length; ++i) {
                waste[i] = i;
            }
            bloat.put(new Integer(ndx++), waste);
            total += (long)waste.length * 8L;
            if (ndx % 1000 != 0) continue;
            System.out.println("Total " + total + " limit " + limit);
        } while (total <= limit);
        System.out.println("Stopping allocation at " + "" + total / 0x100000L + " just hanging around now.");
        try {
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (Throwable t) {
            return;
        }
    }

    void throwAnException(String msgheader) {
        int MAX_EXCEPTIONS = 7;
        int whichmessage = this.nextrand(MAX_EXCEPTIONS);
        Object[] arguments = new Object[3];
        for (int i = 0; i < 5; ++i) {
            arguments[0] = "Fake AEPE Argument number " + i;
        }
        try {
            switch (whichmessage) {
                case 2: {
                    throw new AnalysisEngineProcessException();
                }
                case 3: {
                    throw new AnalysisEngineProcessException("A deliberate error", arguments);
                }
                case 4: {
                    throw new AnalysisEngineProcessException("A deliberate error with a cause", arguments, (Throwable)new IllegalStateException("Fake ISE"));
                }
                case 5: {
                    throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("Fake ISE"));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        switch (whichmessage) {
            case 0: {
                throw new IllegalStateException(msgheader + " test message.");
            }
            case 1: {
                throw new NullPointerException();
            }
        }
        throw new IllegalStateException(msgheader + " -- Message " + whichmessage + " seems to blow the case statment in the test!");
    }

    int nextrand(int max) {
        return ((int)this.r.nextLong() & Integer.MAX_VALUE) % max;
    }

    void randomError(double error_rate, String msgheader, boolean do_exit) {
        int RANGE = 10000;
        if (error_rate == 0.0) {
            this.dolog(msgheader, "Error rate is 0, bypassing random error");
            return;
        }
        long cointoss = this.nextrand(10000);
        String msg = msgheader + " simulated error.";
        int check = (int)Math.round(10000.0 * (error_rate / 100.0));
        this.dolog("**-------> AE Error Coin toss " + cointoss + " vs " + check + ": " + (cointoss < (long)check), do_exit ? "Exiting." : "Throwing.");
        if (cointoss < (long)check) {
            if (do_exit) {
                Runtime.getRuntime().halt(0);
            } else {
                this.throwAnException(msg);
            }
        }
    }

    void dolog(Object ... args) {
        StringBuffer sb = new StringBuffer();
        for (Object s : args) {
            sb.append(s);
            sb.append(" ");
        }
        String s = sb.toString();
        System.out.println("FROM PRINTLN: " + s);
        if (this.logger != null) {
            this.logger.log(Level.INFO, "FROM LOGGER:" + s);
        }
    }

    public void destroy() {
        System.out.println(this.AE_Identifier + " Destroy is called (0)");
        this.dolog("Destroy is called (1) !");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println(this.AE_Identifier + " Destroy exits");
    }

    private void forceCpuUsage() {
        try {
            if (System.getenv("FORCE_CPU_USAGE") != null) {
                Thread t = null;
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Thread " + Thread.currentThread().getName() + " started");
                        FixedSleepAE.this.dolog(" >>>>>>>>>>> Simulating High CPU Load");
                        double val = 10.0;
                        while (true) {
                            Math.atan(Math.sqrt(Math.pow(val, 10.0)));
                        }
                    }
                });
                t.start();
                t.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void process(CAS cas) throws AnalysisEngineProcessException {
        this.forceCpuUsage();
        String data = cas.getSofaDataString();
        StringTokenizer tok = new StringTokenizer(data);
        long elapsed = Long.parseLong(tok.nextToken());
        int qid = Integer.parseInt(tok.nextToken());
        int total = Integer.parseInt(tok.nextToken());
        double error_rate = this.getDoubleFromEnv("AE_RUNTIME_ERROR", false);
        double exit_rate = this.getDoubleFromEnv("AE_RUNTIME_EXIT", false);
        RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
        String pid = rmxb.getName();
        String completion = "INTERRUPTED";
        long tid = Thread.currentThread().getId();
        String msgheader = "**-------> AE process " + pid + " TID " + tid + " task " + qid + " of " + total;
        try {
            new SourceDocumentInformation(cas.getJCas());
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        if (System.getenv("FAST_INIT_FAIL") != null) {
            System.out.println("Croakamundo.");
            System.exit(1);
        }
        this.forceCpuUsage();
        try {
            this.dolog(msgheader + " sleeping " + elapsed + " MS.");
            String bloat = System.getenv("PROCESS_BLOAT");
            if (bloat != null) {
                long gb = Long.parseLong(bloat) * 1024L * 1024L * 1024L;
                Bloat bl = new Bloat(msgheader, gb, elapsed);
                bl.start();
            }
            this.randomError(error_rate, msgheader, false);
            this.randomError(exit_rate, msgheader, true);
            Thread.sleep(elapsed);
            completion = "OK";
            this.dolog(msgheader + " returns after " + elapsed + " MS completion " + completion);
        }
        catch (InterruptedException e) {
            this.dolog(msgheader + " my sleep has been rudely interrupted!");
        }
    }

    class Bloat
    extends Thread {
        int NUM_UPDATES = 10;
        long howmuch;
        long elapsed;
        String msgheader;

        Bloat(String msgheader, long howmuch, long elapsed) {
            this.msgheader = msgheader;
            this.howmuch = howmuch;
            this.elapsed = elapsed;
        }

        void increase() {
            long amount = this.howmuch / (long)this.NUM_UPDATES;
            long current = 0L;
            long increment = 0x8000000L;
            while (current < amount) {
                FixedSleepAE.this.dolog(this.msgheader + " ====> Allocating " + increment * 8L + " bytes.");
                long[] longs = new long[(int)increment];
                FixedSleepAE.this.bloated_space.add(longs);
                FixedSleepAE.this.dolog(this.msgheader + " ====> Current " + (current += increment * 8L));
            }
            FixedSleepAE.this.dolog(this.msgheader + " ====> Allocated " + current + " bytes.");
        }

        @Override
        public void run() {
            long bloat_target = this.elapsed / 2L;
            long sleep_time = bloat_target / (long)this.NUM_UPDATES;
            FixedSleepAE.this.dolog(this.msgheader + " Starting bloater: " + this.howmuch + " bytes over " + bloat_target + " ms.");
            for (long total = 0L; total < bloat_target; total += sleep_time) {
                this.increase();
                try {
                    FixedSleepAE.this.dolog(this.msgheader + " Sleeping " + sleep_time + "ms");
                    Thread.sleep(sleep_time);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    class Marker {
        PrintWriter writer = null;
        ArrayList<String> lines = new ArrayList();

        Marker(String filestem, String pid, long tid) {
            String filename = filestem + "/AE." + pid + "." + tid + ".marker";
            try {
                this.writer = new PrintWriter(filename);
                this.writer.println(this.now() + " AE starts marker. Pid[" + pid + "] + tid[" + tid + "]");
            }
            catch (FileNotFoundException e) {
                System.out.println(" !!!!!! Can't open file: " + filename + ". user.dir = " + System.getProperty("user.dir"));
                this.writer = null;
            }
        }

        String now() {
            return "" + System.currentTimeMillis();
        }

        void write(String line) {
            if (this.writer != null) {
                this.lines.add(line);
            }
        }

        void flush() {
            if (this.writer != null) {
                this.writer.println("------------------------------------------------------------------------------------------");
                for (String s : this.lines) {
                    this.writer.println(this.now() + " " + s);
                }
                this.writer.println("------------------------------------------------------------------------------------------");
                this.writer.flush();
                this.lines.clear();
            }
        }

        void close() {
            if (this.writer != null) {
                this.flush();
                this.writer.close();
            }
        }
    }
}

