/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.test.randomsleep;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class FixedSleepCR
extends CollectionReader_ImplBase {
    Random r;
    private volatile Logger logger;
    private volatile ArrayList<Long> workitems;
    private volatile int index = 0;
    private volatile String logdir = "None";
    private volatile String jobid;
    double error_rate;
    double exit_rate;
    int bloat;
    ArrayList<Map<Object, Object>> bloated_space = new ArrayList();
    static int get_next_counter = 0;

    public void initialize() throws ResourceInitializationException {
        int toss;
        super.initialize();
        this.logger = this.getLogger();
        this.logger.log(Level.INFO, "initialize");
        long seed = System.currentTimeMillis();
        this.r = new Random(seed);
        this.jobid = System.getenv("JobId");
        this.logdir = this.jobid + ".output";
        this.logger.log(Level.INFO, " ****** BB Working directory: " + System.getProperty("user.dir"));
        this.logger.log(Level.INFO, " ****** BB jobid: " + this.logdir);
        String jobfile = (String)this.getConfigParameterValue("jobfile");
        this.logger.log(Level.INFO, " ****** BB jobfile: " + jobfile);
        String comp = (String)this.getConfigParameterValue("compression");
        this.logger.log(Level.INFO, " ****** BB compression " + comp);
        Map<String, String> env = System.getenv();
        for (String k : env.keySet()) {
            System.out.println(String.format("Environment[%s] = %s", k, env.get(k)));
        }
        File workingdir = new File(System.getProperty("user.dir"));
        File[] files = workingdir.listFiles();
        System.out.println("Working directory is " + workingdir.toString());
        for (File f : files) {
            System.out.println("File: " + f.toString());
        }
        this.error_rate = this.getDoubleFromEnv("CR_RUNTIME_ERROR", false);
        this.exit_rate = this.getDoubleFromEnv("CR_RUNTIME_EXIT", false);
        this.bloat = this.getIntFromEnv("CR_GETNEXT_BLOAT", false);
        this.bloat = this.bloat * 1024 * 1024;
        int i_error = this.getIntFromEnv("CR_INIT_ERROR", false);
        int i_exit = this.getIntFromEnv("CR_INIT_EXIT", false);
        if (i_error > 0) {
            toss = this.nextrand(100);
            this.logger.log(Level.INFO, "Init errors: probability[" + i_error + "] toss[" + toss + "]");
            if (i_error > toss) {
                this.throwAnException("Random Error in Initialization");
            }
        }
        if (i_exit > 0) {
            toss = this.nextrand(100);
            this.logger.log(Level.INFO, "Init hard exit: probability[" + i_exit + "] toss[" + toss + "]");
            if (i_exit > toss) {
                this.logger.log(Level.INFO, "Init hard exit: croaking hard now.");
                Runtime.getRuntime().halt(19);
            }
        }
        long compression = Long.parseLong(comp);
        this.workitems = new ArrayList();
        String times = "5000";
        try {
            FileReader fr = new FileReader(jobfile);
            Properties props = new Properties();
            props.load(fr);
            times = props.getProperty("elapsed");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringTokenizer st = new StringTokenizer(times);
        int ndx = 0;
        while (st.hasMoreTokens()) {
            long elapsed = Long.parseLong(st.nextToken());
            long compressed = 0L;
            if (compression > 0L) {
                compressed = elapsed / compression;
            }
            this.workitems.add(compressed);
            this.logger.log(Level.INFO, " ****** Adding work item of duration " + elapsed + " ms compressed to " + compressed + " ms as work item " + ndx++);
        }
    }

    int getIntFromEnv(String key, boolean fail) {
        this.logger.log(Level.INFO, "getIntFromEnv: key = " + key + " fail = " + fail);
        String s = System.getenv(key);
        this.logger.log(Level.INFO, "getIntFromEnv: key = " + key + " fail = " + fail + " s = " + s);
        if (s == null) {
            if (fail) {
                throw new IllegalArgumentException("Missing " + key);
            }
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.logger.log(Level.INFO, "Invalid " + key + "[" + s + "].  Must be integer.");
            throw e;
        }
    }

    double getDoubleFromEnv(String key, boolean fail) {
        String s = System.getenv(key);
        if (s == null) {
            if (fail) {
                throw new IllegalArgumentException("Missing " + key);
            }
            return 0.0;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            this.logger.log(Level.INFO, "Invalid " + key + "[" + s + "].  Must be double.");
            throw e;
        }
    }

    void throwAnException(String msgheader) {
        int MAX_EXCEPTIONS = 7;
        int whichmessage = this.nextrand(MAX_EXCEPTIONS);
        Object[] arguments = new Object[3];
        for (int i = 0; i < 5; ++i) {
            arguments[0] = "Fake CR Argument number " + i;
        }
        try {
            switch (whichmessage) {
                case 2: {
                    this.logger.log(Level.INFO, "FixedSleepCR: Throwing Analysis AnalysisEngineProcessException with no argument.");
                    throw new AnalysisEngineProcessException();
                }
                case 3: {
                    this.logger.log(Level.INFO, "FixedSleepCR: Throwing Analysis AnalysisEngineProcessException with string argument.");
                    throw new AnalysisEngineProcessException("A deliberate error", arguments);
                }
                case 4: {
                    this.logger.log(Level.INFO, "FixedSleepCR: Throwing Analysis AnalysisEngineProcessException with a string and a wrapped exception.");
                    throw new AnalysisEngineProcessException("A deliberate error with a cause", arguments, (Throwable)new IllegalStateException("Fake ISE"));
                }
                case 5: {
                    this.logger.log(Level.INFO, "FixedSleepCR: Throwing Analysis AnalysisEngineProcessException with a wrapped exception.");
                    throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("Fake ISE"));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        switch (whichmessage) {
            case 0: {
                this.logger.log(Level.INFO, "FixedSleepCR: Throwing IllegalStateExeption with a string.");
                throw new IllegalStateException(msgheader + " test message.");
            }
            case 1: {
                this.logger.log(Level.INFO, "FixedSleepCR: Throwing a NullPointer.");
                Thread notAThread = null;
                long xx = notAThread.getId();
                break;
            }
            default: {
                throw new IllegalStateException(msgheader + " -- Message " + whichmessage + " seems to blow the case statment in the test!");
            }
        }
    }

    int nextrand(int max) {
        return ((int)this.r.nextLong() & Integer.MAX_VALUE) % max;
    }

    void randomError(double error_rate, String msgheader, boolean do_exit) {
        int RANGE = 10000;
        if (error_rate == 0.0) {
            this.logger.log(Level.INFO, msgheader + " Error rate is 0, bypassing random error");
            return;
        }
        long cointoss = this.nextrand(10000);
        String msg = msgheader + " simulated error.";
        int check = (int)Math.round(10000.0 * (error_rate / 100.0));
        this.logger.log(Level.INFO, "**-------> CR Error Coin toss " + cointoss + " vs " + check + ": " + (cointoss < (long)check) + (do_exit ? " Exiting." : " Throwing."));
        if (cointoss < (long)check) {
            if (do_exit) {
                Runtime.getRuntime().halt(19);
            } else {
                this.throwAnException(msg);
            }
        }
    }

    void runBloater(int next_bloat, String msgheader) {
        if (next_bloat <= 0) {
            return;
        }
        HashMap<Integer, long[]> bloated_map = new HashMap<Integer, long[]>();
        int ndx = 0;
        int current_bloat = 0;
        while (current_bloat < next_bloat) {
            long[] waste = new long[4096];
            for (int i = 0; i < waste.length; ++i) {
                waste[i] = i;
            }
            bloated_map.put(new Integer(ndx++), waste);
            current_bloat = (int)((long)current_bloat + (long)waste.length * 8L);
        }
        this.bloated_space.add(bloated_map);
        this.logger.log(Level.INFO, msgheader + " Blated by " + current_bloat + " more bytes");
    }

    public synchronized void getNext(CAS cas) throws IOException, CollectionException {
        String msgheader = " ****** getNext[" + this.index + "]: ";
        this.logger.log(Level.INFO, msgheader + this.workitems.get(this.index) + " getNext invocation " + get_next_counter++);
        String parm = "" + this.workitems.get(this.index) + " " + (this.index + 1) + " " + this.workitems.size() + " " + this.logdir;
        this.randomError(this.error_rate, msgheader, false);
        this.randomError(this.exit_rate, msgheader, false);
        this.runBloater(this.bloat, msgheader);
        this.logger.log(Level.INFO, "getNext");
        cas.reset();
        cas.setSofaDataString(parm, "text");
        ++this.index;
    }

    public void destroy() {
        this.logger.log(Level.INFO, "destroy");
    }

    public void close() throws IOException {
        this.logger.log(Level.INFO, "close");
    }

    public Progress[] getProgress() {
        this.logger.log(Level.INFO, "getProgress");
        ProgressImpl[] retVal = new ProgressImpl[]{new ProgressImpl(this.index, this.workitems.size(), "WorkItems")};
        return retVal;
    }

    public boolean hasNext() throws IOException, CollectionException {
        boolean answer;
        this.logger.log(Level.INFO, "hasNext");
        boolean bl = answer = this.index < this.workitems.size();
        if (!answer) {
            this.logger.log(Level.INFO, "" + System.currentTimeMillis() + " " + this.jobid + " No more work, hasNext returns " + answer);
        }
        return answer;
    }
}

