/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.HistoryManagerDb;
import org.apache.uima.ducc.database.RmStatePersistence;
import org.apache.uima.ducc.database.StateServicesDb;

public class DbCreate {
    public static final String DUCC_KEYSPACE = "ducc";
    static final String PASSWORD_KEY = "db_password";
    static final String PASSWORD_FILE = "ducc.private.properties";
    int RETRY = 10;
    DuccLogger logger = null;
    String[] db_host_list;
    String adminid = null;
    String adminpw = null;
    String replication = null;
    boolean useNewPw = false;
    private Cluster cluster;
    private Session session = null;
    private boolean flag_debug = false;

    DbCreate(String db_host_list, DuccLogger logger, String adminid, String adminpw) {
        this.db_host_list = this.toArray(db_host_list);
        this.logger = logger;
        this.adminid = adminid;
        this.adminpw = adminpw;
    }

    DbCreate(String db_host_list, String adminid, String adminpw) {
        this.db_host_list = this.toArray(db_host_list);
        this.adminid = adminid;
        this.adminpw = adminpw;
    }

    DbCreate(String db_host_list, String adminid, String adminpw, String replication) {
        this.db_host_list = this.toArray(db_host_list);
        this.adminid = adminid;
        this.adminpw = adminpw;
        this.replication = replication;
    }

    private String toString(String[] array) {
        StringBuffer sb = new StringBuffer();
        if (array != null) {
            for (String item : array) {
                sb.append(item);
                sb.append(" ");
            }
        }
        return sb.toString().trim();
    }

    private String[] toArray(String stringList) {
        String methodName = "toArray";
        String[] retVal = null;
        if (stringList != null) {
            retVal = stringList.split("\\s+");
            this.debug(methodName, "list size =  " + retVal.length);
            for (String item : retVal) {
                this.debug(methodName, item);
            }
        } else {
            this.debug(methodName, "null");
        }
        return retVal;
    }

    void close() {
        if (this.cluster != null) {
            this.cluster.close();
        }
        this.session = null;
        this.cluster = null;
    }

    private void recommendation() {
        this.doLog("Check cassandra.yaml for the following entries:", new Object[0]);
        this.doLog("> authenticator: PasswordAuthenticator", new Object[0]);
        this.doLog("> authorizer: org.apache.cassandra.auth.CassandraAuthorizer", new Object[0]);
    }

    private void show(NoHostAvailableException e) {
        String location = "show";
        DuccId jobid = null;
        if (this.logger != null) {
            this.logger.debug(location, jobid, (Throwable)e, new Object[0]);
            Map map = e.getErrors();
            for (Map.Entry entry : map.entrySet()) {
                Throwable t = (Throwable)entry.getValue();
                this.logger.debug(location, jobid, t, new Object[0]);
            }
        }
    }

    boolean connect() throws Exception {
        String methodName = "connect";
        String dh = System.getProperty("DUCC_HOME");
        if (dh == null) {
            throw new IllegalArgumentException("DUCC_HOME must be set as a system property: -DDUCC_HOME=whatever");
        }
        this.doLog("database location(s): " + this.toString(this.db_host_list), new Object[0]);
        for (int i = 0; i < this.RETRY; ++i) {
            try {
                PlainTextAuthProvider auth = new PlainTextAuthProvider("cassandra", "cassandra");
                this.cluster = Cluster.builder().withAuthProvider((AuthProvider)auth).addContactPoints(this.db_host_list).build();
                this.session = this.cluster.connect();
                this.session.execute("CREATE USER IF NOT EXISTS " + this.adminid + " with password '" + this.adminpw + "' SUPERUSER");
                this.cluster.close();
                this.doLog(methodName, "Created database super user " + this.adminid);
                auth = new PlainTextAuthProvider(this.adminid, this.adminpw);
                this.cluster = Cluster.builder().withAuthProvider((AuthProvider)auth).addContactPoints(this.db_host_list).build();
                this.session = this.cluster.connect();
                String uglypw = UUID.randomUUID().toString();
                this.session.execute("ALTER USER cassandra  with password '" + uglypw + "' NOSUPERUSER");
                this.doLog(methodName, "Changed default database super user's password and revoked its superuser authority.");
                this.doLog(methodName, "From this point, this DB can only be accessed in super user mode by user 'ducc'");
                break;
            }
            catch (NoHostAvailableException e) {
                this.doLog("Waiting for database to boot ...", new Object[0]);
                this.show(e);
                this.session = null;
                this.cluster = null;
            }
            catch (AuthenticationException e) {
                this.RETRY += i;
                this.doLog(methodName, "Initial DB connection failed with AuthorizationException. Retrying database connection with your supplied userid and password.");
                try {
                    PlainTextAuthProvider auth = new PlainTextAuthProvider(this.adminid, this.adminpw);
                    this.cluster = Cluster.builder().withAuthProvider((AuthProvider)auth).addContactPoints(this.db_host_list).build();
                    this.session = this.cluster.connect();
                    break;
                }
                catch (Exception ee) {
                    this.doLog(methodName, "Authorization fails with both the default userid/password and the new userid/password.");
                    this.doLog(methodName, "Retrying, as first-time database may take a few moments to initialize.");
                    this.session = null;
                    this.cluster = null;
                }
            }
            catch (Exception e) {
                this.doLog("Unknown problem contacting database.", new Object[0]);
                this.recommendation();
                this.session = null;
                this.cluster = null;
                e.printStackTrace();
                return false;
            }
            Thread.sleep(3000L);
        }
        if (this.cluster == null) {
            this.doLog(methodName, "Excessive retries.  Database may not be initialized.");
            this.recommendation();
            return false;
        }
        Metadata metadata = this.cluster.getMetadata();
        this.doLog(methodName, "Connected to cluster:", metadata.getClusterName());
        for (Host host : metadata.getAllHosts()) {
            this.doLog(methodName, "Datatacenter:", host.getDatacenter(), "Host:", host.getAddress(), "Rack:", host.getRack());
        }
        return true;
    }

    void debug(String methodName, Object ... msg) {
        if (this.flag_debug) {
            this.doLog(methodName, msg);
        }
    }

    void doLog(String methodName, Object ... msg) {
        StringBuffer buf;
        if (this.logger == null) {
            buf = new StringBuffer(methodName);
            for (Object o : msg) {
                buf.append(" ");
                if (o == null) {
                    buf.append("<null>");
                    continue;
                }
                buf.append(o.toString());
            }
        } else {
            this.logger.info(methodName, null, msg);
            return;
        }
        System.out.println(buf);
    }

    void createSchema() {
        String methodName = "createSchema";
        String guest_pw = this.adminpw;
        String strategy = "SimpleStrategy";
        String factor = "1";
        if (this.replication != null) {
            factor = this.replication;
        }
        this.session.execute("CREATE KEYSPACE IF NOT EXISTS ducc WITH replication = {'class':'" + strategy + "', 'replication_factor':" + factor + "};");
        this.session.execute("CREATE USER IF NOT EXISTS guest  WITH PASSWORD '" + guest_pw + "' NOSUPERUSER");
        this.session.execute("GRANT SELECT ON KEYSPACE ducc TO guest");
        this.session.execute("REVOKE SELECT ON KEYSPACE system FROM guest");
        this.session.execute("REVOKE SELECT ON KEYSPACE system_auth FROM guest");
        this.session.execute("REVOKE SELECT ON KEYSPACE system_traces FROM guest");
        this.doLog(methodName, "Created database user 'guest' with SELECT priveleges on DUCC tables.");
        this.session.execute("USE ducc");
        try {
            List<SimpleStatement> rmSchema = RmStatePersistence.mkSchema();
            for (SimpleStatement simpleStatement : rmSchema) {
                this.doLog(methodName, "EXECUTE STATEMENT:", simpleStatement.toString());
                this.session.execute((Statement)simpleStatement);
            }
            List<SimpleStatement> smSchema = StateServicesDb.mkSchema();
            for (SimpleStatement s : smSchema) {
                this.doLog(methodName, "EXECUTE STATEMENT:", s.toString());
                this.session.execute((Statement)s);
            }
            ArrayList<SimpleStatement> arrayList = HistoryManagerDb.mkSchema();
            for (SimpleStatement s : arrayList) {
                this.doLog(methodName, "EXECUTE STATEMENT:", s.toString());
                this.session.execute((Statement)s);
            }
        }
        catch (Exception e) {
            this.doLog(methodName, "Cannot create schema:", e);
        }
    }

    boolean createDatabase() throws Exception {
        return true;
    }

    public static void main(String[] args) {
        DbCreate client = null;
        try {
            if (args.length == 4) {
                client = new DbCreate(args[0], args[1], args[2], args[3]);
            } else if (args.length == 3) {
                client = new DbCreate(args[0], args[1], args[2]);
            } else {
                System.out.println("Usage: DbCreate database_url db_id db_pw");
                System.exit(1);
            }
            if (client.connect()) {
                client.createSchema();
                client.close();
            } else {
                System.exit(1);
            }
        }
        catch (Throwable e) {
            System.out.println("Errors creating database");
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

