/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.uima.ducc.common.persistence.IDbProperty;
import org.apache.uima.ducc.common.persistence.services.IStateServices;
import org.apache.uima.ducc.common.persistence.services.StateServicesDirectory;
import org.apache.uima.ducc.common.persistence.services.StateServicesSet;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbHandle;
import org.apache.uima.ducc.database.DbManager;
import org.apache.uima.ducc.database.DbUtil;

public class StateServicesDb
implements IStateServices {
    private DuccLogger logger = null;
    private DbManager dbManager;
    private static final String SVC_TABLE = "ducc." + IStateServices.SvcRegProps.TABLE_NAME.pname();
    private static final String META_TABLE = "ducc." + IStateServices.SvcMetaProps.TABLE_NAME.pname();
    Map<String, IStateServices.SvcRegProps> s2regProps = new HashMap<String, IStateServices.SvcRegProps>();
    Map<String, IStateServices.SvcMetaProps> s2metaProps = new HashMap<String, IStateServices.SvcMetaProps>();

    public StateServicesDb() {
        for (IStateServices.SvcRegProps svcRegProps : IStateServices.SvcRegProps.values()) {
            this.s2regProps.put(svcRegProps.pname(), svcRegProps);
        }
        for (IStateServices.SvcRegProps svcRegProps : IStateServices.SvcMetaProps.values()) {
            this.s2metaProps.put(svcRegProps.pname(), (IStateServices.SvcMetaProps)svcRegProps);
        }
    }

    private boolean init(String dburl, DbManager dbm) throws Exception {
        String methodName = "init";
        boolean ret = true;
        if (dbm != null) {
            this.dbManager = dbm;
        } else {
            while (true) {
                try {
                    this.dbManager = new DbManager(dburl, this.logger);
                    this.dbManager.init();
                }
                catch (NoHostAvailableException e) {
                    this.logger.error(methodName, null, new Object[]{"Cannot contact the database host, Retryng connection in 5 seconds."});
                    Thread.sleep(5000L);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(methodName, null, new Object[]{"Cannot open the database.", e});
                    ret = false;
                }
                break;
            }
        }
        return ret;
    }

    public boolean init(DuccLogger logger) throws Exception {
        this.logger = logger;
        String stateUrl = System.getProperty("ducc.database.host");
        return this.init(stateUrl, null);
    }

    boolean init(DuccLogger logger, DbManager dbManager) throws Exception {
        this.logger = logger;
        String stateUrl = System.getProperty("ducc.database.host");
        return this.init(stateUrl, dbManager);
    }

    private Map<Long, DuccProperties> getProperties(String tableid, IDbProperty[] props, boolean active) throws Exception {
        String methodName = "getProperties";
        HashMap<Long, DuccProperties> ret = new HashMap<Long, DuccProperties>();
        SimpleStatement s = new SimpleStatement("SELECT * FROM " + tableid + " WHERE is_archived=" + active);
        s.setFetchSize(100);
        DbHandle h = this.dbManager.open();
        ResultSet rs = h.execute(s);
        for (Row r : rs) {
            Map<String, Object> rowvals = DbUtil.getProperties(props, r);
            DuccProperties dp = new DuccProperties();
            dp.ignorePlaceholders();
            for (String k : rowvals.keySet()) {
                dp.put((Object)k, rowvals.get(k));
            }
            try {
                String id = r.getString(IStateServices.SvcRegProps.numeric_id.pname());
                if (id == null) {
                    throw new IllegalStateException("Missing numeric id for service properties.");
                }
                ret.put(Long.parseLong(id), dp);
            }
            catch (Exception e) {
                this.logger.error(methodName, null, new Object[]{"Fatal error recovering properties.  Discarding row."});
            }
        }
        return ret;
    }

    StateServicesDirectory fetchServices(boolean isArchived) throws Exception {
        String methodName = "getStateServicesDirectory";
        long now = System.currentTimeMillis();
        StateServicesDirectory ret = new StateServicesDirectory();
        if (this.dbManager == null) {
            this.logger.error(methodName, null, new Object[]{"Service database is not initialized."});
            return ret;
        }
        try {
            Map<Long, DuccProperties> svcset = this.getProperties(SVC_TABLE, (IDbProperty[])IStateServices.SvcRegProps.values(), isArchived);
            Map<Long, DuccProperties> metaset = this.getProperties(META_TABLE, (IDbProperty[])IStateServices.SvcMetaProps.values(), isArchived);
            for (Long k : svcset.keySet()) {
                this.logger.trace(methodName, null, new Object[]{"Handling key", k});
                DuccProperties sp = svcset.get(k);
                DuccProperties mp = metaset.get(k);
                StateServicesSet sss = new StateServicesSet();
                sss.put("svc", sp);
                sss.put("meta", mp);
                ret.put(k, sss);
            }
        }
        catch (Exception e) {
            this.logger.error(methodName, null, new Object[]{"Cannot read service directory:", e});
        }
        this.logger.trace(methodName, null, new Object[]{"Time to read service registry", System.currentTimeMillis() - now});
        return ret;
    }

    public StateServicesDirectory getStateServicesDirectory() throws Exception {
        return this.fetchServices(false);
    }

    Map<IDbProperty, Object> mkMap(DuccId did, String table, Map<String, ? extends IDbProperty> converter, Properties props) {
        Object v;
        String methodName = "mkMap";
        String kk = "process_failures_limit";
        if (props.containsKey(kk)) {
            v = props.remove(kk);
            kk = IStateServices.SvcRegProps.instance_failures_limit.columnName();
            props.put(kk, v);
        }
        if (props.containsKey(kk = "process_DD")) {
            v = props.remove(kk);
            kk = IStateServices.SvcRegProps.process_dd.columnName();
            props.put(kk, v);
        }
        if (props.containsKey(kk = "process_classpath")) {
            v = props.remove(kk);
            kk = IStateServices.SvcRegProps.classpath.columnName();
            props.put(kk, v);
        }
        if (props.containsKey(kk = "jvm_args")) {
            v = props.remove(kk);
            kk = IStateServices.SvcRegProps.process_jvm_args.columnName();
            props.put(kk, v);
        }
        HashMap<IDbProperty, Object> ret = new HashMap<IDbProperty, Object>();
        for (Object k : props.keySet()) {
            IDbProperty p = converter.get((String)k);
            if (p == null) {
                this.logger.error(methodName, did, new Object[]{"Unrecognized property", k, "for table", table});
                continue;
            }
            String val = (String)props.get(k);
            val = val.replace("'", "''");
            ret.put(p, val);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeProperties(DuccId serviceId, Properties svc_props, Properties meta_props) {
        String methodName = "storePropertiesInternal";
        DbHandle h = null;
        boolean ret = false;
        long now = System.currentTimeMillis();
        try {
            h = this.dbManager.open();
            long numeric = serviceId.getFriendly();
            UUID uuid = serviceId.getUUID();
            Map<IDbProperty, Object> svc_map = this.mkMap(serviceId, SVC_TABLE, this.s2regProps, svc_props);
            Map<IDbProperty, Object> meta_map = this.mkMap(serviceId, META_TABLE, this.s2metaProps, meta_props);
            svc_map.put((IDbProperty)IStateServices.SvcRegProps.numeric_id, numeric);
            svc_map.put((IDbProperty)IStateServices.SvcRegProps.uuid, uuid.toString());
            svc_map.put((IDbProperty)IStateServices.SvcRegProps.is_archived, "false");
            meta_map.put((IDbProperty)IStateServices.SvcMetaProps.is_archived, "false");
            String cql = "";
            StringBuffer buf = new StringBuffer("BEGIN BATCH ");
            cql = DbUtil.mkInsert(SVC_TABLE, svc_map);
            buf.append(cql);
            buf.append("; ");
            cql = DbUtil.mkInsert(META_TABLE, meta_map);
            buf.append(cql);
            buf.append("; ");
            buf.append("APPLY BATCH");
            h.execute(buf.toString());
        }
        catch (Exception e) {
            try {
                this.logger.error(methodName, null, new Object[]{"Error storing props for new registration:", e});
                ret = false;
            }
            catch (Throwable throwable) {
                this.logger.trace(methodName, serviceId, new Object[]{"Time to create (2) proeprties files:", System.currentTimeMillis() - now});
                throw throwable;
            }
            this.logger.trace(methodName, serviceId, new Object[]{"Time to create (2) proeprties files:", System.currentTimeMillis() - now});
        }
        this.logger.trace(methodName, serviceId, new Object[]{"Time to create (2) proeprties files:", System.currentTimeMillis() - now});
        return ret;
    }

    public boolean moveToHistory(DuccId serviceId, Properties job_props, Properties meta_props) {
        String methodName = "moveToHistory";
        DbHandle h = null;
        try {
            h = this.dbManager.open();
            job_props.put(IStateServices.SvcRegProps.is_archived.pname(), "true");
            meta_props.put(IStateServices.SvcRegProps.is_archived.pname(), "true");
            StringBuffer buf = new StringBuffer("BEGIN BATCH ");
            buf.append("UPDATE ");
            buf.append(SVC_TABLE);
            buf.append(" SET ");
            buf.append(IStateServices.SvcRegProps.is_archived.columnName());
            buf.append("=true WHERE numeric_id='");
            buf.append(Long.toString(serviceId.getFriendly()));
            buf.append("';");
            buf.append("UPDATE ");
            buf.append(META_TABLE);
            buf.append(" SET ");
            buf.append(IStateServices.SvcMetaProps.is_archived.columnName());
            buf.append("=true WHERE numeric_id='");
            buf.append(Long.toString(serviceId.getFriendly()));
            buf.append("';");
            buf.append("APPLY BATCH");
            h.execute(buf.toString());
            return true;
        }
        catch (Exception e) {
            this.logger.error(methodName, serviceId, new Object[]{"Error moving registration to history:", e});
            return false;
        }
    }

    private boolean updateProperties(DuccId serviceId, String table, String key, Map<String, ? extends IDbProperty> converter, Properties props) {
        String methodName = "updatePropeties";
        DbHandle h = null;
        try {
            h = this.dbManager.open();
            Map<IDbProperty, Object> map = this.mkMap(serviceId, table, converter, props);
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (IDbProperty k : map.keySet()) {
                if (this.logger.isTrace()) {
                    this.logger.trace(methodName, null, new Object[]{"Updating", k.columnName(), "with", map.get(k)});
                }
                if (k.isPrimaryKey()) continue;
                tmp.add(k);
                tmp.add(map.get(k));
            }
            h.updateProperties(table, key, tmp.toArray(new Object[tmp.size()]));
            return true;
        }
        catch (Exception e) {
            this.logger.error(methodName, null, new Object[]{"Unable to update properties for service", key, "table", table, ":", e});
            return false;
        }
    }

    public boolean updateJobProperties(DuccId serviceId, Properties props) {
        return this.updateProperties(serviceId, SVC_TABLE, "numeric_id='" + Long.toString(serviceId.getFriendly()) + "'", this.s2regProps, props);
    }

    public boolean updateMetaProperties(DuccId serviceId, Properties props) {
        return this.updateProperties(serviceId, META_TABLE, "numeric_id='" + Long.toString(serviceId.getFriendly()) + "'", this.s2metaProps, props);
    }

    public void shutdown() {
        this.dbManager.shutdown();
    }

    static List<SimpleStatement> mkSchema() throws Exception {
        ArrayList<SimpleStatement> ret = new ArrayList<SimpleStatement>();
        StringBuffer buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + SVC_TABLE + " (");
        buf.append(DbUtil.mkSchema((IDbProperty[])IStateServices.SvcRegProps.values()));
        buf.append(")");
        ret.add(new SimpleStatement(buf.toString()));
        ret.add(new SimpleStatement("CREATE INDEX IF NOT EXISTS ON " + SVC_TABLE + "(" + IStateServices.SvcRegProps.is_archived.columnName() + ")"));
        buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + META_TABLE + " (");
        buf.append(DbUtil.mkSchema((IDbProperty[])IStateServices.SvcMetaProps.values()));
        buf.append(")");
        ret.add(new SimpleStatement(buf.toString()));
        ret.add(new SimpleStatement("CREATE INDEX IF NOT EXISTS ON " + META_TABLE + "(" + IStateServices.SvcMetaProps.is_archived.columnName() + ")"));
        return ret;
    }
}

