/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.mh;

import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteNode;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemotePid;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.net.iface.IMetaCasRequester;

public class RemoteWorkerThread
implements IRemoteWorkerThread {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(RemoteWorkerThread.class, IComponent.Id.JD.name());
    private boolean includeNodeAddress = false;
    private boolean includePidName = false;
    private String nodeName = null;
    private String nodeAddress = null;
    private String pidName = null;
    private int pid = 0;
    private int tid = 0;

    public RemoteWorkerThread(IMetaCasRequester metaCasRequester) {
        this.setNodeName(metaCasRequester.getRequesterNodeName());
        this.setNodeAddress(metaCasRequester.getRequesterAddress());
        this.setPidName(metaCasRequester.getRequesterProcessName());
        this.setPid(metaCasRequester.getRequesterProcessId());
        this.setTid(metaCasRequester.getRequesterThreadId());
    }

    public RemoteWorkerThread(String nodeName, String nodeAddress, String pidName, int pid, int tid) {
        this.setNodeName(nodeName);
        this.setNodeAddress(nodeAddress);
        this.setPidName(pidName);
        this.setPid(pid);
        this.setTid(tid);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.nodeName != null) {
            sb.append(this.nodeName);
            sb.append(".");
        }
        if (this.includeNodeAddress && this.nodeAddress != null) {
            sb.append("[");
            sb.append(this.nodeAddress);
            sb.append("]");
            sb.append(".");
        }
        sb.append(this.pid);
        if (this.includePidName && this.pidName != null) {
            sb.append(".");
            sb.append("[");
            sb.append(this.pidName);
            sb.append("]");
        }
        sb.append(".");
        sb.append(this.tid);
        return sb.toString();
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void setNodeName(String value) {
        this.nodeName = value;
    }

    @Override
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public void setNodeAddress(String value) {
        this.nodeAddress = value;
    }

    @Override
    public String getPidName() {
        return this.pidName;
    }

    @Override
    public void setPidName(String value) {
        this.pidName = value;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public void setPid(int value) {
        this.pid = value;
    }

    @Override
    public int getTid() {
        return this.tid;
    }

    @Override
    public void setTid(int value) {
        this.tid = value;
    }

    private int compareNodeName(RemoteWorkerThread that) {
        int retVal = 0;
        String thisNodeName = this.getNodeName();
        String thatNodeName = that.getNodeName();
        if (thisNodeName != null && thatNodeName != null) {
            retVal = thisNodeName.compareTo(thatNodeName);
        }
        return retVal;
    }

    private int comparePid(RemoteWorkerThread that) {
        int retVal = 0;
        Integer thisPid = new Integer(this.pid);
        Integer thatPid = new Integer(that.pid);
        retVal = thisPid.compareTo(thatPid);
        return retVal;
    }

    private int compareTid(RemoteWorkerThread that) {
        int retVal = 0;
        Integer thisTid = new Integer(this.tid);
        Integer thatTid = new Integer(that.tid);
        retVal = thisTid.compareTo(thatTid);
        return retVal;
    }

    @Override
    public int compareTo(Object o) {
        String location = "compareTo";
        int retVal = 0;
        try {
            if (o != null) {
                RemoteWorkerThread that = (RemoteWorkerThread)o;
                if (retVal == 0) {
                    retVal = this.compareNodeName(that);
                }
                if (retVal == 0) {
                    retVal = this.comparePid(that);
                }
                if (retVal == 0) {
                    retVal = this.compareTid(that);
                }
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String thisNodeName = this.getNodeName();
        Integer thisPid = new Integer(this.pid);
        Integer thisTid = new Integer(this.tid);
        result = 31 * result + (thisNodeName == null ? 0 : thisNodeName.hashCode());
        result = 31 * result + (thisPid == null ? 0 : thisPid.hashCode());
        result = 31 * result + (thisTid == null ? 0 : thisTid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        String location = "equals";
        boolean retVal = false;
        try {
            if (obj != null) {
                if (this == obj) {
                    retVal = true;
                } else {
                    RemoteWorkerThread that = (RemoteWorkerThread)obj;
                    if (this.compareTo(that) == 0) {
                        retVal = true;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    private int compareToNodeName(IRemoteNode that) {
        int retVal = 0;
        String thisNodeName = this.getNodeName();
        String thatNodeName = that.getNodeName();
        if (thisNodeName != null && thatNodeName != null) {
            retVal = thisNodeName.compareTo(thatNodeName);
        }
        return retVal;
    }

    private int compareToPid(IRemotePid that) {
        int retVal = 0;
        Integer thisPid = new Integer(this.getPid());
        Integer thatPid = new Integer(that.getPid());
        retVal = thisPid.compareTo(thatPid);
        return retVal;
    }

    @Override
    public boolean comprises(IRemoteNode that) {
        boolean retVal = false;
        if (that != null && this.compareToNodeName(that) == 0) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean comprises(IRemotePid that) {
        boolean retVal = false;
        if (that != null && this.compareToNodeName(that) == 0 && this.compareToPid(that) == 0) {
            retVal = true;
        }
        return retVal;
    }
}

