/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.uima.ducc.cli.ServiceStatistics;
import org.apache.uima.ducc.common.IServiceStatistics;

public class UimaAsServiceMonitor {
    private String qname;
    private String broker_url;
    private JMXConnector jmxc;
    private BrokerViewMBean brokerMBean;
    private QueueViewMBean monitoredQueue;
    private IServiceStatistics qstats;
    double enqueueTime;
    long consumerCount;
    long producerCount;
    long queueSize;
    long minEnqueueTime;
    long maxEnqueueTime;
    long inFlightCount;
    long dequeueCount;
    long enqueueCount;
    long dispatchCount;
    long expiredCount;
    boolean alive = false;
    boolean healthy = false;
    String nodeId;
    String pid;
    boolean gmfail = false;
    String failure_reason = null;
    String jmxFailure = null;
    String broker_host;
    volatile boolean useNewJmxQueryString = false;

    public UimaAsServiceMonitor(String qname, String broker_host, int broker_jmx_port) {
        this.broker_host = broker_host;
        this.qname = qname;
        this.broker_url = "service:jmx:rmi:///jndi/rmi://" + broker_host + ":" + broker_jmx_port + "/jmxrmi";
        this.qstats = new ServiceStatistics(false, false, "N/A");
    }

    private ObjectName getBrokerObjectName(MBeanServerConnection conn, String brokerQuery, String brokerNameProperty) throws Exception {
        ObjectName brokerObjectName = null;
        Iterator<ObjectName> i$ = conn.queryNames(new ObjectName(brokerQuery), null).iterator();
        while (i$.hasNext()) {
            ObjectName nameObject;
            brokerObjectName = nameObject = i$.next();
            Hashtable<String, String> parts = brokerObjectName.getKeyPropertyList();
            boolean done = false;
            if (parts.size() == 2) {
                for (Map.Entry entry : parts.entrySet()) {
                    if (!((String)entry.getKey()).equals(brokerNameProperty)) continue;
                    done = true;
                    break;
                }
            }
            if (!done) continue;
            break;
        }
        return brokerObjectName;
    }

    public void init(String parm) throws Exception {
        QueueViewMBean brokerQMBean;
        JMXServiceURL url = new JMXServiceURL(this.broker_url);
        this.jmxc = JMXConnectorFactory.connect(url);
        MBeanServerConnection conn = this.jmxc.getMBeanServerConnection();
        String jmxDomain = "org.apache.activemq";
        String brokerJmxDomain = null;
        String brokerNameProperty = "brokerName";
        String destinationId = ",destinationType=Queue,destinationName=";
        ObjectName brokerObjectName = null;
        String brokerQuery = jmxDomain + ":type=Broker,*";
        brokerObjectName = this.getBrokerObjectName(conn, brokerQuery, brokerNameProperty);
        if (brokerObjectName == null) {
            brokerQuery = jmxDomain + ":Type=Broker,*";
            brokerNameProperty = "BrokerName";
            destinationId = ",Type=Queue,Destination=";
            brokerObjectName = this.getBrokerObjectName(conn, brokerQuery, brokerNameProperty);
            String bcn = brokerObjectName.getCanonicalName();
            brokerJmxDomain = bcn.substring(0, bcn.indexOf(","));
        } else {
            brokerJmxDomain = brokerObjectName.getCanonicalName();
        }
        ObjectName targetQueueON = new ObjectName(brokerJmxDomain + destinationId + this.qname);
        this.monitoredQueue = brokerQMBean = MBeanServerInvocationHandler.newProxyInstance(conn, targetQueueON, QueueViewMBean.class, true);
        if (this.monitoredQueue == null) {
            throw new IllegalStateException("Cannot find queue: " + this.qname);
        }
    }

    public void clearQueues() throws Throwable {
        this.init(null);
        if (this.qname != null && this.brokerMBean != null) {
            this.brokerMBean.removeQueue(this.qname);
        }
        this.stop();
    }

    public void resetStatistics() {
        try {
            this.init(null);
            if (this.monitoredQueue != null) {
                this.monitoredQueue.resetStatistics();
            }
            this.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            if (this.jmxc != null) {
                this.jmxc.close();
                this.jmxc = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setJmxFailure(String msg) {
        this.jmxFailure = msg;
    }

    public void setSource(String nodeId, String pid, boolean gmfail, String failure_reason) {
        this.nodeId = nodeId;
        this.pid = pid;
        this.gmfail = gmfail;
        this.failure_reason = failure_reason;
    }

    public void setSource(String nodeId, String pid, boolean gmfail) {
        this.nodeId = nodeId;
        this.pid = pid;
        this.gmfail = gmfail;
        this.failure_reason = null;
    }

    public IServiceStatistics getStatistics() {
        try {
            this.collect();
            this.qstats.setAlive(true);
            this.qstats.setHealthy(true);
            this.qstats.setInfo(this.format());
        }
        catch (Throwable t) {
            this.qstats.setAlive(false);
            this.qstats.setHealthy(false);
            this.qstats.setInfo(t.getMessage());
        }
        return this.qstats;
    }

    public String format() {
        String answer = null;
        answer = this.jmxFailure != null ? "JMX Failure[" + this.jmxFailure + "]" + "] MetaNode[" + this.nodeId + "] MetaPid[" + this.pid : "QDEPTH[" + this.queueSize + "] AveNQ[" + new DecimalFormat("####.##").format(this.enqueueTime) + "] Consum[" + this.consumerCount + "] Prod[" + this.producerCount + "] minNQ[" + this.minEnqueueTime + "] maxNQ[" + this.maxEnqueueTime + "] expCnt[" + this.expiredCount + "] inFlt[" + this.inFlightCount + "] DQ[" + this.dequeueCount + "] NQ[" + this.enqueueCount + "] NDisp[" + this.dispatchCount + "] MetaNode[" + this.nodeId + "] MetaPid[" + this.pid + "]";
        if (this.gmfail) {
            answer = this.failure_reason == null ? answer + "; getMeta failure to service." : answer + ": " + this.failure_reason;
        }
        return answer;
    }

    public void collect() throws Throwable {
        this.init(null);
        if (this.monitoredQueue != null) {
            this.enqueueTime = this.monitoredQueue.getAverageEnqueueTime();
            this.consumerCount = this.monitoredQueue.getConsumerCount();
            this.producerCount = this.monitoredQueue.getProducerCount();
            this.queueSize = this.monitoredQueue.getQueueSize();
            this.minEnqueueTime = this.monitoredQueue.getMinEnqueueTime();
            this.maxEnqueueTime = this.monitoredQueue.getMaxEnqueueTime();
            this.inFlightCount = this.monitoredQueue.getInFlightCount();
            this.dequeueCount = this.monitoredQueue.getDequeueCount();
            this.enqueueCount = this.monitoredQueue.getEnqueueCount();
            this.dispatchCount = this.monitoredQueue.getDispatchCount();
            this.expiredCount = this.monitoredQueue.getExpiredCount();
            this.monitoredQueue.resetStatistics();
        } else {
            this.enqueueTime = 0.0;
            this.consumerCount = 0L;
            this.producerCount = 0L;
            this.queueSize = 0L;
            this.minEnqueueTime = 0L;
            this.maxEnqueueTime = 0L;
            this.inFlightCount = 0L;
            this.dequeueCount = 0L;
            this.enqueueCount = 0L;
            this.dispatchCount = 0L;
            this.expiredCount = 0L;
        }
        this.stop();
    }

    public long getQueueSize() {
        return this.queueSize;
    }

    public double getEnqueueTime() {
        return this.enqueueTime;
    }

    public long getConsumerCount() {
        return this.consumerCount;
    }

    public long getProducerCount() {
        return this.producerCount;
    }

    public long getMinEnqueueTime() {
        return this.minEnqueueTime;
    }

    public long getMaxEnqueueTime() {
        return this.maxEnqueueTime;
    }

    public long getInFlightCount() {
        return this.inFlightCount;
    }

    public long getDequeueCount() {
        return this.dequeueCount;
    }

    public long getEnqueueCount() {
        return this.enqueueCount;
    }

    public long getDispatchCount() {
        return this.dispatchCount;
    }

    public long getExpiredCount() {
        return this.expiredCount;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public boolean isGmfail() {
        return this.gmfail;
    }

    public String getJmxFailure() {
        return this.jmxFailure;
    }

    public static void main(String[] args) {
        UimaAsServiceMonitor m = new UimaAsServiceMonitor(args[0], args[1], Integer.parseInt(args[2]));
        try {
            m.init(null);
        }
        catch (Exception e1) {
            System.out.println("Cannot connect:");
            e1.printStackTrace();
            return;
        }
        while (true) {
            IServiceStatistics qs = null;
            try {
                qs = m.getStatistics();
            }
            catch (Throwable t) {
                System.out.println("Cannot collect stats.  The queue may have been deleted. Details:");
                t.printStackTrace();
                return;
            }
            System.out.println(qs.toString());
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

