/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.CliVersion;
import org.apache.uima.ducc.cli.DuccUiUtilities;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.transport.event.AbstractDuccOrchestratorEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceReplyDuccEvent;
import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;
import org.apache.uima.ducc.transport.event.sm.IService;

public class DuccServiceSubmit
extends CliBase {
    ServiceRequestProperties requestProperties = new ServiceRequestProperties();
    IUiOptions.UiOption[] opts = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Description, IUiOptions.UiOption.Administrators, IUiOptions.UiOption.SchedulingClass, IUiOptions.UiOption.LogDirectory, IUiOptions.UiOption.WorkingDirectory, IUiOptions.UiOption.Jvm, IUiOptions.UiOption.ProcessJvmArgs, IUiOptions.UiOption.Classpath, IUiOptions.UiOption.Environment, IUiOptions.UiOption.ProcessMemorySize, IUiOptions.UiOption.ProcessDD, IUiOptions.UiOption.ProcessExecutable, IUiOptions.UiOption.ProcessExecutableArgs, IUiOptions.UiOption.ProcessInitializationTimeMax, IUiOptions.UiOption.ProcessDebug, IUiOptions.UiOption.InstanceFailureLimit, IUiOptions.UiOption.Specification, IUiOptions.UiOption.ServiceDependency, IUiOptions.UiOption.ServiceRequestEndpoint, IUiOptions.UiOption.ServiceLinger, IUiOptions.UiOption.ServicePingArguments, IUiOptions.UiOption.ServiceId, IUiOptions.UiOption.ServicePingClass, IUiOptions.UiOption.ServicePingClasspath, IUiOptions.UiOption.ServicePingJvmArgs, IUiOptions.UiOption.ServicePingTimeout, IUiOptions.UiOption.ServicePingDoLog, IUiOptions.UiOption.InstanceFailureWindow, IUiOptions.UiOption.InstanceFailureLimit, IUiOptions.UiOption.InstanceInitFailureLimit};

    public DuccServiceSubmit(String[] args) throws Exception {
        this.init(this.getClass().getName(), this.opts, args, (DuccProperties)this.requestProperties, null);
    }

    public DuccServiceSubmit(ArrayList<String> args) throws Exception {
        this(args.toArray(new String[args.size()]));
    }

    public DuccServiceSubmit(Properties props) throws Exception {
        this.init(this.getClass().getName(), this.opts, props, (DuccProperties)this.requestProperties, null);
    }

    protected void enrich_parameters_for_debug(Properties props) throws Exception {
        try {
            int debug_port = -1;
            String debug_host = null;
            String do_debug = IUiOptions.UiOption.ProcessDebug.pname();
            if (props.containsKey(do_debug)) {
                String deb = props.getProperty(do_debug);
                if (deb == null) {
                    throw new IllegalArgumentException("Missing port for " + do_debug);
                }
                if (deb.equals("off")) {
                    System.out.println("Note: Ignoring process_debug = off");
                    return;
                }
                String[] parts = deb.split(":");
                if (parts.length != 2) {
                    System.out.println("Warning: process_debug must be of the form host: port.  Found '" + deb + "'.  Ignoring debug.");
                    return;
                }
                debug_host = parts[0];
                debug_port = Integer.parseInt(parts[1]);
                String debug_jvmargs = "-Xdebug -Xrunjdwp:transport=dt_socket,address=" + debug_host + ":" + debug_port;
                String jvmargs = props.getProperty(IUiOptions.UiOption.ProcessJvmArgs.pname());
                jvmargs = jvmargs == null ? debug_jvmargs : jvmargs + " " + debug_jvmargs;
                props.put(IUiOptions.UiOption.ProcessJvmArgs.pname(), jvmargs);
                props.setProperty(IUiOptions.UiOption.ProcessDeploymentsMax.pname(), "1");
                props.setProperty(IUiOptions.UiOption.ProcessFailuresLimit.pname(), "1");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid debug port (not numeric)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean execute() throws Exception {
        uimaDD = this.cli_props.getStringProperty(IUiOptions.UiOption.ProcessDD.pname(), null);
        customCmd = this.cli_props.getStringProperty(IUiOptions.UiOption.ProcessExecutable.pname(), null);
        endpoint = this.requestProperties.getProperty(IUiOptions.UiOption.ServiceRequestEndpoint.pname());
        isUimaAs = true;
        if (endpoint == null || endpoint.startsWith(IService.ServiceType.UimaAs.decode())) {
            this.requestProperties.put((Object)IUiOptions.UiOption.ServiceTypeUima.pname(), (Object)"");
            if (uimaDD == null) {
                this.message(new String[]{"ERROR: Must specify --process_DD for UIMA-AS services"});
                return false;
            }
            if (customCmd != null) {
                this.message(new String[]{"WARN: --process_executable is ignored for UIMA-AS services"});
            }
            if (!this.cli_props.containsKey((Object)(key_cp = IUiOptions.UiOption.Classpath.pname()))) {
                this.cli_props.setProperty(key_cp, System.getProperty("java.class.path"));
            }
            try {
                dd = (String)this.requestProperties.get((Object)IUiOptions.UiOption.ProcessDD.pname());
                wd = (String)this.requestProperties.get((Object)IUiOptions.UiOption.WorkingDirectory.pname());
                jvmarg_string = this.requestProperties.getProperty(IUiOptions.UiOption.ProcessJvmArgs.pname());
                inferred_endpoint = DuccUiUtilities.getEndpoint(wd, dd, jvmarg_string);
                if (endpoint == null) {
                    endpoint = inferred_endpoint;
                    this.requestProperties.put((Object)IUiOptions.UiOption.ServiceRequestEndpoint.pname(), (Object)endpoint);
                } else if (!inferred_endpoint.equals(endpoint)) {
                    this.message(new String[]{"ERROR: Endpoint from --service_request_endpoint does not match endpoint ectracted from UIMA DD\n--service_request_endpoint: " + endpoint + "\nextracted:                : " + inferred_endpoint});
                    return false;
                }
                if (!this.debug) ** GOTO lbl43
                System.out.println("service_endpoint: " + endpoint);
            }
            catch (IllegalArgumentException e) {
                this.message(new String[]{"ERROR: Cannot read/process DD descriptor for endpoint:", e.getMessage()});
                return false;
            }
        } else if (endpoint.startsWith(IService.ServiceType.Custom.decode())) {
            isUimaAs = false;
            if (uimaDD != null) {
                this.message(new String[]{"WARN: --process_DD is ignored for CUSTOM endpoints"});
            }
            this.requestProperties.put((Object)IUiOptions.UiOption.ServiceTypeCustom.pname(), (Object)"");
        } else {
            return false;
        }
lbl43:
        // 3 sources

        if (!this.check_service_dependencies(endpoint)) {
            return false;
        }
        if (this.debug) {
            this.requestProperties.dump();
        }
        if (isUimaAs) {
            this.enrich_parameters_for_debug((Properties)this.requestProperties);
        }
        this.requestProperties.put((Object)IUiOptions.UiOption.ProcessThreadCount.pname(), (Object)"1");
        ev = new SubmitServiceDuccEvent((DuccProperties)this.requestProperties, CliVersion.getVersion());
        reply = null;
        try {
            reply = (SubmitServiceReplyDuccEvent)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
        }
        catch (Exception e) {
            this.message(new String[]{"Service instance not submitted:", e.getMessage()});
            var8_12 = false;
            return var8_12;
        }
        finally {
            this.dispatcher.close();
        }
        rc = this.extractReply((AbstractDuccOrchestratorEvent)reply);
        if (rc) {
            this.saveSpec("service-specification.properties", (DuccProperties)this.requestProperties);
        }
        return rc;
    }

    public static void main(String[] args) {
        try {
            DuccServiceSubmit ds = new DuccServiceSubmit(args);
            boolean rc = ds.execute();
            if (rc) {
                System.out.println("Service instance " + ds.getDuccId() + " submitted");
                System.exit(0);
            } else {
                System.out.println("Could not submit Service");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("Cannot initialize: " + e.getMessage());
            System.exit(1);
        }
    }
}

