/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.Properties;
import org.apache.uima.ducc.cli.DuccServiceSubmit;
import org.apache.uima.ducc.common.utils.Utils;

public class CliFixups {
    static void cleanupArgs(String[] args, String className) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--process_DD")) {
                args[i] = "--process_descriptor_DD";
                System.out.println("CLI replaced deprecated option: " + arg + " with: " + args[i]);
                continue;
            }
            if (arg.equals("--instance_memory_size")) {
                args[i] = "--memory_size";
                System.out.println("CLI replaced deprecated option: " + arg + " with: " + args[i]);
                continue;
            }
            if (arg.equals("--classpath_order")) {
                System.out.println("CLI ignored deprecated option: " + arg);
                args[i] = null;
                if (++i >= args.length || args[i].startsWith("--")) continue;
                args[i] = null;
                continue;
            }
            if (!arg.equals("--number_of_instances")) continue;
            System.out.println("CLI ignored deprecated option: " + arg);
            args[i] = null;
            if (++i >= args.length || args[i].startsWith("--")) continue;
            args[i] = null;
        }
    }

    static void cleanupProps(Properties props, String className) {
        if (className.equals(DuccServiceSubmit.class.getName())) {
            String cpOrder = props.getProperty("classpath_order");
            String cp = props.getProperty("classpath");
            if (cpOrder != null && cp != null) {
                String duccHome = Utils.findDuccHome();
                String uimaCp = duccHome + "/apache-uima/lib/*:" + duccHome + "/apache-uima/apache-activemq/lib/*:" + duccHome + "/apache-uima/apache=activemq/lib/optional/*";
                cp = cpOrder.equals("ducc-before-user") ? uimaCp + ":" + cp : cp + ":" + uimaCp;
                props.put("classpath", cp);
                System.out.println("CLI added UIMA jars to classpath of pre-2.0 service");
            }
        }
        CliFixups.changeOption("process_DD", "process_descriptor_DD", props);
        CliFixups.changeOption("instance_memory_size", "memory_size", props);
        CliFixups.changeOption("classpath_order", null, props);
        CliFixups.changeOption("number_of_instances", null, props);
    }

    private static void changeOption(String oldKey, String newKey, Properties props) {
        String val = props.getProperty(oldKey);
        if (val != null) {
            props.remove(oldKey);
            if (newKey == null) {
                System.out.println("CLI ignored deprecated option: " + oldKey);
            } else {
                props.put(newKey, val);
                System.out.println("CLI replaced deprecated option: " + oldKey + " with: " + newKey);
            }
        }
    }
}

