/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.DuccJobMonitor;
import org.apache.uima.ducc.cli.DuccManagedReservationMonitor;
import org.apache.uima.ducc.cli.DuccMonitor;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.transport.event.IDuccContext;

class MonitorListener
implements Runnable {
    CliBase base = null;
    long jobid = 0L;
    DuccProperties props = null;
    IDuccContext.DuccContext context = null;
    DuccMonitor monitor = null;

    MonitorListener(CliBase base, long jobid, DuccProperties props, IDuccContext.DuccContext context) {
        this.base = base;
        this.jobid = jobid;
        this.props = props;
        this.context = context;
    }

    @Override
    public void run() {
        int retVal = 0;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("--" + IUiOptions.UiOption.JobId.pname());
            arrayList.add("" + this.jobid);
            if (this.props.containsKey((Object)IUiOptions.UiOption.Debug.pname())) {
                arrayList.add("--" + IUiOptions.UiOption.Debug.pname());
            }
            if (this.props.containsKey((Object)IUiOptions.UiOption.Quiet.pname())) {
                arrayList.add("--" + IUiOptions.UiOption.Quiet.pname());
            }
            if (this.props.containsKey((Object)"timestamp")) {
                arrayList.add("--timestamp");
            }
            if (this.props.containsKey((Object)"cancel_on_interrupt")) {
                arrayList.add("--cancel_on_interrupt");
            }
            String[] argList = arrayList.toArray(new String[0]);
            switch (this.context) {
                case ManagedReservation: {
                    this.monitor = new DuccManagedReservationMonitor(this.base.getCallback());
                    break;
                }
                case Job: {
                    this.monitor = new DuccJobMonitor(this.base.getCallback());
                }
            }
            retVal = this.monitor.run(argList);
        }
        catch (Exception e) {
            this.base.message("ERROR:" + e.toString());
            retVal = 999;
        }
        this.base.monitorExits(retVal);
    }

    void shutdown() {
        if (this.monitor != null) {
            this.monitor.cancel();
        }
    }
}

