/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Iterator;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.uima.ducc.cli.ServiceStatistics;
import org.apache.uima.ducc.common.IServiceStatistics;

public class UimaAsServiceMonitor {
    private String qname;
    private String broker_url;
    private JMXConnector jmxc;
    BrokerViewMBean brokerMBean;
    private QueueViewMBean monitoredQueue;
    private IServiceStatistics qstats;
    double enqueueTime;
    long consumerCount;
    long producerCount;
    long queueSize;
    long minEnqueueTime;
    long maxEnqueueTime;
    long inFlightCount;
    long dequeueCount;
    long enqueueCount;
    long dispatchCount;
    long expiredCount;
    boolean alive = false;
    boolean healthy = false;
    String nodeId;
    String pid;
    boolean gmfail = false;
    String jmxFailure = null;

    public long getQueueSize() {
        return this.queueSize;
    }

    public UimaAsServiceMonitor(String qname, String broker_host, int broker_port) {
        this.qname = qname;
        this.broker_url = "service:jmx:rmi:///jndi/rmi://" + broker_host + ":" + broker_port + "/jmxrmi";
        this.qstats = new ServiceStatistics(false, false, "N/A");
    }

    public void init(String parm) throws Exception {
        JMXServiceURL url = new JMXServiceURL(this.broker_url);
        this.jmxc = JMXConnectorFactory.connect(url);
        MBeanServerConnection conn = this.jmxc.getMBeanServerConnection();
        String jmxDomain = "org.apache.activemq";
        ObjectName brokerObjectName = null;
        Iterator<ObjectName> i$ = conn.queryNames(new ObjectName(jmxDomain + ":*,Type=Broker"), null).iterator();
        while (i$.hasNext()) {
            ObjectName nameObject;
            brokerObjectName = nameObject = i$.next();
        }
        this.brokerMBean = MBeanServerInvocationHandler.newProxyInstance(conn, brokerObjectName, BrokerViewMBean.class, true);
        for (ObjectName name : this.brokerMBean.getQueues()) {
            QueueViewMBean qView = MBeanServerInvocationHandler.newProxyInstance(conn, name, QueueViewMBean.class, true);
            if (!this.qname.equals(qView.getName())) continue;
            this.monitoredQueue = qView;
        }
        if (this.monitoredQueue == null) {
            throw new IllegalStateException("Cannot find queue: " + this.qname);
        }
    }

    public void clearQueues() throws Throwable {
        this.init(null);
        if (this.qname != null && this.brokerMBean != null) {
            this.brokerMBean.removeQueue(this.qname);
        }
        this.stop();
    }

    public void stop() {
        try {
            if (this.jmxc != null) {
                this.jmxc.close();
                this.jmxc = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setJmxFailure(String msg) {
        this.jmxFailure = msg;
    }

    public void setSource(String nodeId, String pid, boolean gmfail) {
        this.nodeId = nodeId;
        this.pid = pid;
        this.gmfail = gmfail;
    }

    public IServiceStatistics getStatistics() {
        try {
            this.collect();
            this.qstats.setAlive(true);
            this.qstats.setHealthy(true);
            this.qstats.setInfo(this.format());
        }
        catch (Throwable t) {
            this.qstats.setAlive(false);
            this.qstats.setHealthy(false);
            this.qstats.setInfo(t.getMessage());
        }
        return this.qstats;
    }

    public String format() {
        if (this.jmxFailure != null) {
            return "JMX Failure[" + this.jmxFailure + "]" + "] MetaNode[" + this.nodeId + "] MetaPid[" + this.pid + (this.gmfail ? "(F)" : "") + "]";
        }
        return "QDEPTH[" + this.queueSize + "] AveNQ[" + new DecimalFormat("####.##").format(this.enqueueTime) + "] Consum[" + this.consumerCount + "] Prod[" + this.producerCount + "] minNQ[" + this.minEnqueueTime + "] maxNQ[" + this.maxEnqueueTime + "] expCnt[" + this.expiredCount + "] inFlt[" + this.inFlightCount + "] DQ[" + this.dequeueCount + "] NQ[" + this.enqueueCount + "] NDisp[" + this.dispatchCount + "] MetaNode[" + this.nodeId + "] MetaPid[" + this.pid + (this.gmfail ? "(F)" : "") + "]";
    }

    public void collect() throws Throwable {
        this.init(null);
        if (this.monitoredQueue != null) {
            this.enqueueTime = this.monitoredQueue.getAverageEnqueueTime();
            this.consumerCount = this.monitoredQueue.getConsumerCount();
            this.producerCount = this.monitoredQueue.getProducerCount();
            this.queueSize = this.monitoredQueue.getQueueSize();
            this.minEnqueueTime = this.monitoredQueue.getMinEnqueueTime();
            this.maxEnqueueTime = this.monitoredQueue.getMaxEnqueueTime();
            this.inFlightCount = this.monitoredQueue.getInFlightCount();
            this.dequeueCount = this.monitoredQueue.getDequeueCount();
            this.enqueueCount = this.monitoredQueue.getEnqueueCount();
            this.dispatchCount = this.monitoredQueue.getDispatchCount();
            this.expiredCount = this.monitoredQueue.getExpiredCount();
        } else {
            this.enqueueTime = 0.0;
            this.consumerCount = 0L;
            this.producerCount = 0L;
            this.queueSize = 0L;
            this.minEnqueueTime = 0L;
            this.maxEnqueueTime = 0L;
            this.inFlightCount = 0L;
            this.dequeueCount = 0L;
            this.enqueueCount = 0L;
            this.dispatchCount = 0L;
            this.expiredCount = 0L;
        }
        this.stop();
    }

    public static void main(String[] args) {
        UimaAsServiceMonitor m = new UimaAsServiceMonitor(args[0], args[1], Integer.parseInt(args[2]));
        try {
            m.init(null);
        }
        catch (Exception e1) {
            System.out.println("Cannot connect:");
            e1.printStackTrace();
            return;
        }
        while (true) {
            IServiceStatistics qs = null;
            try {
                qs = m.getStatistics();
            }
            catch (Throwable t) {
                System.out.println("Cannot collect stats.  The queue may have been deleted. Details:");
                t.printStackTrace();
                return;
            }
            System.out.println(qs.toString());
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

