/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Parser;
import org.apache.commons.cli.PosixParser;
import org.apache.uima.ducc.cli.CliFixups;
import org.apache.uima.ducc.cli.ConsoleListener;
import org.apache.uima.ducc.cli.DefaultCallback;
import org.apache.uima.ducc.cli.DuccUiUtilities;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.cli.MonitorListener;
import org.apache.uima.ducc.common.IDucc;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.crypto.Crypto;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.dispatcher.DuccEventHttpDispatcher;
import org.apache.uima.ducc.transport.event.AbstractDuccOrchestratorEvent;
import org.apache.uima.ducc.transport.event.IDuccContext;

public abstract class CliBase
implements IUiOptions {
    private String myClassName = "N/A";
    private boolean init_done = false;
    protected String ducc_home;
    DuccEventHttpDispatcher dispatcher;
    protected Options cliOptions;
    protected Parser parser;
    protected CommandLine commandLine;
    protected long friendlyId = -1L;
    protected int returnCode = 0;
    protected DuccProperties cli_props;
    protected ArrayList<String> errors = new ArrayList();
    protected ArrayList<String> warnings = new ArrayList();
    protected ArrayList<String> messages = new ArrayList();
    protected boolean debug;
    protected ConsoleListener console_listener = null;
    protected boolean suppress_console_log;
    protected String host_address = "N/A";
    protected boolean console_attach = false;
    protected IDuccCallback consoleCb = null;
    protected MonitorListener monitor_listener = null;
    CountDownLatch waiter = null;
    protected Properties userSpecifiedProperties;
    private List<String> addedOptions = Arrays.asList(IUiOptions.UiOption.SubmitPid.pname(), IUiOptions.UiOption.User.pname());

    public abstract boolean execute() throws Exception;

    String getLogDirectory() {
        String log_directory = this.cli_props.getProperty(IUiOptions.UiOption.LogDirectory.pname());
        if (log_directory == null) {
            log_directory = System.getProperty("user.home") + IDucc.userLogsSubDirectory;
        } else if (!log_directory.startsWith(File.separator)) {
            log_directory = log_directory.endsWith(File.separator) ? System.getProperty("user.home") + log_directory : System.getProperty("user.home") + File.separator + log_directory;
        }
        this.cli_props.setProperty(IUiOptions.UiOption.LogDirectory.pname(), log_directory);
        File f = new File(log_directory);
        f.mkdirs();
        if (!f.exists()) {
            throw new IllegalArgumentException("getLogDirectory: Cannot create log directory " + log_directory);
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("Specified log_directory is not a directory: " + log_directory);
        }
        if (!f.canWrite()) {
            throw new IllegalArgumentException("Log directory exists but cannot be written: " + f);
        }
        if (!f.canExecute()) {
            throw new IllegalArgumentException("Log directory exists but cannot be accessed (must be writable and executable): " + f);
        }
        return log_directory;
    }

    void setWorkingDirectory() throws IOException {
        String working_directory = this.cli_props.getProperty(IUiOptions.UiOption.WorkingDirectory.pname());
        if (working_directory == null) {
            return;
        }
        File f = new File(working_directory);
        if (!f.exists()) {
            throw new IllegalArgumentException("Working directory " + working_directory + " does not exist.");
        }
        if (!f.isAbsolute()) {
            this.cli_props.setProperty(IUiOptions.UiOption.WorkingDirectory.pname(), f.getCanonicalPath());
        }
    }

    boolean check_service_dependencies(String endpoint) {
        String deps = this.cli_props.getProperty(IUiOptions.UiOption.ServiceDependency.pname());
        try {
            DuccUiUtilities.check_service_dependencies(endpoint, deps);
            return true;
        }
        catch (Throwable t) {
            this.message("ERROR:", t.toString());
            return false;
        }
    }

    void setUser() throws Exception {
        String signatureRequiredProperty;
        String user = DuccUiUtilities.getUser();
        this.cli_props.setProperty(IUiOptions.UiOption.User.pname(), user);
        String property = DuccPropertiesResolver.getInstance().getProperty("ducc.signature.required");
        if (property != null && (signatureRequiredProperty = property.trim().toLowerCase()).equals("on")) {
            Crypto crypto = new Crypto(user, System.getProperty("user.home"));
            byte[] cypheredMessage = crypto.encrypt((Object)user);
            this.cli_props.put((Object)IUiOptions.UiOption.Signature.pname(), (Object)cypheredMessage);
        }
    }

    public static Options makeOptions(IUiOptions.UiOption[] optlist) {
        Options opts = new Options();
        for (IUiOptions.UiOption opt : optlist) {
            String arg = opt.argname();
            Option o = new Option(opt.sname(), opt.pname(), arg != null, opt.makeDesc());
            o.setArgName(arg);
            o.setOptionalArg(arg != null && arg.endsWith("(optional)"));
            if (opt.multiargs()) {
                o.setArgs(-2);
            }
            opts.addOption(o);
        }
        return opts;
    }

    protected String[] mkArgs(Properties props) {
        ArrayList<String> arglist = new ArrayList<String>();
        for (Object o : props.keySet()) {
            String k = (String)o;
            String v = props.getProperty(k, "");
            arglist.add("--" + k);
            if (v.length() <= 0) continue;
            arglist.add(v);
        }
        return arglist.toArray(new String[arglist.size()]);
    }

    protected synchronized void init(String myClassName, IUiOptions.UiOption[] opts, String[] args, DuccProperties cli_props, IDuccCallback consoleCb) throws Exception {
        this.init(myClassName, opts, args, null, cli_props, consoleCb, "orchestrator");
    }

    protected synchronized void init(String myClassName, IUiOptions.UiOption[] opts, Properties props, DuccProperties cli_props, IDuccCallback consoleCb) throws Exception {
        this.init(myClassName, opts, null, props, cli_props, consoleCb, "orchestrator");
    }

    protected synchronized void init(String myClassName, IUiOptions.UiOption[] uiOpts, String[] args, Properties props, DuccProperties cli_props, IDuccCallback consoleCb, String servlet) throws Exception {
        List extraArgs;
        String spec;
        CliFixups.cleanupArgs(args, myClassName);
        if (this.init_done) {
            return;
        }
        this.consoleCb = consoleCb == null ? new DefaultCallback() : consoleCb;
        this.myClassName = myClassName;
        this.ducc_home = Utils.findDuccHome();
        this.cli_props = cli_props;
        this.parser = new PosixParser();
        this.cliOptions = CliBase.makeOptions(uiOpts);
        if (args == null) {
            this.commandLine = this.parser.parse(this.cliOptions, null, props);
        } else {
            this.fixupQuotedArgs(args);
            this.commandLine = this.parser.parse(this.cliOptions, args);
        }
        if (this.commandLine.getOptions().length == 0 || this.commandLine.hasOption(IUiOptions.UiOption.Help.pname())) {
            this.usage(null);
        }
        this.debug = this.commandLine.hasOption(IUiOptions.UiOption.Debug.pname());
        String fname = null;
        String[] arr$ = new String[]{IUiOptions.UiOption.Specification.pname(), IUiOptions.UiOption.Register.pname()};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (fname = this.commandLine.getOptionValue(spec = arr$[i$])) == null; ++i$) {
        }
        if (fname != null) {
            FileInputStream fis = new FileInputStream(new File(fname));
            Properties defaults = new Properties();
            defaults.load(fis);
            fis.close();
            this.sanitize(defaults, this.cliOptions);
            if (props != null) {
                defaults.putAll((Map<?, ?>)props);
            }
            this.commandLine = this.parser.parse(this.cliOptions, args, defaults);
        }
        if ((extraArgs = this.commandLine.getArgList()).size() > 0) {
            throw new ParseException("Superfluous arguments provided (perhaps quotes omitted?): " + extraArgs);
        }
        this.setOptions(uiOpts);
        this.userSpecifiedProperties = (Properties)cli_props.clone();
        this.suppress_console_log = cli_props.containsKey((Object)IUiOptions.UiOption.SuppressConsoleLog.pname());
        this.setDefaults(uiOpts, this.suppress_console_log);
        cli_props.setProperty(IUiOptions.UiOption.SubmitPid.pname(), ManagementFactory.getRuntimeMXBean().getName());
        if (this.getLogDirectory() == null) {
            throw new IllegalArgumentException("Cannot access log directory.");
        }
        this.setWorkingDirectory();
        this.setUser();
        NodeIdentity ni = new NodeIdentity();
        this.host_address = ni.getIp();
        this.initConsoleListener();
        String targetUrl = DuccUiUtilities.dispatchUrl(servlet);
        this.dispatcher = new DuccEventHttpDispatcher(targetUrl);
        this.init_done = true;
    }

    void setOptions(IUiOptions.UiOption[] uiOpts) throws Exception {
        for (Option opt : this.commandLine.getOptions()) {
            String val = opt.getValue();
            if (val == null) {
                val = opt.hasArg() ? "" : "true";
            } else {
                String oval;
                if (val.contains("${")) {
                    val = this.resolvePlaceholders(val);
                }
                if ((oval = (String)this.cli_props.get((Object)opt.getLongOpt())) != null && !oval.equals(val)) {
                    throw new Exception("Duplicate option specified: " + opt.getLongOpt());
                }
            }
            val = val.trim();
            if (val.length() == 0 && opt.getLongOpt().equals(IUiOptions.UiOption.ServiceDependency.pname())) {
                if (!this.debug) continue;
                System.out.println("CLI dropped empty option " + opt.getLongOpt());
                continue;
            }
            this.cli_props.put((Object)opt.getLongOpt(), (Object)val);
            if (!this.debug) continue;
            System.out.println("CLI set " + opt.getLongOpt() + " = '" + val + "'");
        }
    }

    void setDefaults(IUiOptions.UiOption[] uiOpts, boolean suppress_console) throws Exception {
        for (IUiOptions.UiOption uiopt : uiOpts) {
            String val;
            if (!this.cli_props.containsKey((Object)uiopt.pname())) {
                if (uiopt.required()) {
                    throw new MissingOptionException("Missing required option: " + uiopt.pname());
                }
                if (uiopt.deflt() != null) {
                    if (this.debug) {
                        System.out.println("CLI set default: " + uiopt.pname() + " = " + uiopt.deflt());
                    }
                    this.cli_props.put((Object)uiopt.pname(), (Object)uiopt.deflt());
                }
            } else if (uiopt == IUiOptions.UiOption.ClasspathOrder) {
                val = this.cli_props.getStringProperty(uiopt.pname());
                if (!val.equals(IUiOptions.ClasspathOrderParms.DuccBeforeUser.pname()) && !val.equals(IUiOptions.ClasspathOrderParms.UserBeforeDucc.pname())) {
                    throw new IllegalArgumentException("Invalid value for " + uiopt.pname() + ": " + val);
                }
            } else if (!(uiopt != IUiOptions.UiOption.ProcessMemorySize && uiopt != IUiOptions.UiOption.ReservationMemorySize || (val = this.cli_props.getStringProperty(uiopt.pname())).matches("^\\d+$"))) {
                throw new IllegalArgumentException("Invalid non-numeric value for " + uiopt.pname() + ": " + val);
            }
            if (uiopt != IUiOptions.UiOption.Environment) continue;
            DuccUiUtilities.ducc_environment(this, (Properties)this.cli_props);
        }
    }

    private void sanitize(Properties props, Options opts) {
        CliFixups.cleanupProps(props, this.myClassName);
        for (String key : props.stringPropertyNames()) {
            if (this.addedOptions.contains(key)) {
                props.remove(key);
                continue;
            }
            Option opt = this.cliOptions.getOption(key);
            if (opt == null) {
                throw new IllegalArgumentException("Invalid option " + key + " in specification file");
            }
            if (opt.hasArg()) continue;
            String val = props.getProperty(key);
            if (val.length() == 0) {
                props.setProperty(key, "true");
                continue;
            }
            if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equals("1")) continue;
            this.message("WARN: Ignoring illegal value: ", key, "=", val);
            props.remove(key);
        }
    }

    private String resolvePlaceholders(String contents) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(contents);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = System.getProperty(key);
            if (value == null && (value = System.getenv(key)) == null) {
                throw new IllegalArgumentException("Missing value for placeholder '" + key + "' in: " + contents);
            }
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    void saveSpec(String name, DuccProperties props) throws Exception {
        String directory = props.getProperty("log_directory") + File.separator + this.friendlyId;
        String fileName = directory + File.separator + name;
        File f = new File(directory);
        f.mkdirs();
        if (!f.exists()) {
            throw new IllegalStateException("saveSpec: Cannot create log directory: " + f.toString());
        }
        String comments = null;
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(fileName));
        String key = IUiOptions.UiOption.Signature.pname();
        if (props.containsKey((Object)key)) {
            Object value = props.remove((Object)key);
            props.store((Writer)out, comments);
            props.put((Object)key, value);
        } else {
            props.store((Writer)out, comments);
        }
        out.close();
        fileName = directory + File.separator + "specified-by-user.properties";
        out = new OutputStreamWriter(new FileOutputStream(fileName));
        this.userSpecifiedProperties.store(out, comments);
        out.close();
    }

    boolean extractReply(AbstractDuccOrchestratorEvent reply) {
        String pid;
        ArrayList value_submit_errors;
        boolean rc = true;
        Properties properties = reply.getProperties();
        ArrayList value_submit_warnings = (ArrayList)properties.get(IUiOptions.UiOption.SubmitWarnings.pname());
        if (value_submit_warnings != null) {
            this.message("Job warnings:");
            Iterator reasons = value_submit_warnings.iterator();
            while (reasons.hasNext()) {
                this.message("WARN:", (String)reasons.next());
            }
        }
        if ((value_submit_errors = (ArrayList)properties.get(IUiOptions.UiOption.SubmitErrors.pname())) != null) {
            this.message("Job errors:");
            Iterator reasons = value_submit_errors.iterator();
            while (reasons.hasNext()) {
                this.message("ERROR:", (String)reasons.next());
            }
            rc = false;
        }
        if ((pid = reply.getProperties().getProperty(IUiOptions.UiOption.JobId.pname())) == null) {
            this.message("ERROR: JobId not found in reply");
            rc = false;
        } else {
            this.friendlyId = Long.parseLong(pid);
            if (this.friendlyId < 0L) {
                this.message("ERROR: Invalid JobId", pid);
                rc = false;
            }
        }
        return rc;
    }

    void usage(String message) {
        if (message != null) {
            System.out.println(message);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(120);
        formatter.printHelp(this.myClassName, this.cliOptions);
        System.exit(1);
    }

    public boolean setProperty(String key, String value) {
        Option option;
        if (key.startsWith("--")) {
            key = key.substring(2);
        }
        if ((option = this.cliOptions.getOption(key)) == null) {
            return false;
        }
        this.cli_props.setProperty(key, value);
        return true;
    }

    protected IDuccCallback getCallback() {
        return this.consoleCb;
    }

    synchronized void message(String ... e) {
        if (e.length > 1) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (i = 0; i < e.length - 1; ++i) {
                sb.append(e[i]);
                sb.append(' ');
            }
            sb.append(e[i]);
            this.consoleCb.status(sb.toString());
        } else {
            this.consoleCb.status(e[0]);
        }
    }

    public int getReturnCode() {
        this.waitForCompletion();
        return this.returnCode;
    }

    public synchronized long getDuccId() {
        return this.friendlyId;
    }

    synchronized void consoleExits() {
        if (this.waiter != null) {
            this.waiter.countDown();
        }
    }

    synchronized void monitorExits(int rc) {
        this.returnCode = rc;
        if (this.waiter != null) {
            this.waiter.countDown();
        }
        if (this.console_listener != null) {
            this.console_listener.shutdown();
        }
    }

    protected synchronized void startMonitors(boolean start_stdin, IDuccContext.DuccContext context) throws Exception {
        boolean monitor_attach;
        int wait_count = 0;
        if (this.console_listener != null) {
            ++wait_count;
        }
        boolean bl = monitor_attach = this.cli_props.containsKey((Object)IUiOptions.UiOption.WaitForCompletion.pname()) || this.cli_props.containsKey((Object)IUiOptions.UiOption.CancelOnInterrupt.pname());
        if (monitor_attach) {
            ++wait_count;
        }
        if (wait_count > 0) {
            this.waiter = new CountDownLatch(wait_count);
            if (this.console_listener != null) {
                this.startConsoleListener(start_stdin);
            }
            if (monitor_attach) {
                this.startMonitor(context);
            }
        }
    }

    protected synchronized void startMonitor(IDuccContext.DuccContext context) {
        this.monitor_listener = new MonitorListener(this, this.friendlyId, this.cli_props, context);
        Thread mlt = new Thread(this.monitor_listener);
        mlt.start();
    }

    protected void initConsoleListener() throws Exception {
        String value;
        this.console_attach = this.cli_props.containsKey((Object)IUiOptions.UiOption.AttachConsole.pname());
        if (this.console_attach) {
            this.console_listener = new ConsoleListener(this, this.consoleCb);
            value = this.console_listener.getConsoleHostAddress();
        } else if (this.suppress_console_log) {
            value = "suppress";
        } else {
            return;
        }
        String key = IUiOptions.UiOption.Environment.pname();
        String env = this.cli_props.getProperty(key);
        env = env == null ? "DUCC_CONSOLE_LISTENER=" + value : env + " DUCC_CONSOLE_LISTENER=" + value;
        this.cli_props.setProperty(key, env);
    }

    protected synchronized void startConsoleListener(boolean start_stdin) throws Exception {
        if (this.console_attach) {
            this.console_listener.startStdin(start_stdin);
            Thread t = new Thread(this.console_listener);
            t.start();
        } else {
            this.message("WARN: Attermpt to start console but no console listener is defined.");
        }
    }

    protected synchronized void stopListeners() {
        if (this.console_listener != null) {
            this.console_listener.shutdown();
            this.console_listener = null;
        }
        if (this.monitor_listener != null) {
            this.monitor_listener.shutdown();
            this.monitor_listener = null;
        }
    }

    public boolean isConsoleAttached() {
        return this.console_listener != null && !this.console_listener.isShutdown();
    }

    public boolean waitForCompletion() {
        try {
            if (this.waiter != null) {
                this.waiter.await();
                return true;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String[] fixupQuotedArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) continue;
            if (args[i].charAt(0) == '\"') {
                args[i] = "\"" + args[i];
            }
            if (!args[i].endsWith("\"")) continue;
            args[i] = args[i] + "\"";
        }
        return args;
    }

    protected String fixupClasspath(String key_cp) {
        String classpath = this.cli_props.getStringProperty(key_cp, System.getProperty("java.class.path"));
        StringBuilder sb = new StringBuilder();
        String duccPrefix = this.ducc_home + "/lib";
        for (String jar : classpath.split(":")) {
            if (jar.startsWith(duccPrefix) && !jar.contains("examples")) continue;
            sb.append(":").append(jar);
        }
        if (sb.length() > 0) {
            classpath = sb.substring(1);
            this.cli_props.setProperty(key_cp, classpath);
            return classpath;
        }
        return null;
    }
}

