/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.api;

import java.util.concurrent.TimeUnit;

public final class Configs {
    private Configs() {
    }

    public static final class Defaults {
        public static final int JAVA_RESERVED_MEMORY_MB = 200;
        public static final double HEAP_RESERVED_MIN_RATIO = 0.7;
        public static final String LOCAL_STAGING_DIRECTORY = System.getProperty("java.io.tmpdir");
        public static final long LOCATION_CACHE_EXPIRY_MS = TimeUnit.DAYS.toMillis(1L);
        public static final long LOCATION_CACHE_ANTIQUE_EXPIRY_MS = TimeUnit.MINUTES.toMillis(5L);
        public static final int YARN_AM_MEMORY_MB = 512;
        public static final int YARN_AM_RESERVED_MEMORY_MB = 150;
        public static final boolean LOG_COLLECTION_ENABLED = true;
        public static final int FILE_CONTEXT_CACHE_MAX_SIZE = 100;

        private Defaults() {
        }
    }

    public static final class Keys {
        public static final String JAVA_RESERVED_MEMORY_MB = "twill.java.reserved.memory.mb";
        public static final String HEAP_RESERVED_MIN_RATIO = "twill.java.heap.memory.ratio";
        public static final String SECURE_STORE_UPDATE_LOCATION_ENABLED = "twill.secure.store.update.location.enabled";
        public static final String LOCAL_STAGING_DIRECTORY = "twill.local.staging.dir";
        public static final String LOCATION_CACHE_DIR = "twill.location.cache.dir";
        public static final String LOCATION_CACHE_EXPIRY_MS = "twill.location.cache.expiry.ms";
        public static final String LOCATION_CACHE_ANTIQUE_EXPIRY_MS = "twill.location.cache.antique.expiry.ms";
        public static final String YARN_AM_MEMORY_MB = "twill.yarn.am.memory.mb";
        public static final String YARN_AM_RESERVED_MEMORY_MB = "twill.yarn.am.reserved.memory.mb";
        public static final String YARN_MAX_APP_ATTEMPTS = "twill.yarn.max.app.attempts";
        public static final String YARN_ATTEMPT_FAILURES_VALIDITY_INTERVAL = "twill.yarn.attempt.failures.validity.interval";
        public static final String LOG_COLLECTION_ENABLED = "twill.log.collection.enabled";
        public static final String FILE_CONTEXT_CACHE_MAX_SIZE = "twill.file.context.cache.max.size";

        private Keys() {
        }
    }
}

