/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli.command;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.openejb.AppContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.cli.command.AbstractCommand;
import org.apache.openejb.server.cli.command.Command;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.xbean.finder.UrlSet;

@Command(name="classloader", usage="classloader <app>", description="print classloader info")
public class ClassLoaderCommand
extends AbstractCommand {
    public static final String CLASSLOADER_CMD = "classloader";
    private static final String INDENT = "  ";

    @Override
    public void execute(String cmd) {
        String appName = this.extractAppName(cmd);
        ContainerSystem cs = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        for (AppContext ctx : cs.getAppContexts()) {
            if (!appName.equalsIgnoreCase(ctx.getId())) continue;
            this.dumpClassLoader(ctx.getClassLoader());
            return;
        }
        this.streamManager.writeErr("can't find app " + appName);
        this.streamManager.writeErr("available apps are:");
        for (AppContext ctx : cs.getAppContexts()) {
            this.streamManager.writeErr("- " + ctx.getId());
        }
    }

    protected void dumpClassLoader(ClassLoader classLoader) {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader current = classLoader; current != null; current = current.getParent()) {
            classLoaders.add(current);
        }
        Collections.reverse(classLoaders);
        for (ClassLoader cl : classLoaders) {
            UrlSet urls;
            block7: {
                this.streamManager.writeOut("+" + cl.toString());
                try {
                    urls = new UrlSet(cl);
                    if (cl.getParent() == null) break block7;
                    urls = urls.exclude(cl.getParent());
                }
                catch (IOException e) {
                    this.streamManager.writeErr("  ` can't get urls of this classloader");
                    continue;
                }
            }
            List listUrls = urls.getUrls();
            Collections.sort(listUrls, new URLComparator());
            Iterator it = listUrls.iterator();
            while (it.hasNext()) {
                String value = ((URL)it.next()).toExternalForm();
                StringBuilder builder = new StringBuilder(INDENT);
                if (it.hasNext()) {
                    builder.append('|');
                } else {
                    builder.append('`');
                }
                builder.append(" ").append(value);
                this.streamManager.writeOut(builder.toString());
            }
        }
    }

    protected String extractAppName(String raw) {
        String cmd = raw.trim();
        if (0 == cmd.length()) {
            return "";
        }
        return cmd;
    }

    private class URLComparator
    implements Comparator<URL> {
        private URLComparator() {
        }

        @Override
        public int compare(URL o1, URL o2) {
            return o1.toExternalForm().compareTo(o2.toExternalForm());
        }
    }
}

