/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.james.mime4j.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.mail.james.mime4j.util.MimeUtil;

public class MimeParameterMapping {
    private final Map<String, String> parameters = new HashMap<String, String>();

    public Map<String, String> getParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            result.put(entry.getKey(), this.decodeParameterValue(entry.getValue()));
        }
        return result;
    }

    public void addParameter(String name, String value) {
        String key = this.removeSectionFromName(name).toLowerCase();
        if (this.parameters.containsKey(key)) {
            this.parameters.put(key, this.parameters.get(key) + value);
        } else {
            this.parameters.put(key, value);
        }
    }

    private String decodeParameterValue(String value) {
        if (value == null) {
            return null;
        }
        int charsetEnd = value.indexOf("'");
        int languageEnd = value.indexOf("'", charsetEnd + 1);
        if (charsetEnd < 0 || languageEnd < 0) {
            return MimeUtil.unscrambleHeaderValue(value);
        }
        String charset = value.substring(0, charsetEnd);
        String fileName = value.substring(languageEnd + 1);
        try {
            return URLDecoder.decode(fileName, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return MimeUtil.unscrambleHeaderValue(value);
        }
    }

    private String removeSectionFromName(String parameterName) {
        int position = parameterName.indexOf(42);
        return parameterName.substring(0, position < 0 ? parameterName.length() : position);
    }
}

