/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.ws.rs.container.ContainerRequestContext;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwtAuthenticationFilter;

public class JwtAuthenticationFilter
extends AbstractJwtAuthenticationFilter {
    private static final String DEFAULT_AUTH_SCHEME = "JWT";
    private String expectedAuthScheme = "JWT";

    @Override
    protected String getEncodedJwtToken(ContainerRequestContext requestContext) {
        String[] parts;
        String auth = requestContext.getHeaderString("Authorization");
        String[] stringArray = parts = auth == null ? null : auth.split(" ");
        if (parts == null || !this.expectedAuthScheme.equals(parts[0]) || parts.length != 2) {
            throw new JoseException(this.expectedAuthScheme + " scheme is expected");
        }
        return parts[1];
    }

    public void setExpectedAuthScheme(String expectedAuthScheme) {
        this.expectedAuthScheme = expectedAuthScheme;
    }
}

