/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class GenericsUtils {
    private GenericsUtils() {
    }

    public static Type[] getTypeArgumentsFor(Class<?> intrface, Class<?> clazz) {
        if (!intrface.isAssignableFrom(clazz)) {
            return null;
        }
        Optional<Type[]> directTypes = GenericsUtils.genericTypes(clazz).filter(type -> type instanceof ParameterizedType).map(ParameterizedType.class::cast).filter(parameterizedType -> intrface.equals(parameterizedType.getRawType())).map(ParameterizedType::getActualTypeArguments).findFirst();
        if (directTypes.isPresent()) {
            return directTypes.get();
        }
        Type[] types = GenericsUtils.declaredTypes(clazz).filter(Objects::nonNull).map(aClass -> GenericsUtils.getTypeArgumentsFor(intrface, aClass)).filter(Objects::nonNull).findFirst().orElse(null);
        if (types == null) {
            return null;
        }
        for (int i = 0; i < types.length; ++i) {
            types[i] = GenericsUtils.resolveTypeVariable(types[i], clazz);
            types[i] = GenericsUtils.resolveParameterizedTypes(types[i], clazz);
        }
        return types;
    }

    private static Type resolveParameterizedTypes(Type parameterized, Class<?> clazz) {
        if (!(parameterized instanceof ParameterizedType)) {
            return parameterized;
        }
        ParameterizedType parameterizedType = (ParameterizedType)parameterized;
        Type[] types = parameterizedType.getActualTypeArguments();
        boolean modified = false;
        for (int i = 0; i < types.length; ++i) {
            Type original = types[i];
            types[i] = GenericsUtils.resolveTypeVariable(types[i], clazz);
            types[i] = GenericsUtils.resolveParameterizedTypes(types[i], clazz);
            if (original.equals(types[i])) continue;
            modified = true;
        }
        if (!modified) {
            return parameterized;
        }
        return new ResolvedParameterizedType(parameterizedType, types);
    }

    private static Type resolveTypeVariable(Type variable, Class<?> clazz) {
        if (!(variable instanceof TypeVariable)) {
            return variable;
        }
        TypeVariable typeVariable = (TypeVariable)variable;
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        if (!(genericDeclaration instanceof Class)) {
            return variable;
        }
        Class declaringClass = (Class)genericDeclaration;
        int typePosition = GenericsUtils.positionOf(variable, declaringClass.getTypeParameters());
        if (typePosition == -1) {
            return variable;
        }
        Type[] actualTypes = GenericsUtils.genericTypes(clazz).filter(type -> type instanceof ParameterizedType).map(ParameterizedType.class::cast).filter(parameterizedType -> declaringClass.equals(parameterizedType.getRawType())).map(ParameterizedType::getActualTypeArguments).findFirst().orElse(null);
        if (actualTypes == null) {
            return variable;
        }
        if (actualTypes.length != declaringClass.getTypeParameters().length) {
            return variable;
        }
        Type resolvedType = actualTypes[typePosition];
        return resolvedType;
    }

    private static Stream<Type> genericTypes(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz.getGenericSuperclass()), Stream.of(clazz.getGenericInterfaces()));
    }

    private static Stream<Class<?>> declaredTypes(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz.getSuperclass()), Stream.of(clazz.getInterfaces()));
    }

    private static int positionOf(Type variable, TypeVariable<? extends Class<?>>[] typeParameters) {
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable<Class<?>> typeParameter = typeParameters[i];
            if (!variable.equals(typeParameter)) continue;
            return i;
        }
        return -1;
    }

    private static class ResolvedParameterizedType
    implements ParameterizedType {
        private final ParameterizedType parameterizedType;
        private final Type[] actualTypesResolved;

        ResolvedParameterizedType(ParameterizedType parameterizedType, Type[] actualTypes) {
            this.parameterizedType = parameterizedType;
            this.actualTypesResolved = actualTypes;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypesResolved;
        }

        @Override
        public Type getRawType() {
            return this.parameterizedType.getRawType();
        }

        @Override
        public Type getOwnerType() {
            return this.parameterizedType.getOwnerType();
        }

        @Override
        public String getTypeName() {
            return this.parameterizedType.getTypeName();
        }
    }
}

