/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jul.handler.rotating;

class Size {
    private long size;
    private SizeUnit unit;

    private Size() {
    }

    private Size(long size, SizeUnit unit) {
        this.size = size;
        this.unit = unit;
    }

    Size(String string) {
        this(string, null);
    }

    private Size(String string, SizeUnit defaultUnit) {
        String[] strings = string.split(",| and ");
        Size total = new Size();
        for (String s : strings) {
            String size;
            char c;
            int i;
            Size part = new Size();
            s = s.trim();
            StringBuilder t = new StringBuilder();
            StringBuilder u = new StringBuilder();
            for (i = 0; i < s.length() && (Character.isDigit(c = s.charAt(i)) || i == 0 && c == '-' || i > 0 && c == '.'); ++i) {
                t.append(c);
            }
            if (t.length() == 0) {
                Size.invalidFormat(s);
            }
            while (i < s.length() && Character.isWhitespace(c = s.charAt(i))) {
                ++i;
            }
            while (i < s.length()) {
                c = s.charAt(i);
                if (Character.isLetter(c)) {
                    u.append(c);
                } else {
                    Size.invalidFormat(s);
                }
                ++i;
            }
            part.unit = Size.parseUnit(u.toString());
            if (part.unit == null) {
                part.unit = defaultUnit;
            }
            if ((size = t.toString()).contains(".")) {
                if (part.unit == null) {
                    throw new IllegalArgumentException("unit must be specified with floating point numbers");
                }
                double d = Double.parseDouble(size);
                long bytes = part.unit.toBytes(1L);
                part.size = (long)((double)bytes * d);
                part.unit = SizeUnit.BYTES;
            } else {
                part.size = Integer.parseInt(size);
            }
            total = total.add(part);
        }
        this.size = total.size;
        this.unit = total.unit;
    }

    public long asBytes() {
        return this.unit.toBytes(this.size);
    }

    public Size add(Size that) {
        Normalize n = new Normalize(this, that);
        return new Size(n.a + n.b, n.base);
    }

    private static void invalidFormat(String text) {
        throw new IllegalArgumentException("Illegal size format: '" + text + "'.  Valid examples are '10kb' or '10 kilobytes'.");
    }

    private static SizeUnit parseUnit(String u) {
        if (u.length() == 0) {
            return null;
        }
        if ("BYTES".equalsIgnoreCase(u)) {
            return SizeUnit.BYTES;
        }
        if ("BYTE".equalsIgnoreCase(u)) {
            return SizeUnit.BYTES;
        }
        if ("B".equalsIgnoreCase(u)) {
            return SizeUnit.BYTES;
        }
        if ("KILOBYTES".equalsIgnoreCase(u)) {
            return SizeUnit.KILOBYTES;
        }
        if ("KILOBYTE".equalsIgnoreCase(u)) {
            return SizeUnit.KILOBYTES;
        }
        if ("KILO".equalsIgnoreCase(u)) {
            return SizeUnit.KILOBYTES;
        }
        if ("KB".equalsIgnoreCase(u)) {
            return SizeUnit.KILOBYTES;
        }
        if ("K".equalsIgnoreCase(u)) {
            return SizeUnit.KILOBYTES;
        }
        if ("MEGABYTES".equalsIgnoreCase(u)) {
            return SizeUnit.MEGABYTES;
        }
        if ("MEGABYTE".equalsIgnoreCase(u)) {
            return SizeUnit.MEGABYTES;
        }
        if ("MEGA".equalsIgnoreCase(u)) {
            return SizeUnit.MEGABYTES;
        }
        if ("MB".equalsIgnoreCase(u)) {
            return SizeUnit.MEGABYTES;
        }
        if ("M".equalsIgnoreCase(u)) {
            return SizeUnit.MEGABYTES;
        }
        if ("GIGABYTES".equalsIgnoreCase(u)) {
            return SizeUnit.GIGABYTES;
        }
        if ("GIGABYTE".equalsIgnoreCase(u)) {
            return SizeUnit.GIGABYTES;
        }
        if ("GIGA".equalsIgnoreCase(u)) {
            return SizeUnit.GIGABYTES;
        }
        if ("GB".equalsIgnoreCase(u)) {
            return SizeUnit.GIGABYTES;
        }
        if ("G".equalsIgnoreCase(u)) {
            return SizeUnit.GIGABYTES;
        }
        throw new IllegalArgumentException("Unknown size unit '" + u + "'");
    }

    private static enum SizeUnit {
        BYTES{

            @Override
            public long toBytes(long s) {
                return s;
            }

            @Override
            public long toKilobytes(long s) {
                return s / 1024L;
            }

            @Override
            public long toMegabytes(long s) {
                return s / 0x100000L;
            }

            @Override
            public long toGigabytes(long s) {
                return s / 0x40000000L;
            }

            @Override
            public long toTerabytes(long s) {
                return s / 0x10000000000L;
            }

            @Override
            public long convert(long s, SizeUnit u) {
                return u.toBytes(s);
            }
        }
        ,
        KILOBYTES{

            @Override
            public long toBytes(long s) {
                return 2.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
            }

            @Override
            public long toKilobytes(long s) {
                return s;
            }

            @Override
            public long toMegabytes(long s) {
                return s / 1024L;
            }

            @Override
            public long toGigabytes(long s) {
                return s / 0x100000L;
            }

            @Override
            public long toTerabytes(long s) {
                return s / 0x40000000L;
            }

            @Override
            public long convert(long s, SizeUnit u) {
                return u.toKilobytes(s);
            }
        }
        ,
        MEGABYTES{

            @Override
            public long toBytes(long s) {
                return 3.x(s, 0x100000L, 0x7FFFFFFFFFFL);
            }

            @Override
            public long toKilobytes(long s) {
                return 3.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
            }

            @Override
            public long toMegabytes(long s) {
                return s;
            }

            @Override
            public long toGigabytes(long s) {
                return s / 1024L;
            }

            @Override
            public long toTerabytes(long s) {
                return s / 0x100000L;
            }

            @Override
            public long convert(long s, SizeUnit u) {
                return u.toMegabytes(s);
            }
        }
        ,
        GIGABYTES{

            @Override
            public long toBytes(long s) {
                return 4.x(s, 0x40000000L, 0x1FFFFFFFFL);
            }

            @Override
            public long toKilobytes(long s) {
                return 4.x(s, 0x100000L, 0x7FFFFFFFFFFL);
            }

            @Override
            public long toMegabytes(long s) {
                return 4.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
            }

            @Override
            public long toGigabytes(long s) {
                return s;
            }

            @Override
            public long toTerabytes(long s) {
                return s / 1024L;
            }

            @Override
            public long convert(long s, SizeUnit u) {
                return u.toGigabytes(s);
            }
        }
        ,
        TERABYTES{

            @Override
            public long toBytes(long s) {
                return 5.x(s, 0x10000000000L, 0x7FFFFFL);
            }

            @Override
            public long toKilobytes(long s) {
                return 5.x(s, 0x40000000L, 0x1FFFFFFFFL);
            }

            @Override
            public long toMegabytes(long s) {
                return 5.x(s, 0x100000L, 0x7FFFFFFFFFFL);
            }

            @Override
            public long toGigabytes(long s) {
                return 5.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
            }

            @Override
            public long toTerabytes(long s) {
                return s;
            }

            @Override
            public long convert(long s, SizeUnit u) {
                return u.toTerabytes(s);
            }
        };

        static final long B0 = 1L;
        static final long B1 = 1024L;
        static final long B2 = 0x100000L;
        static final long B3 = 0x40000000L;
        static final long B4 = 0x10000000000L;

        static long x(long d, long m, long over) {
            if (d > over) {
                return Long.MAX_VALUE;
            }
            if (d < -over) {
                return Long.MIN_VALUE;
            }
            return d * m;
        }

        public long toBytes(long size) {
            throw new AbstractMethodError();
        }

        public long toKilobytes(long size) {
            throw new AbstractMethodError();
        }

        public long toMegabytes(long size) {
            throw new AbstractMethodError();
        }

        public long toGigabytes(long size) {
            throw new AbstractMethodError();
        }

        public long toTerabytes(long size) {
            throw new AbstractMethodError();
        }

        public long convert(long sourceSize, SizeUnit sourceUnit) {
            throw new AbstractMethodError();
        }
    }

    private static final class Normalize {
        private final long a;
        private final long b;
        private final SizeUnit base;

        private Normalize(Size a, Size b) {
            this.base = Normalize.lowest(a, b);
            this.a = a.unit == null ? a.size : this.base.convert(a.size, a.unit);
            this.b = b.unit == null ? b.size : this.base.convert(b.size, b.unit);
        }

        private static SizeUnit lowest(Size a, Size b) {
            if (a.unit == null) {
                return b.unit;
            }
            if (b.unit == null) {
                return a.unit;
            }
            if (a.size == 0L) {
                return b.unit;
            }
            if (b.size == 0L) {
                return a.unit;
            }
            return SizeUnit.values()[Math.min(a.unit.ordinal(), b.unit.ordinal())];
        }
    }
}

