/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import org.apache.openejb.client.FlushableGZIPOutputStream;
import org.apache.openejb.client.KeepAliveStyle;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServicePool;
import org.apache.openejb.server.Unwrappable;
import org.apache.openejb.server.context.RequestInfos;
import org.apache.openejb.server.ejbd.EjbServer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class KeepAliveServer
implements ServerService {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("keepalive"), KeepAliveServer.class);
    private final ServerService service;
    private final long timeout = 10000L;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ConcurrentHashMap<Thread, Session> sessions = new ConcurrentHashMap();
    private BlockingQueue<Runnable> threadQueue;
    private Timer timer;
    private final boolean gzip;

    public KeepAliveServer() {
        this(new EjbServer());
    }

    @Deprecated
    public KeepAliveServer(ServerService service) {
        this(service, false);
    }

    public KeepAliveServer(ServerService service, boolean gzip) {
        this.service = service;
        this.gzip = gzip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void closeInactiveSessions() {
        if (!this.running.get()) {
            return;
        }
        BlockingQueue<Runnable> queue = this.getQueue();
        if (queue == null) {
            return;
        }
        int backlog = queue.size();
        if (backlog <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        ArrayList<Session> current = new ArrayList<Session>();
        current.addAll(this.sessions.values());
        for (Session session : current) {
            block12: {
                Lock l = session.lock;
                if (l.tryLock()) {
                    try {
                        if (now - session.lastRequest.get() <= this.timeout) break block12;
                        --backlog;
                        try {
                            session.close();
                            this.removeSession(session);
                        }
                        catch (Throwable throwable) {
                            this.removeSession(session);
                            break block12;
                            catch (Throwable throwable2) {
                                this.removeSession(session);
                                throw throwable2;
                            }
                        }
                    }
                    finally {
                        l.unlock();
                    }
                }
            }
            if (backlog > 0) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSessions() {
        ArrayList<Session> current = new ArrayList<Session>();
        current.addAll(this.sessions.values());
        for (Session session : current) {
            Lock l = session.lock;
            if (l.tryLock()) {
                try {
                    session.close();
                }
                catch (Throwable throwable) {}
                continue;
                finally {
                    this.removeSession(session);
                    l.unlock();
                    continue;
                }
            }
            if (!logger.isDebugEnabled()) continue;
            try {
                logger.debug("Allowing graceful shutdown of " + session.socket.getInetAddress());
            }
            catch (Throwable throwable) {}
        }
        this.sessions.clear();
    }

    private BlockingQueue<Runnable> getQueue() {
        if (this.threadQueue == null) {
            ServicePool incoming;
            ServicePool servicePool = incoming = Unwrappable.class.isInstance(this.service) ? (ServicePool)((Unwrappable)Unwrappable.class.cast(this.service)).unwrap(ServicePool.class) : null;
            if (incoming == null) {
                return null;
            }
            this.threadQueue = incoming.getThreadPool().getQueue();
        }
        return this.threadQueue;
    }

    public Session addSession(Session session) {
        return this.sessions.put(session.thread, session);
    }

    public Session removeSession(Session session) {
        return this.sessions.remove(session.thread);
    }

    public void service(Socket socket) throws ServiceException, IOException {
        RequestInfos.initRequestInfo((Socket)socket);
        try {
            new Session(this, socket).service();
        }
        finally {
            RequestInfos.clearRequestInfo();
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public String getIP() {
        return this.service.getIP();
    }

    public String getName() {
        return this.service.getName();
    }

    public int getPort() {
        return this.service.getPort();
    }

    public void start() throws ServiceException {
        if (!this.running.getAndSet(true)) {
            this.timer = new Timer("KeepAliveTimer", true);
            this.timer.scheduleAtFixedRate((TimerTask)new KeepAliveTimer(this), this.timeout, this.timeout / 2L);
        }
    }

    public void stop() throws ServiceException {
        if (this.running.getAndSet(false)) {
            try {
                this.closeSessions();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.timer.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void init(Properties props) throws Exception {
        this.service.init(props);
    }

    public class Output
    extends FilterOutputStream {
        public Output(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }

    public class Input
    extends FilterInputStream {
        public Input(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class Session {
        private final Thread thread;
        private final KeepAliveServer kas;
        private final Lock lock = new ReentrantLock();
        private final AtomicLong lastRequest;
        private final Socket socket;
        private InputStream in = null;
        private OutputStream out = null;

        private Session(KeepAliveServer kas, Socket socket) {
            this.kas = kas;
            this.socket = socket;
            this.lastRequest = new AtomicLong(System.currentTimeMillis());
            this.thread = Thread.currentThread();
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void service() throws ServiceException, IOException {
            this.kas.addSession(this);
            int i = -1;
            try {
                Lock l1 = this.lock;
                l1.lock();
                try {
                    if (!KeepAliveServer.this.gzip) {
                        this.in = new BufferedInputStream(this.socket.getInputStream());
                        this.out = new BufferedOutputStream(this.socket.getOutputStream());
                    } else {
                        this.in = new GZIPInputStream(new BufferedInputStream(this.socket.getInputStream()));
                        this.out = new BufferedOutputStream((OutputStream)new FlushableGZIPOutputStream(this.socket.getOutputStream()));
                    }
                }
                finally {
                    l1.unlock();
                }
                while (KeepAliveServer.this.running.get()) {
                    try {
                        i = this.in.read();
                    }
                    catch (SocketException e) {
                        break;
                    }
                    if (i == -1) {
                        break;
                    }
                    KeepAliveStyle style = KeepAliveStyle.values()[i];
                    Lock l2 = this.lock;
                    l2.lock();
                    try {
                        switch (style) {
                            case PING_PING: {
                                i = this.in.read();
                                break;
                            }
                            case PING_PONG: {
                                this.out.write(style.ordinal());
                                this.out.flush();
                            }
                        }
                        try {
                            KeepAliveServer.this.service.service((InputStream)new Input(this.in), (OutputStream)new Output(this.out));
                            this.out.flush();
                        }
                        catch (SocketException e) {
                            this.lastRequest.set(System.currentTimeMillis());
                            l2.unlock();
                            break;
                        }
                    }
                    finally {
                        this.lastRequest.set(System.currentTimeMillis());
                        l2.unlock();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Unexpected byte " + i);
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
            }
            finally {
                this.close();
                this.kas.removeSession(this);
            }
        }

        private void close() {
            if (null != this.in) {
                try {
                    this.in.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (null != this.out) {
                try {
                    this.out.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (null != this.socket) {
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public class KeepAliveTimer
    extends TimerTask {
        private final KeepAliveServer kas;

        public KeepAliveTimer(KeepAliveServer kas) {
            this.kas = kas;
        }

        @Override
        public void run() {
            this.kas.closeInactiveSessions();
        }
    }
}

