/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.util.InternalException;

public class XMLValueHandler
extends AbstractValueHandler {
    private static final long serialVersionUID = 1L;
    private static final String PROXY_SUFFIX = "$proxy";

    @Override
    @Deprecated
    public Column[] map(ValueMapping vm, String name, ColumnIO io, boolean adapt) {
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn(name, dict != null ? dict.delimitAll() : false);
        return this.map(vm, colName, io, adapt);
    }

    public Column[] map(ValueMapping vm, DBIdentifier name, ColumnIO io, boolean adapt) {
        Column col = new Column();
        col.setIdentifier(name);
        col.setJavaType(9);
        col.setSize(-1);
        col.setTypeIdentifier(DBIdentifier.newColumnDefinition(vm.getMappingRepository().getDBDictionary().xmlTypeName));
        col.setXML(true);
        return new Column[]{col};
    }

    @Override
    public Object toDataStoreValue(ValueMapping vm, Object val, JDBCStore store) {
        if (val == null) {
            return null;
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{val.getClass().getName().endsWith(PROXY_SUFFIX) ? val.getClass().getSuperclass() : val.getClass()});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)store.getDBDictionary().getXMLTypeEncoding());
            StringWriter result = new StringWriter();
            m.marshal(val, (Writer)result);
            return ((Object)result).toString();
        }
        catch (JAXBException je) {
            throw new InternalException(je);
        }
    }

    @Override
    public Object toObjectValue(ValueMapping vm, Object val) {
        if (val == null) {
            return null;
        }
        try {
            String className = vm.getDeclaredType().getName();
            int i = className.lastIndexOf(46);
            String packageName = className;
            if (i != -1) {
                packageName = className.substring(0, i);
            }
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller u = jc.createUnmarshaller();
            return u.unmarshal((Source)new StreamSource(new StringReader(val.toString())));
        }
        catch (JAXBException je) {
            throw new InternalException(je);
        }
    }
}

