/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util.stub;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.rmi.util.stub.BCELClassBuilder;
import org.apache.yoko.rmi.util.stub.MethodRef;
import org.apache.yoko.rmi.util.stub.Stub;
import org.apache.yoko.rmi.util.stub.StubInitializer;
import org.apache.yoko.rmi.util.stub.Util;

public final class StubClass {
    static final Logger logger = Logger.getLogger(StubClass.class.getName());

    public static Object getStubHandler(Stub stub) {
        return stub.____getTriforkStubHandler();
    }

    public static Class make(final ClassLoader loader, final Class super_class, final Class[] interfaces, final MethodRef[] methods, final Object[] data, final Method handler_method, final String package_name) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class[] theInterfaces;
                    Class<Object> superClass = super_class;
                    if (superClass == null) {
                        superClass = Object.class;
                    }
                    if ((theInterfaces = interfaces) == null) {
                        theInterfaces = new Class[]{};
                    }
                    ClassLoader theLoader = StubClass.chooseLoader(loader, superClass, theInterfaces, handler_method);
                    MethodRef[] theMethods = methods;
                    if (theMethods == null) {
                        theMethods = BCELClassBuilder.collectMethods(superClass, theInterfaces);
                    }
                    String className = BCELClassBuilder.className(package_name, superClass, theInterfaces);
                    return BCELClassBuilder.make(theLoader, superClass, theInterfaces, theMethods, data, new MethodRef(handler_method), className);
                }
                catch (IllegalAccessException ex) {
                    throw new Error("illegal access", ex);
                }
                catch (InstantiationException ex) {
                    throw new Error("illegal access", ex);
                }
            }
        });
    }

    public static MethodRef[] getAbstractMethodRefs(final Class base, final Class[] interfaces) {
        return (MethodRef[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BCELClassBuilder.getAbstractMethods(base, interfaces);
            }
        });
    }

    public static Class make(ClassLoader loader, Class super_class, Class[] interfaces, MethodRef[] methods, Method[] superMethods, Object[] data, Method handler_method, String package_name, StubInitializer initializer) {
        return StubClass.make(loader, super_class, interfaces, methods, superMethods, data, handler_method, package_name, null, initializer);
    }

    public static Class make(final ClassLoader loader, final Class super_class, final Class[] interfaces, final MethodRef[] methods, final Method[] superMethods, final Object[] data, final Method handler_method, final String package_name, final String class_name, final StubInitializer initializer) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    MethodRef[] superMethodRefs;
                    Class[] theInterfaces;
                    Class<Object> superClass = super_class;
                    if (superClass == null) {
                        superClass = Object.class;
                    }
                    if ((theInterfaces = interfaces) == null) {
                        theInterfaces = new Class[]{};
                    }
                    ClassLoader theLoader = StubClass.chooseLoader(loader, superClass, theInterfaces, handler_method);
                    MethodRef[] theMethods = methods;
                    if (theMethods == null) {
                        theMethods = BCELClassBuilder.collectMethods(superClass, theInterfaces);
                    }
                    if (superMethods == null) {
                        superMethodRefs = new MethodRef[]{};
                    } else {
                        superMethodRefs = new MethodRef[superMethods.length];
                        for (int i = 0; i < superMethods.length; ++i) {
                            superMethodRefs[i] = new MethodRef(superMethods[i]);
                        }
                    }
                    Object[] theData = data;
                    if (theData == null) {
                        theData = theMethods;
                    }
                    MethodRef handlerMethodRef = new MethodRef(handler_method);
                    String className = class_name;
                    if (className == null) {
                        className = BCELClassBuilder.className(package_name, superClass, theInterfaces);
                    }
                    Class result = BCELClassBuilder.make(theLoader, superClass, theInterfaces, theMethods, superMethodRefs, theData, handlerMethodRef, className, initializer);
                    if (superMethods != null) {
                        try {
                            for (int i = 0; i < superMethods.length; ++i) {
                                Method m = superMethods[i];
                                superMethods[i] = result.getDeclaredMethod(Util.getSuperMethodName(m.getName()), m.getParameterTypes());
                            }
                        }
                        catch (NoSuchMethodException ex) {
                            throw new Error("internal error!", ex);
                        }
                    }
                    return result;
                }
                catch (IllegalAccessException ex) {
                    throw new Error("illegal access", ex);
                }
                catch (InstantiationException ex) {
                    throw new Error("illegal access", ex);
                }
            }
        });
    }

    public static Stub createInstance(final Class clazz, final Object handler) {
        return (Stub)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Constructor<?>[] con = clazz.getConstructors();
                    return con[0].newInstance(handler);
                }
                catch (InstantiationException ex) {
                    logger.log(Level.WARNING, "", ex);
                }
                catch (InvocationTargetException ex) {
                    logger.log(Level.WARNING, "", ex);
                }
                catch (IllegalAccessException ex) {
                    logger.log(Level.WARNING, "", ex);
                }
                return null;
            }
        });
    }

    public static Stub createInstance(final Class clazz) {
        return (Stub)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return clazz.newInstance();
                }
                catch (InstantiationException ex) {
                    logger.log(Level.WARNING, "", ex);
                }
                catch (IllegalAccessException ex) {
                    logger.log(Level.WARNING, "", ex);
                }
                return null;
            }
        });
    }

    private static ClassLoader chooseLoader(ClassLoader loader, Class superClass, Class[] interfaces, Method handler) {
        HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
        loaders.add(Stub.class.getClassLoader());
        loaders.add(handler.getDeclaringClass().getClassLoader());
        if (loader != null) {
            loaders.add(loader);
        }
        if (superClass != null && superClass.getClassLoader() != null) {
            loaders.add(superClass.getClassLoader());
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].getClassLoader() == null) continue;
            loaders.add(interfaces[i].getClassLoader());
        }
        if (loaders.size() == 0) {
            return superClass.getClassLoader();
        }
        ClassLoader first = (ClassLoader)loaders.iterator().next();
        if (loaders.size() == 1) {
            return first;
        }
        loaders.remove(first);
        ClassLoader[] rest = new ClassLoader[loaders.size()];
        loaders.toArray(rest);
        return new SetClassLoader(rest, first);
    }

    static class SetClassLoader
    extends SecureClassLoader {
        ClassLoader[] rest;

        SetClassLoader(ClassLoader[] loaders, ClassLoader parent) {
            super(parent);
            this.rest = loaders;
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException ex) {
                for (int i = 0; i < this.rest.length; ++i) {
                    try {
                        return this.rest[i].loadClass(name);
                    }
                    catch (ClassNotFoundException ex2) {
                        continue;
                    }
                }
                throw new ClassNotFoundException(name);
            }
        }
    }
}

