/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.CorbaObjectReader;
import org.apache.yoko.rmi.impl.CorbaObjectWriter;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueHandlerImpl;
import org.apache.yoko.rmi.util.StringUtil;
import org.omg.CORBA.AttributeDescription;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueDefPackage.FullValueDescription;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.SendingContext.CodeBase;
import org.omg.SendingContext.CodeBaseHelper;
import org.omg.SendingContext.RunTime;
import sun.reflect.ReflectionFactory;

public class ValueDescriptor
extends TypeDescriptor {
    static final Logger logger = Logger.getLogger(ValueDescriptor.class.getName());
    protected boolean _is_externalizable;
    protected boolean _is_serializable;
    protected Method _write_replace_method;
    protected Method _read_resolve_method;
    protected Constructor _constructor;
    protected Method _write_object_method;
    protected Method _read_object_method;
    protected Field _serial_version_uid_field;
    protected ValueDescriptor _super_descriptor;
    protected FieldDescriptor[] _fields;
    protected ObjectDeserializer _object_deserializer;
    protected boolean _is_immutable_value;
    protected boolean _is_rmi_stub;
    private static Set _immutable_value_classes;
    private static java.lang.Object[] NO_ARGS;
    protected long _hash_code;
    private static Comparator compareByName;
    protected ValueMember[] _value_members = null;

    ValueDescriptor(Class type, TypeRepository repository) {
        super(type, repository);
    }

    public String getRepositoryID() {
        if (this._repid == null) {
            StringBuffer buf = new StringBuffer("RMI:");
            buf.append(StringUtil.convertToValidIDLNames(this.getJavaClass().getName()));
            buf.append(":");
            String hashCode = Long.toHexString(this._hash_code).toUpperCase();
            int i = 0;
            while (i + hashCode.length() != 16) {
                buf.append('0');
                ++i;
            }
            buf.append(hashCode);
            long serialVersionUID = this.getSerialVersionUID();
            buf.append(":");
            String serialID = Long.toHexString(serialVersionUID).toUpperCase();
            int i2 = 0;
            while (i2 + serialID.length() != 16) {
                buf.append('0');
                ++i2;
            }
            buf.append(serialID);
            this._repid = buf.toString();
        }
        return this._repid;
    }

    long getSerialVersionUID() {
        ObjectStreamClass serialForm;
        if (this._serial_version_uid_field != null) {
            try {
                return this._serial_version_uid_field.getLong(null);
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        return (serialForm = ObjectStreamClass.lookup(this.getJavaClass())) != null ? serialForm.getSerialVersionUID() : 0L;
    }

    public void init() {
        try {
            this.init0();
            if (this._fields == null) {
                throw new RuntimeException("fields==null after init!");
            }
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINE, "runtime error in ValueDescriptor.init " + ex.getMessage(), ex);
        }
        catch (Error ex) {
            logger.log(Level.FINE, "runtime error in ValueDescriptor.init " + ex.getMessage(), ex);
        }
    }

    public void init0() {
        TypeDescriptor superDesc;
        final Class type = this.getJavaClass();
        Class superClass = type.getSuperclass();
        this._is_rmi_stub = RMIStub.class.isAssignableFrom(type);
        this._is_externalizable = Externalizable.class.isAssignableFrom(type);
        this._is_serializable = Serializable.class.isAssignableFrom(type);
        this._is_immutable_value = _immutable_value_classes.contains(type);
        if (superClass != null && superClass != java.lang.Object.class && (superDesc = this.getTypeRepository().getDescriptor(superClass)) instanceof ValueDescriptor) {
            this._super_descriptor = (ValueDescriptor)superDesc;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                for (Class curr = type; curr != null; curr = curr.getSuperclass()) {
                    try {
                        ValueDescriptor.this._write_replace_method = curr.getDeclaredMethod("writeReplace", new Class[0]);
                        ValueDescriptor.this._write_replace_method.setAccessible(true);
                        break;
                    }
                    catch (NoSuchMethodException ex) {
                        continue;
                    }
                }
                try {
                    ValueDescriptor.this._read_resolve_method = type.getDeclaredMethod("readResolve", new Class[0]);
                    ValueDescriptor.this._read_resolve_method.setAccessible(true);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
                try {
                    ValueDescriptor.this._read_object_method = type.getDeclaredMethod("readObject", ObjectInputStream.class);
                    ValueDescriptor.this._read_object_method.setAccessible(true);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
                try {
                    ValueDescriptor.this._write_object_method = type.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                    ValueDescriptor.this._write_object_method.setAccessible(true);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
                if (ValueDescriptor.this._write_object_method == null || !Modifier.isPrivate(ValueDescriptor.this._write_object_method.getModifiers()) || Modifier.isStatic(ValueDescriptor.this._write_object_method.getModifiers()) || ValueDescriptor.this._write_object_method.getDeclaringClass() != ValueDescriptor.this.getJavaClass()) {
                    ValueDescriptor.this._write_object_method = null;
                }
                if (ValueDescriptor.this._read_object_method == null || !Modifier.isPrivate(ValueDescriptor.this._read_object_method.getModifiers()) || Modifier.isStatic(ValueDescriptor.this._read_object_method.getModifiers())) {
                    ValueDescriptor.this._read_object_method = null;
                }
                try {
                    ValueDescriptor.this._serial_version_uid_field = type.getDeclaredField("serialVersionUID");
                    if (Modifier.isStatic(ValueDescriptor.this._serial_version_uid_field.getModifiers())) {
                        ValueDescriptor.this._serial_version_uid_field.setAccessible(true);
                    } else {
                        ValueDescriptor.this._serial_version_uid_field = null;
                    }
                }
                catch (NoSuchFieldException ex) {
                    // empty catch block
                }
                ObjectStreamField[] serial_persistent_fields = null;
                try {
                    Field _serial_persistent_fields_field = type.getDeclaredField("serialPersistentFields");
                    _serial_persistent_fields_field.setAccessible(true);
                    serial_persistent_fields = (ObjectStreamField[])_serial_persistent_fields_field.get(null);
                }
                catch (IllegalAccessException ex) {
                }
                catch (NoSuchFieldException ex) {
                    // empty catch block
                }
                if (ValueDescriptor.this._is_externalizable) {
                    try {
                        ValueDescriptor.this._constructor = type.getDeclaredConstructor(new Class[0]);
                        ValueDescriptor.this._constructor.setAccessible(true);
                    }
                    catch (NoSuchMethodException ex) {
                        logger.log(Level.WARNING, "Class " + type.getName() + " is not properly externalizable.  " + "It has not default constructor.", ex);
                    }
                } else if (ValueDescriptor.this._is_serializable && !type.isInterface()) {
                    Class initClass;
                    for (initClass = type; initClass != null && Serializable.class.isAssignableFrom(initClass); initClass = initClass.getSuperclass()) {
                    }
                    if (initClass == null) {
                        logger.warning("Class " + type.getName() + " is not properly serializable.  " + "It has no non-serializable super-class");
                    } else {
                        try {
                            Constructor init_cons = initClass.getDeclaredConstructor(new Class[0]);
                            if (!(Modifier.isPublic(init_cons.getModifiers()) || Modifier.isProtected(init_cons.getModifiers()) || ValueDescriptor.this.samePackage(type, initClass))) {
                                logger.warning("Class " + type.getName() + " is not properly serializable.  " + "The default constructor of its first " + "non-serializable super-class (" + initClass.getName() + ") is not accessible.");
                            }
                            ValueDescriptor.this._constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(type, init_cons);
                            if (ValueDescriptor.this._constructor == null) {
                                logger.warning("Unable to get constructor for serialization for class " + ValueDescriptor.this.getJavaName());
                            } else {
                                ValueDescriptor.this._constructor.setAccessible(true);
                            }
                        }
                        catch (NoSuchMethodException ex) {
                            logger.log(Level.WARNING, "Class " + type.getName() + " is not properly serializable.  " + "First non-serializable super-class (" + initClass.getName() + ") has not default constructor.", ex);
                        }
                    }
                }
                if (serial_persistent_fields == null) {
                    Field[] ff = type.getDeclaredFields();
                    if (ff == null || ff.length == 0) {
                        ValueDescriptor.this._fields = new FieldDescriptor[0];
                    } else {
                        ArrayList<FieldDescriptor> flist = new ArrayList<FieldDescriptor>();
                        for (int i = 0; i < ff.length; ++i) {
                            Field f = ff[i];
                            int mod = f.getModifiers();
                            if (Modifier.isStatic(mod) || Modifier.isTransient(mod)) continue;
                            f.setAccessible(true);
                            FieldDescriptor fd = FieldDescriptor.get(f);
                            fd.setTypeRepository(ValueDescriptor.this.getTypeRepository());
                            flist.add(fd);
                        }
                        ValueDescriptor.this._fields = new FieldDescriptor[flist.size()];
                        ValueDescriptor.this._fields = flist.toArray(ValueDescriptor.this._fields);
                        Arrays.sort(ValueDescriptor.this._fields);
                    }
                } else {
                    ValueDescriptor.this._fields = new FieldDescriptor[serial_persistent_fields.length];
                    for (int i = 0; i < serial_persistent_fields.length; ++i) {
                        ObjectStreamField f = serial_persistent_fields[i];
                        FieldDescriptor fd = null;
                        try {
                            Field rf = type.getField(f.getName());
                            rf.setAccessible(true);
                            if (rf.getType() == f.getType()) {
                                fd = FieldDescriptor.get(rf);
                            }
                        }
                        catch (SecurityException ex) {
                        }
                        catch (NoSuchFieldException ex) {
                            // empty catch block
                        }
                        if (fd == null) {
                            fd = FieldDescriptor.get(type, f);
                        }
                        fd.setTypeRepository(ValueDescriptor.this.getTypeRepository());
                        ValueDescriptor.this._fields[i] = fd;
                    }
                    Arrays.sort(ValueDescriptor.this._fields);
                }
                ValueDescriptor.this._hash_code = ValueDescriptor.this.computeHashCode();
                ValueDescriptor.this._object_deserializer = new ObjectDeserializer(ValueDescriptor.this);
                return null;
            }
        });
    }

    private boolean samePackage(Class type, Class initClass) {
        String pkg1 = this.getPackageName(type);
        String pkg2 = this.getPackageName(initClass);
        return pkg1.equals(pkg2);
    }

    private String getPackageName(Class type) {
        String name = type.getName();
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return name.substring(0, idx);
    }

    public java.lang.Object read(org.omg.CORBA.portable.InputStream in) {
        InputStream _in = (InputStream)in;
        return _in.read_value();
    }

    public void write(org.omg.CORBA.portable.OutputStream out, java.lang.Object value) {
        OutputStream _out = (OutputStream)out;
        _out.write_value((Serializable)value);
    }

    public boolean isCustomMarshalled() {
        if (this._is_externalizable) {
            return true;
        }
        return this._write_object_method != null;
    }

    public Serializable writeReplace(Serializable val) {
        if (this._write_replace_method != null) {
            try {
                return (Serializable)this._write_replace_method.invoke((java.lang.Object)val, NO_ARGS);
            }
            catch (IllegalAccessException ex) {
                throw (MARSHAL)new MARSHAL("cannot call " + this._write_replace_method).initCause((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnknownException(ex.getTargetException());
            }
        }
        return val;
    }

    public Serializable readResolve(Serializable val) {
        if (this._read_resolve_method != null) {
            try {
                return (Serializable)this._read_resolve_method.invoke((java.lang.Object)val, NO_ARGS);
            }
            catch (IllegalAccessException ex) {
                throw (MARSHAL)new MARSHAL("cannot call " + this._read_resolve_method).initCause((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnknownException(ex.getTargetException());
            }
        }
        return val;
    }

    public void writeValue(final org.omg.CORBA.portable.OutputStream out, final Serializable value) {
        try {
            ObjectWriter writer = (ObjectWriter)AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    try {
                        return new CorbaObjectWriter(out, value);
                    }
                    catch (IOException ex) {
                        throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
                    }
                }
            });
            this.writeValue(writer, value);
        }
        catch (IOException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    protected void defaultWriteValue(ObjectWriter writer, Serializable val) throws IOException {
        logger.finer("writing fields for " + this.getJavaClass());
        FieldDescriptor[] fields = this._fields;
        if (fields == null) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            logger.finer("writing field " + this._fields[i].getJavaName());
            fields[i].write(writer, val);
        }
    }

    protected void writeValue(ObjectWriter writer, Serializable val) throws IOException {
        if (this._is_externalizable) {
            writer.invokeWriteExternal((Externalizable)val);
            return;
        }
        if (this._super_descriptor != null) {
            this._super_descriptor.writeValue(writer, val);
        }
        if (this._write_object_method != null) {
            try {
                writer.invokeWriteObject(this, val, this._write_object_method);
            }
            catch (IllegalAccessException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnknownException(ex.getTargetException());
            }
        } else {
            this.defaultWriteValue(writer, val);
        }
    }

    public Serializable createBlankInstance() {
        if (this._constructor != null) {
            try {
                return (Serializable)this._constructor.newInstance(new java.lang.Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw (MARSHAL)new MARSHAL("cannot call " + this._constructor).initCause((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InstantiationException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnknownException(ex.getTargetException());
            }
            catch (NullPointerException ex) {
                logger.log(Level.WARNING, "unable to create instance of " + this.getJavaClass().getName(), ex);
                logger.warning("constructor => " + this._constructor);
                throw ex;
            }
        }
        return null;
    }

    public Serializable readValue(final org.omg.CORBA.portable.InputStream in, final Map offsetMap, Integer offset) {
        final Serializable value = this.createBlankInstance();
        offsetMap.put(offset, value);
        try {
            ObjectReader reader = (ObjectReader)AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    try {
                        return new CorbaObjectReader(in, offsetMap, value);
                    }
                    catch (IOException ex) {
                        throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
                    }
                }
            });
            this.readValue(reader, value);
            return this.readResolve(value);
        }
        catch (IOException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    void print(PrintWriter pw, Map recurse, java.lang.Object val) {
        Integer old;
        if (val == null) {
            pw.print("null");
        }
        if ((old = (Integer)recurse.get(val)) != null) {
            pw.print("^" + old);
        } else {
            Integer key = new Integer(System.identityHashCode(val));
            recurse.put(val, key);
            pw.println(this.getJavaClass().getName() + "@" + Integer.toHexString(key) + "[");
            this.printFields(pw, recurse, val);
            pw.println("]");
        }
    }

    void printFields(PrintWriter pw, Map recurse, java.lang.Object val) {
        pw.print("(" + this.getClass().getName() + ")");
        if (this._super_descriptor != null) {
            this._super_descriptor.printFields(pw, recurse, val);
        }
        if (this._fields == null) {
            return;
        }
        for (int i = 0; i < this._fields.length; ++i) {
            if (i != 0) {
                pw.print("; ");
            }
            this._fields[i].print(pw, recurse, val);
        }
    }

    protected void defaultReadValue(ObjectReader reader, Serializable value) throws IOException {
        if (this._fields == null) {
            return;
        }
        logger.fine("reading fields for " + this.getJavaClass().getName());
        for (int i = 0; i < this._fields.length; ++i) {
            logger.fine("reading field " + this._fields[i].getJavaName() + " of type " + this._fields[i].getType().getName() + " using " + this._fields[i].getClass().getName());
            try {
                this._fields[i].read(reader, value);
                continue;
            }
            catch (MARSHAL ex) {
                if (ex.getMessage() == null) {
                    MARSHAL exx = new MARSHAL(ex.getMessage() + ", while reading " + this.getJavaName() + "." + this._fields[i].getJavaName(), ex.minor, ex.completed);
                    exx.initCause((Throwable)ex);
                    throw exx;
                }
                throw ex;
            }
        }
    }

    Map readFields(ObjectReader reader) throws IOException {
        if (this._fields == null || this._fields.length == 0) {
            return Collections.EMPTY_MAP;
        }
        logger.finer("reading fields for " + this.getJavaClass().getName());
        HashMap map = new HashMap();
        for (int i = 0; i < this._fields.length; ++i) {
            logger.finer("reading field " + this._fields[i].getJavaName());
            this._fields[i].readFieldIntoMap(reader, map);
        }
        return map;
    }

    void writeFields(ObjectWriter writer, Map fieldMap) throws IOException {
        if (this._fields == null || this._fields.length == 0) {
            return;
        }
        logger.finer("writing fields for " + this.getJavaClass().getName());
        for (int i = 0; i < this._fields.length; ++i) {
            logger.finer("writing field " + this._fields[i].getJavaName());
            this._fields[i].writeFieldFromMap(writer, fieldMap);
        }
    }

    protected void readValue(ObjectReader reader, Serializable value) throws IOException {
        if (this._is_externalizable) {
            Externalizable ext = (Externalizable)value;
            try {
                reader.readExternal(ext);
            }
            catch (ClassNotFoundException e) {
                IOException ex = new IOException("cannot instantiate class");
                ex.initCause(e);
                throw ex;
            }
            return;
        }
        if (this._super_descriptor != null) {
            this._super_descriptor.readValue(reader, value);
        }
        if (this.isCustomMarshalled()) {
            byte streamFormatVersion = reader.readByte();
            boolean writeDefaultStateCalled = reader.readBoolean();
            logger.log(Level.FINE, "Reading value in streamFormatVersion=" + streamFormatVersion + " IsCalleddefaultWriteObject=" + writeDefaultStateCalled);
        }
        if (this._read_object_method != null) {
            try {
                reader.setCurrentValueDescriptor(this);
                this._read_object_method.invoke((java.lang.Object)value, reader);
                reader.setCurrentValueDescriptor(null);
            }
            catch (IllegalAccessException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnknownException(ex.getTargetException());
            }
        } else {
            this.defaultReadValue(reader, value);
        }
    }

    protected long computeHashCode() {
        Class type = this.getJavaClass();
        long hash = 0L;
        if (this._is_externalizable) {
            return 1L;
        }
        if (!Serializable.class.isAssignableFrom(type)) {
            return 0L;
        }
        try {
            int i;
            ByteArrayOutputStream barr = new ByteArrayOutputStream(512);
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream digestout = new DigestOutputStream(barr, md);
            DataOutputStream out = new DataOutputStream(digestout);
            Class superType = type.getSuperclass();
            if (superType != null) {
                TypeDescriptor desc = this.getTypeRepository().getDescriptor(superType);
                out.writeLong(desc.getHashCode());
            }
            if (this._write_object_method == null) {
                out.writeInt(1);
            } else {
                out.writeInt(2);
            }
            FieldDescriptor[] fds = new FieldDescriptor[this._fields.length];
            for (i = 0; i < this._fields.length; ++i) {
                fds[i] = this._fields[i];
            }
            if (fds.length > 1) {
                Arrays.sort(fds, compareByName);
            }
            for (i = 0; i < fds.length; ++i) {
                FieldDescriptor f = fds[i];
                out.writeUTF(f.getJavaName());
                out.writeUTF(this.makeSignature(f.getType()));
            }
            out.flush();
            byte[] data = md.digest();
            int end = Math.min(8, data.length);
            for (int j = 0; j < end; ++j) {
                hash += (long)(data[j] & 0xFF) << j * 8;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot compute RMI hash code", ex);
        }
        return hash;
    }

    long getHashCode() {
        return this._hash_code;
    }

    ValueMember[] getValueMembers() {
        if (this._value_members == null) {
            this._value_members = new ValueMember[this._fields.length];
            for (int i = 0; i < this._fields.length; ++i) {
                this._value_members[i] = this._fields[i].getValueMember(this.getTypeRepository());
            }
        }
        return this._value_members;
    }

    TypeCode getTypeCode() {
        if (this._type_code != null) {
            return this._type_code;
        }
        ORB orb = ORB.init();
        this._type_code = orb.create_recursive_tc(this.getRepositoryID());
        TypeCode _base = this._super_descriptor == null ? null : this._super_descriptor.getTypeCode();
        Class javaClass = this.getJavaClass();
        if (!javaClass.isArray()) {
            this._type_code = orb.create_value_tc(this.getRepositoryID(), javaClass.getSimpleName(), (short)0, _base, this.getValueMembers());
        } else {
            TypeDescriptor desc = this.getTypeRepository().getDescriptor(javaClass.getComponentType());
            this._type_code = desc.getTypeCode();
            this._type_code = orb.create_sequence_tc(0, this._type_code);
            this._type_code = orb.create_value_box_tc(this.getRepositoryID(), "Sequence", this._type_code);
        }
        return this._type_code;
    }

    FullValueDescription getFullValueDescription() {
        return new FullValueDescription(this.getJavaClass().getName(), this.getRepositoryID(), false, this.isCustomMarshalled(), "", "1.0", new OperationDescription[]{}, new AttributeDescription[]{}, this.getValueMembers(), new Initializer[]{}, new String[]{}, new String[]{}, false, this._super_descriptor == null ? "" : this._super_descriptor.getRepositoryID(), this.getTypeCode());
    }

    ObjectDeserializer getObjectDeserializer(String repositoryID, RunTime runtime) throws IOException {
        if (repositoryID.equals(this.getRepositoryID())) {
            return this._object_deserializer;
        }
        CodeBase codebase = CodeBaseHelper.narrow((Object)runtime);
        if (codebase == null) {
            throw new IOException("cannot narrow RunTime -> CodeBase");
        }
        FullValueDescription desc = codebase.meta(repositoryID);
        return new ObjectDeserializer(desc, (RunTime)codebase);
    }

    static Class getClassFromTypeCode(TypeCode tc) {
        return null;
    }

    public boolean copyWithinState() {
        return !(this._is_immutable_value | this._is_rmi_stub);
    }

    java.lang.Object copyObject(java.lang.Object orig, CopyState state) {
        ValueDescriptor wdesc;
        if (this._is_immutable_value || this._is_rmi_stub) {
            return orig;
        }
        Serializable oorig = (Serializable)orig;
        logger.finer("copying " + orig);
        oorig = this.writeReplace(oorig);
        if (oorig != orig) {
            wdesc = (ValueDescriptor)this.getTypeRepository().getDescriptor(oorig.getClass());
            logger.finer("writeReplace -> " + this.getJavaClass().getName());
        } else {
            wdesc = this;
        }
        return wdesc.copyObject2(oorig, state);
    }

    Serializable copyObject2(Serializable oorig, CopyState state) {
        Serializable copy = this.createBlankInstance();
        state.put(oorig, copy);
        ObjectWriter writer = this.writeObject(oorig, state);
        return this.readObject(writer, copy);
    }

    ObjectWriter writeObject(Serializable oorig, CopyState state) {
        ObjectWriter writer = null;
        try {
            writer = state.createObjectWriter(oorig);
            this.writeValue(writer, oorig);
            return writer;
        }
        catch (IOException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    Serializable readObject(ObjectWriter writer, Serializable copy) {
        ObjectReader reader = writer.getObjectReader(copy);
        try {
            this.readValue(reader, copy);
        }
        catch (IOException ex) {
            MARSHAL m = new MARSHAL(ex.getMessage() + " reading instance of " + this.getJavaClass().getName());
            m.initCause((Throwable)ex);
            throw m;
        }
        return this.readResolve(copy);
    }

    void writeMarshalValue(PrintWriter pw, String outName, String paramName) {
        pw.print(outName);
        pw.print('.');
        pw.print("write_value");
        pw.print("((java.io.Serializable)");
        pw.print(paramName);
        pw.print(',');
        MethodDescriptor.writeJavaType(pw, this.getJavaClass());
        pw.print(".class)");
    }

    void writeUnmarshalValue(PrintWriter pw, String inName) {
        pw.print(inName);
        pw.print('.');
        pw.print("read_value");
        pw.print('(');
        MethodDescriptor.writeJavaType(pw, this.getJavaClass());
        pw.print(".class)");
    }

    void addDependencies(Set classes) {
        TypeDescriptor desc;
        int i;
        Class c = this.getJavaClass();
        if (c == java.lang.Object.class || classes.contains(c)) {
            return;
        }
        classes.add(c);
        if (c.getSuperclass() != null) {
            TypeDescriptor desc2 = this.getTypeRepository().getDescriptor(c.getSuperclass());
            desc2.addDependencies(classes);
        }
        Class<?>[] ifaces = c.getInterfaces();
        for (i = 0; i < ifaces.length; ++i) {
            desc = this.getTypeRepository().getDescriptor(ifaces[i]);
            desc.addDependencies(classes);
        }
        if (this._fields != null) {
            for (i = 0; i < this._fields.length; ++i) {
                if (this._fields[i].isPrimitive()) continue;
                desc = this.getTypeRepository().getDescriptor(this._fields[i].type);
                desc.addDependencies(classes);
            }
        }
    }

    static {
        NO_ARGS = new java.lang.Object[0];
        _immutable_value_classes = new HashSet();
        _immutable_value_classes.add(Integer.class);
        _immutable_value_classes.add(Character.class);
        _immutable_value_classes.add(Boolean.class);
        _immutable_value_classes.add(Byte.class);
        _immutable_value_classes.add(Long.class);
        _immutable_value_classes.add(Float.class);
        _immutable_value_classes.add(Double.class);
        _immutable_value_classes.add(Short.class);
        compareByName = new Comparator(){

            public int compare(java.lang.Object f1, java.lang.Object f2) {
                String n1 = ((FieldDescriptor)f1).getJavaName();
                String n2 = ((FieldDescriptor)f2).getJavaName();
                return n1.compareTo(n2);
            }
        };
    }

    class ObjectDeserializer {
        ObjectDeserializer super_descriptor;
        String repository_id;
        FieldDescriptor[] fields;

        ValueDescriptor localDescriptor() {
            return ValueDescriptor.this;
        }

        ObjectDeserializer(ValueDescriptor desc) {
            this.fields = desc._fields;
            this.repository_id = desc.getRepositoryID();
            if (desc._super_descriptor != null) {
                this.super_descriptor = desc._super_descriptor._object_deserializer;
            }
        }

        ObjectDeserializer(FullValueDescription desc, RunTime runtime) throws IOException {
            Class myClass = ValueDescriptor.this.getJavaClass();
            ValueMember[] members = desc.members;
            this.fields = new FieldDescriptor[members.length];
            for (int i = 0; i < members.length; ++i) {
                Class type = ValueDescriptor.getClassFromTypeCode(members[i].type);
                this.fields[i] = FieldDescriptor.get(myClass, type, members[i].name, null);
            }
            if (!"".equals(desc.base_value)) {
                Class clz = ValueHandlerImpl.getClassFromRepositoryID(desc.base_value);
                TypeDescriptor tdesc = ValueDescriptor.this.getTypeRepository().getDescriptor(clz);
                if (tdesc != null && tdesc instanceof ValueDescriptor) {
                    this.super_descriptor = ((ValueDescriptor)tdesc).getObjectDeserializer(desc.base_value, runtime);
                }
            }
        }
    }
}

