/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.rmi.CORBA.ClassDesc;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.omg.CORBA.MARSHAL;

public class ClassDescriptor
extends ValueDescriptor {
    static Logger logger = Logger.getLogger(ClassDescriptor.class.getName());
    Field repid_field;
    Field codebase_field;
    String _repid_arr;

    ClassDescriptor(TypeRepository repository) {
        super(ClassDesc.class, repository);
    }

    public void init() {
        super.init();
        Class<ClassDesc> clz = ClassDesc.class;
        try {
            this.repid_field = clz.getDeclaredField("repid");
            this.repid_field.setAccessible(true);
            this.codebase_field = clz.getDeclaredField("codebase");
            this.codebase_field.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            throw new MARSHAL("no such field: " + ex);
        }
        ValueDescriptor class_desc = new ValueDescriptor(Class.class, this.getTypeRepository());
        class_desc.init();
        this._repid_arr = class_desc.getRepositoryID();
    }

    public String getRepositoryIDForArray() {
        return this._repid_arr;
    }

    Object copyObject(Object orig, CopyState state) {
        state.put(orig, orig);
        return orig;
    }

    public Serializable readResolve(Serializable value) {
        final ClassDesc desc = (ClassDesc)value;
        Serializable result = (Serializable)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String className = "<unknown>";
                try {
                    String repid = (String)ClassDescriptor.this.repid_field.get(desc);
                    String codebase = (String)ClassDescriptor.this.codebase_field.get(desc);
                    int beg = repid.indexOf(58);
                    int end = repid.indexOf(58, beg + 1);
                    className = repid.substring(beg + 1, end);
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    return Util.loadClass((String)className, (String)codebase, (ClassLoader)loader);
                }
                catch (ClassNotFoundException ex) {
                    throw (MARSHAL)new MARSHAL("cannot load class " + className).initCause((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw (MARSHAL)new MARSHAL("no such field: " + ex).initCause((Throwable)ex);
                }
            }
        });
        logger.fine("readResolve " + value + " => " + result);
        return result;
    }

    public Serializable writeReplace(Serializable value) {
        final Class type = (Class)value;
        final ClassDesc desc = new ClassDesc();
        return (Serializable)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ValueHandler handler = Util.createValueHandler();
                    String repId = handler.getRMIRepositoryID(type);
                    ClassDescriptor.this.repid_field.set(desc, repId);
                    String codebase = Util.getCodebase((Class)type);
                    ClassDescriptor.this.codebase_field.set(desc, codebase);
                    return desc;
                }
                catch (IllegalAccessException ex) {
                    throw (MARSHAL)new MARSHAL("no such field: " + ex).initCause((Throwable)ex);
                }
            }
        });
    }
}

